/*
 * Decompiled with CFR 0.152.
 */
package com.github.alkedr.matchers.reporting;

import com.github.alkedr.matchers.reporting.AbsentMatcher;
import com.github.alkedr.matchers.reporting.MergingMatcher;
import com.github.alkedr.matchers.reporting.NoOpMatcher;
import com.github.alkedr.matchers.reporting.PresentMatcher;
import com.github.alkedr.matchers.reporting.ReportingMatcher;
import com.github.alkedr.matchers.reporting.ReportingMatcherAdapter;
import com.github.alkedr.matchers.reporting.SequenceMatcher;
import com.github.alkedr.matchers.reporting.SubValuesMatcher;
import com.github.alkedr.matchers.reporting.sub.value.checkers.SubValueCheckers;
import com.github.alkedr.matchers.reporting.sub.value.checkers.SubValuesChecker;
import com.github.alkedr.matchers.reporting.sub.value.extractors.SubValuesExtractor;
import com.github.alkedr.matchers.reporting.sub.value.extractors.SubValuesExtractors;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public enum ReportingMatchers {


    public static <T> ReportingMatcher<T> noOp() {
        return NoOpMatcher.INSTANCE;
    }

    public static <T> ReportingMatcher<T> toReportingMatcher(Matcher<T> matcher) {
        return matcher instanceof ReportingMatcher ? (ReportingMatcher)matcher : new ReportingMatcherAdapter<T>(matcher);
    }

    public static <U> Iterable<ReportingMatcher<? super U>> toReportingMatchers(Iterable<? extends Matcher<? super U>> matchers) {
        ArrayList<ReportingMatcher<U>> result = new ArrayList<ReportingMatcher<U>>();
        for (Matcher<U> matcher : matchers) {
            result.add(ReportingMatchers.toReportingMatcher(matcher));
        }
        return result;
    }

    @SafeVarargs
    public static <T> ReportingMatcher<T> sequence(ReportingMatcher<? super T> ... matchers) {
        return ReportingMatchers.sequence(Arrays.asList(matchers));
    }

    public static <T> ReportingMatcher<T> sequence(Iterable<? extends ReportingMatcher<? super T>> matchers) {
        return new SequenceMatcher(matchers);
    }

    @SafeVarargs
    public static <T> ReportingMatcher<T> merge(ReportingMatcher<? super T> ... matchers) {
        return ReportingMatchers.merge(Arrays.asList(matchers));
    }

    public static <T> ReportingMatcher<T> merge(Iterable<? extends ReportingMatcher<? super T>> matchers) {
        return new MergingMatcher<T>(ReportingMatchers.sequence(matchers));
    }

    public static <T> ReportingMatcher<T> present() {
        return PresentMatcher.INSTANCE;
    }

    public static <T> ReportingMatcher<T> absent() {
        return AbsentMatcher.INSTANCE;
    }

    public static <T, S> ReportingMatcher<T> value(SubValuesExtractor<T, S> subValuesExtractor, S value) {
        return ReportingMatchers.value(subValuesExtractor, CoreMatchers.equalTo(value));
    }

    public static <T, S> ReportingMatcher<T> value(SubValuesExtractor<T, S> subValuesExtractor, Matcher<? super S> matcher) {
        return ReportingMatchers.value(subValuesExtractor, ReportingMatchers.toReportingMatcher(matcher));
    }

    public static <T, S> ReportingMatcher<T> value(SubValuesExtractor<T, S> subValuesExtractor, ReportingMatcher<? super S> reportingMatcher) {
        return ReportingMatchers.subValuesMatcher(subValuesExtractor, SubValueCheckers.matcherSubValuesChecker(reportingMatcher));
    }

    @SafeVarargs
    public static <T, S> ReportingMatcher<T> value(SubValuesExtractor<T, S> subValuesExtractor, Matcher<? super S> ... matchers) {
        return ReportingMatchers.value(subValuesExtractor, Arrays.asList(matchers));
    }

    public static <T, S> ReportingMatcher<T> value(SubValuesExtractor<T, S> subValuesExtractor, Iterable<? extends Matcher<? super S>> matchers) {
        return ReportingMatchers.value(subValuesExtractor, ReportingMatchers.merge(ReportingMatchers.toReportingMatchers(matchers)));
    }

    public static <T, S> ReportingMatcher<T> value(String nameForReport, SubValuesExtractor<T, S> subValuesExtractor, S value) {
        return ReportingMatchers.value(SubValuesExtractors.renamed(subValuesExtractor, nameForReport), value);
    }

    public static <T, S> ReportingMatcher<T> value(String nameForReport, SubValuesExtractor<T, S> subValuesExtractor, Matcher<? super S> matcher) {
        return ReportingMatchers.value(SubValuesExtractors.renamed(subValuesExtractor, nameForReport), matcher);
    }

    public static <T, S> ReportingMatcher<T> value(String nameForReport, SubValuesExtractor<T, S> subValuesExtractor, ReportingMatcher<? super S> reportingMatcher) {
        return ReportingMatchers.value(SubValuesExtractors.renamed(subValuesExtractor, nameForReport), reportingMatcher);
    }

    @SafeVarargs
    public static <T, S> ReportingMatcher<T> value(String nameForReport, SubValuesExtractor<T, S> subValuesExtractor, Matcher<? super S> ... matchers) {
        return ReportingMatchers.value(SubValuesExtractors.renamed(subValuesExtractor, nameForReport), matchers);
    }

    public static <T, S> ReportingMatcher<T> value(String nameForReport, SubValuesExtractor<T, S> subValuesExtractor, Iterable<? extends Matcher<? super S>> matchers) {
        return ReportingMatchers.value(SubValuesExtractors.renamed(subValuesExtractor, nameForReport), matchers);
    }

    public static <T, S> ReportingMatcher<T> field(Field field, S value) {
        return ReportingMatchers.value(SubValuesExtractors.field(field), value);
    }

    public static <T, S> ReportingMatcher<T> field(Field field, Matcher<? super S> matcher) {
        return ReportingMatchers.value(SubValuesExtractors.field(field), matcher);
    }

    public static <T, S> ReportingMatcher<T> field(Field field, ReportingMatcher<? super S> reportingMatcher) {
        return ReportingMatchers.value(SubValuesExtractors.field(field), reportingMatcher);
    }

    @SafeVarargs
    public static <T, S> ReportingMatcher<T> field(Field field, Matcher<? super S> ... matchers) {
        return ReportingMatchers.value(SubValuesExtractors.field(field), matchers);
    }

    public static <T, S> ReportingMatcher<T> field(Field field, Iterable<? extends Matcher<? super S>> matchers) {
        return ReportingMatchers.value(SubValuesExtractors.field(field), matchers);
    }

    public static <T, S> ReportingMatcher<T> field(String fieldName, S value) {
        return ReportingMatchers.value(SubValuesExtractors.fieldByName(fieldName), value);
    }

    public static <T, S> ReportingMatcher<T> field(String fieldName, Matcher<? super S> matcher) {
        return ReportingMatchers.value(SubValuesExtractors.fieldByName(fieldName), matcher);
    }

    public static <T, S> ReportingMatcher<T> field(String fieldName, ReportingMatcher<? super S> reportingMatcher) {
        return ReportingMatchers.value(SubValuesExtractors.fieldByName(fieldName), reportingMatcher);
    }

    @SafeVarargs
    public static <T, S> ReportingMatcher<T> field(String fieldName, Matcher<? super S> ... matchers) {
        return ReportingMatchers.value(SubValuesExtractors.fieldByName(fieldName), matchers);
    }

    public static <T, S> ReportingMatcher<T> field(String fieldName, Iterable<? extends Matcher<? super S>> matchers) {
        return ReportingMatchers.value(SubValuesExtractors.fieldByName(fieldName), matchers);
    }

    public static <T, S> ReportingMatcher<T> field(String nameForReport, Field field, S value) {
        return ReportingMatchers.value(nameForReport, SubValuesExtractors.field(field), value);
    }

    public static <T, S> ReportingMatcher<T> field(String nameForReport, Field field, Matcher<? super S> matcher) {
        return ReportingMatchers.value(nameForReport, SubValuesExtractors.field(field), matcher);
    }

    public static <T, S> ReportingMatcher<T> field(String nameForReport, Field field, ReportingMatcher<? super S> reportingMatcher) {
        return ReportingMatchers.value(nameForReport, SubValuesExtractors.field(field), reportingMatcher);
    }

    @SafeVarargs
    public static <T, S> ReportingMatcher<T> field(String nameForReport, Field field, Matcher<? super S> ... matchers) {
        return ReportingMatchers.value(nameForReport, SubValuesExtractors.field(field), matchers);
    }

    public static <T, S> ReportingMatcher<T> field(String nameForReport, Field field, Iterable<? extends Matcher<? super S>> matchers) {
        return ReportingMatchers.value(nameForReport, SubValuesExtractors.field(field), matchers);
    }

    public static <T, S> ReportingMatcher<T> field(String nameForReport, String fieldName, S value) {
        return ReportingMatchers.value(nameForReport, SubValuesExtractors.fieldByName(fieldName), value);
    }

    public static <T, S> ReportingMatcher<T> field(String nameForReport, String fieldName, Matcher<? super S> matcher) {
        return ReportingMatchers.value(nameForReport, SubValuesExtractors.fieldByName(fieldName), matcher);
    }

    public static <T, S> ReportingMatcher<T> field(String nameForReport, String fieldName, ReportingMatcher<? super S> reportingMatcher) {
        return ReportingMatchers.value(nameForReport, SubValuesExtractors.fieldByName(fieldName), reportingMatcher);
    }

    @SafeVarargs
    public static <T, S> ReportingMatcher<T> field(String nameForReport, String fieldName, Matcher<? super S> ... matchers) {
        return ReportingMatchers.value(nameForReport, SubValuesExtractors.fieldByName(fieldName), matchers);
    }

    public static <T, S> ReportingMatcher<T> field(String nameForReport, String fieldName, Iterable<? extends Matcher<? super S>> matchers) {
        return ReportingMatchers.value(nameForReport, SubValuesExtractors.fieldByName(fieldName), matchers);
    }

    public static <T, S> ReportingMatcher<T> method(MethodInvocation invocation, S value) {
        return ReportingMatchers.value(SubValuesExtractors.method(invocation.method, invocation.arguments), value);
    }

    public static <T, S> ReportingMatcher<T> method(MethodInvocation invocation, Matcher<? super S> matcher) {
        return ReportingMatchers.value(SubValuesExtractors.method(invocation.method, invocation.arguments), matcher);
    }

    public static <T, S> ReportingMatcher<T> method(MethodInvocation invocation, ReportingMatcher<? super S> reportingMatcher) {
        return ReportingMatchers.value(SubValuesExtractors.method(invocation.method, invocation.arguments), reportingMatcher);
    }

    @SafeVarargs
    public static <T, S> ReportingMatcher<T> method(MethodInvocation invocation, Matcher<? super S> ... matchers) {
        return ReportingMatchers.value(SubValuesExtractors.method(invocation.method, invocation.arguments), matchers);
    }

    public static <T, S> ReportingMatcher<T> method(MethodInvocation invocation, Iterable<? extends Matcher<? super S>> matchers) {
        return ReportingMatchers.value(SubValuesExtractors.method(invocation.method, invocation.arguments), matchers);
    }

    public static <T, S> ReportingMatcher<T> method(MethodByNameInvocation invocation, S value) {
        return ReportingMatchers.value(SubValuesExtractors.methodByName(invocation.methodName, invocation.arguments), value);
    }

    public static <T, S> ReportingMatcher<T> method(MethodByNameInvocation invocation, Matcher<? super S> matcher) {
        return ReportingMatchers.value(SubValuesExtractors.methodByName(invocation.methodName, invocation.arguments), matcher);
    }

    public static <T, S> ReportingMatcher<T> method(MethodByNameInvocation invocation, ReportingMatcher<? super S> reportingMatcher) {
        return ReportingMatchers.value(SubValuesExtractors.methodByName(invocation.methodName, invocation.arguments), reportingMatcher);
    }

    @SafeVarargs
    public static <T, S> ReportingMatcher<T> method(MethodByNameInvocation invocation, Matcher<? super S> ... matchers) {
        return ReportingMatchers.value(SubValuesExtractors.methodByName(invocation.methodName, invocation.arguments), matchers);
    }

    public static <T, S> ReportingMatcher<T> method(MethodByNameInvocation invocation, Iterable<? extends Matcher<? super S>> matchers) {
        return ReportingMatchers.value(SubValuesExtractors.methodByName(invocation.methodName, invocation.arguments), matchers);
    }

    public static <T, S> ReportingMatcher<T> method(String nameForReport, MethodInvocation invocation, S value) {
        return ReportingMatchers.value(nameForReport, SubValuesExtractors.method(invocation.method, invocation.arguments), value);
    }

    public static <T, S> ReportingMatcher<T> method(String nameForReport, MethodInvocation invocation, Matcher<? super S> matcher) {
        return ReportingMatchers.value(nameForReport, SubValuesExtractors.method(invocation.method, invocation.arguments), matcher);
    }

    public static <T, S> ReportingMatcher<T> method(String nameForReport, MethodInvocation invocation, ReportingMatcher<? super S> reportingMatcher) {
        return ReportingMatchers.value(nameForReport, SubValuesExtractors.method(invocation.method, invocation.arguments), reportingMatcher);
    }

    @SafeVarargs
    public static <T, S> ReportingMatcher<T> method(String nameForReport, MethodInvocation invocation, Matcher<? super S> ... matchers) {
        return ReportingMatchers.value(nameForReport, SubValuesExtractors.method(invocation.method, invocation.arguments), matchers);
    }

    public static <T, S> ReportingMatcher<T> method(String nameForReport, MethodInvocation invocation, Iterable<? extends Matcher<? super S>> matchers) {
        return ReportingMatchers.value(nameForReport, SubValuesExtractors.method(invocation.method, invocation.arguments), matchers);
    }

    public static <T, S> ReportingMatcher<T> method(String nameForReport, MethodByNameInvocation invocation, S value) {
        return ReportingMatchers.value(nameForReport, SubValuesExtractors.methodByName(invocation.methodName, invocation.arguments), value);
    }

    public static <T, S> ReportingMatcher<T> method(String nameForReport, MethodByNameInvocation invocation, Matcher<? super S> matcher) {
        return ReportingMatchers.value(nameForReport, SubValuesExtractors.methodByName(invocation.methodName, invocation.arguments), matcher);
    }

    public static <T, S> ReportingMatcher<T> method(String nameForReport, MethodByNameInvocation invocation, ReportingMatcher<? super S> reportingMatcher) {
        return ReportingMatchers.value(nameForReport, SubValuesExtractors.methodByName(invocation.methodName, invocation.arguments), reportingMatcher);
    }

    @SafeVarargs
    public static <T, S> ReportingMatcher<T> method(String nameForReport, MethodByNameInvocation invocation, Matcher<? super S> ... matchers) {
        return ReportingMatchers.value(nameForReport, SubValuesExtractors.methodByName(invocation.methodName, invocation.arguments), matchers);
    }

    public static <T, S> ReportingMatcher<T> method(String nameForReport, MethodByNameInvocation invocation, Iterable<? extends Matcher<? super S>> matchers) {
        return ReportingMatchers.value(nameForReport, SubValuesExtractors.methodByName(invocation.methodName, invocation.arguments), matchers);
    }

    public static MethodInvocation invocation(Method method, Object ... arguments) {
        return new MethodInvocation(method, arguments);
    }

    public static MethodByNameInvocation invocation(String methodName, Object ... arguments) {
        return new MethodByNameInvocation(methodName, arguments);
    }

    public static <T, S> ReportingMatcher<T> getter(Method method, S value) {
        return ReportingMatchers.value(SubValuesExtractors.getter(method), value);
    }

    public static <T, S> ReportingMatcher<T> getter(Method method, Matcher<? super S> matcher) {
        return ReportingMatchers.value(SubValuesExtractors.getter(method), matcher);
    }

    public static <T, S> ReportingMatcher<T> getter(Method method, ReportingMatcher<? super S> reportingMatcher) {
        return ReportingMatchers.value(SubValuesExtractors.getter(method), reportingMatcher);
    }

    @SafeVarargs
    public static <T, S> ReportingMatcher<T> getter(Method method, Matcher<? super S> ... matchers) {
        return ReportingMatchers.value(SubValuesExtractors.getter(method), matchers);
    }

    public static <T, S> ReportingMatcher<T> getter(Method method, Iterable<? extends Matcher<? super S>> matchers) {
        return ReportingMatchers.value(SubValuesExtractors.getter(method), matchers);
    }

    public static <T, S> ReportingMatcher<T> getter(String methodName, S value) {
        return ReportingMatchers.value(SubValuesExtractors.getterByName(methodName), value);
    }

    public static <T, S> ReportingMatcher<T> getter(String methodName, Matcher<? super S> matcher) {
        return ReportingMatchers.value(SubValuesExtractors.getterByName(methodName), matcher);
    }

    public static <T, S> ReportingMatcher<T> getter(String methodName, ReportingMatcher<? super S> reportingMatcher) {
        return ReportingMatchers.value(SubValuesExtractors.getterByName(methodName), reportingMatcher);
    }

    @SafeVarargs
    public static <T, S> ReportingMatcher<T> getter(String methodName, Matcher<? super S> ... matchers) {
        return ReportingMatchers.value(SubValuesExtractors.getterByName(methodName), matchers);
    }

    public static <T, S> ReportingMatcher<T> getter(String methodName, Iterable<? extends Matcher<? super S>> matchers) {
        return ReportingMatchers.value(SubValuesExtractors.getterByName(methodName), matchers);
    }

    public static <T> ReportingMatcher<T[]> arrayElement(int index, T value) {
        return ReportingMatchers.value(SubValuesExtractors.arrayElement(index), value);
    }

    public static <T> ReportingMatcher<T[]> arrayElement(int index, Matcher<? super T> matcher) {
        return ReportingMatchers.value(SubValuesExtractors.arrayElement(index), matcher);
    }

    public static <T> ReportingMatcher<T[]> arrayElement(int index, ReportingMatcher<? super T> reportingMatcher) {
        return ReportingMatchers.value(SubValuesExtractors.arrayElement(index), reportingMatcher);
    }

    @SafeVarargs
    public static <T> ReportingMatcher<T[]> arrayElement(int index, Matcher<? super T> ... matchers) {
        return ReportingMatchers.value(SubValuesExtractors.arrayElement(index), matchers);
    }

    public static <T> ReportingMatcher<T[]> arrayElement(int index, Iterable<? extends Matcher<? super T>> matchers) {
        return ReportingMatchers.value(SubValuesExtractors.arrayElement(index), matchers);
    }

    public static <T> ReportingMatcher<Iterable<T>> iterableElement(int index, T value) {
        return ReportingMatchers.value(SubValuesExtractors.iterableElement(index), value);
    }

    public static <T> ReportingMatcher<Iterable<T>> iterableElement(int index, Matcher<? super T> matcher) {
        return ReportingMatchers.value(SubValuesExtractors.iterableElement(index), matcher);
    }

    public static <T> ReportingMatcher<Iterable<T>> iterableElement(int index, ReportingMatcher<? super T> reportingMatcher) {
        return ReportingMatchers.value(SubValuesExtractors.iterableElement(index), reportingMatcher);
    }

    @SafeVarargs
    public static <T> ReportingMatcher<Iterable<T>> iterableElement(int index, Matcher<? super T> ... matchers) {
        return ReportingMatchers.value(SubValuesExtractors.iterableElement(index), matchers);
    }

    public static <T> ReportingMatcher<Iterable<T>> iterableElement(int index, Iterable<? extends Matcher<? super T>> matchers) {
        return ReportingMatchers.value(SubValuesExtractors.iterableElement(index), matchers);
    }

    public static <T> ReportingMatcher<List<T>> listElement(int index, T value) {
        return ReportingMatchers.value(SubValuesExtractors.listElement(index), value);
    }

    public static <T> ReportingMatcher<List<T>> listElement(int index, Matcher<? super T> matcher) {
        return ReportingMatchers.value(SubValuesExtractors.listElement(index), matcher);
    }

    public static <T> ReportingMatcher<List<T>> listElement(int index, ReportingMatcher<? super T> reportingMatcher) {
        return ReportingMatchers.value(SubValuesExtractors.listElement(index), reportingMatcher);
    }

    @SafeVarargs
    public static <T> ReportingMatcher<List<T>> listElement(int index, Matcher<? super T> ... matchers) {
        return ReportingMatchers.value(SubValuesExtractors.listElement(index), matchers);
    }

    public static <T> ReportingMatcher<List<T>> listElement(int index, Iterable<? extends Matcher<? super T>> matchers) {
        return ReportingMatchers.value(SubValuesExtractors.listElement(index), matchers);
    }

    public static <K, V> ReportingMatcher<Map<K, V>> entry(K key, V value) {
        return ReportingMatchers.value(SubValuesExtractors.hashMap(key), value);
    }

    public static <K, V> ReportingMatcher<Map<K, V>> entry(K key, Matcher<? super V> matcher) {
        return ReportingMatchers.value(SubValuesExtractors.hashMap(key), matcher);
    }

    public static <K, V> ReportingMatcher<Map<K, V>> entry(K key, ReportingMatcher<? super V> reportingMatcher) {
        return ReportingMatchers.value(SubValuesExtractors.hashMap(key), reportingMatcher);
    }

    @SafeVarargs
    public static <K, V> ReportingMatcher<Map<K, V>> entry(K key, Matcher<? super V> ... matchers) {
        return ReportingMatchers.value(SubValuesExtractors.hashMap(key), matchers);
    }

    public static <K, V> ReportingMatcher<Map<K, V>> entry(K key, Iterable<? extends Matcher<? super V>> matchers) {
        return ReportingMatchers.value(SubValuesExtractors.hashMap(key), matchers);
    }

    @SafeVarargs
    public static <T> ReportingMatcher<Iterable<T>> iterable(Supplier<SubValuesChecker> ... subValuesCheckerSuppliers) {
        return ReportingMatchers.iterable(Arrays.asList(subValuesCheckerSuppliers));
    }

    public static <T> ReportingMatcher<Iterable<T>> iterable(Iterable<Supplier<SubValuesChecker>> subValuesCheckerSuppliers) {
        return ReportingMatchers.subValuesMatcher(SubValuesExtractors.iterableElements(), subValuesCheckerSuppliers);
    }

    @SafeVarargs
    public static <T> ReportingMatcher<Iterator<T>> iterator(Supplier<SubValuesChecker> ... subValuesCheckerSuppliers) {
        return ReportingMatchers.iterator(Arrays.asList(subValuesCheckerSuppliers));
    }

    public static <T> ReportingMatcher<Iterator<T>> iterator(Iterable<Supplier<SubValuesChecker>> subValuesCheckerSuppliers) {
        return ReportingMatchers.subValuesMatcher(SubValuesExtractors.iteratorElements(), subValuesCheckerSuppliers);
    }

    @SafeVarargs
    public static <T> ReportingMatcher<T[]> array(Supplier<SubValuesChecker> ... subValuesCheckerSuppliers) {
        return ReportingMatchers.array(Arrays.asList(subValuesCheckerSuppliers));
    }

    public static <T> ReportingMatcher<T[]> array(Iterable<Supplier<SubValuesChecker>> subValuesCheckerSuppliers) {
        return ReportingMatchers.subValuesMatcher(SubValuesExtractors.arrayElements(), subValuesCheckerSuppliers);
    }

    @SafeVarargs
    public static <K, V> ReportingMatcher<Map<K, V>> hashMap(Supplier<SubValuesChecker> ... subValuesCheckerSuppliers) {
        return ReportingMatchers.hashMap(Arrays.asList(subValuesCheckerSuppliers));
    }

    public static <K, V> ReportingMatcher<Map<K, V>> hashMap(Iterable<Supplier<SubValuesChecker>> subValuesCheckerSuppliers) {
        return ReportingMatchers.subValuesMatcher(SubValuesExtractors.hashMapEntries(), subValuesCheckerSuppliers);
    }

    @SafeVarargs
    public static <T, S> ReportingMatcher<T> subValuesMatcher(SubValuesExtractor<T, S> subValuesExtractor, Supplier<SubValuesChecker> ... subValuesCheckerSuppliers) {
        return ReportingMatchers.subValuesMatcher(subValuesExtractor, Arrays.asList(subValuesCheckerSuppliers));
    }

    public static <T, S> ReportingMatcher<T> subValuesMatcher(SubValuesExtractor<T, S> subValuesExtractor, Iterable<Supplier<SubValuesChecker>> subValuesCheckerSuppliers) {
        return new SubValuesMatcher<T, S>(subValuesExtractor, SubValueCheckers.compositeSubValuesCheckerSupplier(subValuesCheckerSuppliers));
    }

    public static <T> ReportingMatcher<T> displayAll(SubValuesExtractor<T, ?> subValuesExtractor) {
        return new SubValuesMatcher(subValuesExtractor, SubValueCheckers.noOpSubValuesChecker());
    }

    public static class MethodByNameInvocation {
        final String methodName;
        final Object[] arguments;

        MethodByNameInvocation(String methodName, Object ... arguments) {
            this.methodName = methodName;
            this.arguments = arguments;
        }
    }

    public static class MethodInvocation {
        final Method method;
        final Object[] arguments;

        MethodInvocation(Method method, Object ... arguments) {
            this.method = method;
            this.arguments = arguments;
        }
    }
}

