/*
 * Decompiled with CFR 0.152.
 */
package com.github.alkedr.matchers.reporting;

import com.github.alkedr.matchers.reporting.ReportingMatcher;
import com.github.alkedr.matchers.reporting.reporters.SafeTreeReporter;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;

class ReportingMatcherAdapter<T>
extends BaseMatcher<T>
implements ReportingMatcher<T> {
    private final Matcher<T> regularMatcher;

    ReportingMatcherAdapter(Matcher<T> regularMatcher) {
        this.regularMatcher = regularMatcher;
    }

    @Override
    public void run(Object item, SafeTreeReporter safeTreeReporter) {
        boolean matches;
        try {
            matches = this.regularMatcher.matches(item);
        }
        catch (RuntimeException e) {
            safeTreeReporter.brokenCheck(StringDescription.toString(this.regularMatcher), e);
            return;
        }
        if (matches) {
            safeTreeReporter.passedCheck(StringDescription.toString(this.regularMatcher));
        } else {
            StringDescription mismatchDescription = new StringDescription();
            this.regularMatcher.describeMismatch(item, (Description)mismatchDescription);
            safeTreeReporter.failedCheck(StringDescription.toString(this.regularMatcher), mismatchDescription.toString());
        }
    }

    @Override
    public void runForAbsentItem(SafeTreeReporter safeTreeReporter) {
        safeTreeReporter.checkForAbsentItem(StringDescription.asString(this.regularMatcher));
    }

    public boolean matches(Object item) {
        return this.regularMatcher.matches(item);
    }

    public void describeTo(Description description) {
        this.regularMatcher.describeTo(description);
    }

    public void describeMismatch(Object item, Description description) {
        this.regularMatcher.describeMismatch(item, description);
    }
}

