/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.util;

import com.adrninistrator.javacg.common.JavaCGConstants;
import com.adrninistrator.javacg.dto.MethodInfo;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.BootstrapMethod;
import org.apache.bcel.classfile.BootstrapMethods;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantMethodHandle;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.generic.Type;

public class CommonUtil {
    public static boolean isInnerAnonymousClass(String className) {
        if (!className.contains("$")) {
            return false;
        }
        String[] array = className.split("\\$");
        if (array.length != 2) {
            return false;
        }
        return CommonUtil.isNumStr(array[1]);
    }

    public static boolean isNumStr(String str) {
        char[] charArray;
        if (str == null || str.isEmpty()) {
            return false;
        }
        for (char ch : charArray = str.toCharArray()) {
            if (ch >= '0' && ch <= '9') continue;
            return false;
        }
        return true;
    }

    public static String argumentList(Type[] arguments) {
        StringBuilder sb = new StringBuilder("(");
        for (int i = 0; i < arguments.length; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(arguments[i].toString());
        }
        sb.append(")");
        return sb.toString();
    }

    public static List<String> genImplClassMethodWithArgs(Method[] methods) {
        ArrayList<String> methodInfoList = new ArrayList<String>(methods.length);
        for (Method method : methods) {
            String methodName = method.getName();
            if (methodName.startsWith("<") || !method.isPublic() || method.isAbstract() || method.isStatic()) continue;
            methodInfoList.add(methodName + CommonUtil.argumentList(method.getArgumentTypes()));
        }
        return methodInfoList;
    }

    public static List<String> genInterfaceAbstractMethodWithArgs(Method[] methods) {
        ArrayList<String> methodInfoList = new ArrayList<String>(methods.length);
        for (Method method : methods) {
            if (!method.isAbstract()) continue;
            methodInfoList.add(method.getName() + CommonUtil.argumentList(method.getArgumentTypes()));
        }
        return methodInfoList;
    }

    public static String getLambdaOrigMethod(String lambdaMethod) {
        int indexLastLambda = lambdaMethod.lastIndexOf("lambda$");
        String tmpString = lambdaMethod.substring(indexLastLambda + JavaCGConstants.FLAG_LAMBDA_LENGTH);
        int indexDollar = tmpString.indexOf(36);
        return tmpString.substring(0, indexDollar);
    }

    public static int getFuncStartSourceLine(Method method) {
        LineNumberTable lineNumberTable = method.getLineNumberTable();
        if (lineNumberTable == null || lineNumberTable.getLineNumberTable() == null) {
            return 0;
        }
        return lineNumberTable.getLineNumberTable()[0].getLineNumber();
    }

    private static int getInitFuncStartSourceLine(JavaClass javaClass) {
        Method[] methods = javaClass.getMethods();
        if (methods == null) {
            return 0;
        }
        for (Method method : methods) {
            if (!"<init>".equals(method.getName())) continue;
            return CommonUtil.getFuncStartSourceLine(method);
        }
        return 0;
    }

    public static String getCanonicalPath(String filePath) {
        try {
            return new File(filePath).getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BootstrapMethod getBootstrapMethod(JavaClass javaClass, int index) {
        Attribute[] attributes;
        for (Attribute attribute : attributes = javaClass.getAttributes()) {
            BootstrapMethods bootstrapMethods;
            BootstrapMethod[] bootstrapMethodArray;
            if (!(attribute instanceof BootstrapMethods) || (bootstrapMethodArray = (bootstrapMethods = (BootstrapMethods)attribute).getBootstrapMethods()) == null || bootstrapMethodArray.length <= index) continue;
            return bootstrapMethodArray[index];
        }
        return null;
    }

    public static MethodInfo getBootstrapMethodMethod(BootstrapMethod bootstrapMethod, JavaClass javaClass) {
        for (int argIndex : bootstrapMethod.getBootstrapArguments()) {
            ConstantMethodHandle constantMethodHandle;
            MethodInfo methodInfo;
            Constant constantArg = javaClass.getConstantPool().getConstant(argIndex);
            if (!(constantArg instanceof ConstantMethodHandle) || (methodInfo = CommonUtil.getMethodFromConstantMethodHandle(constantMethodHandle = (ConstantMethodHandle)constantArg, javaClass)) == null) continue;
            return methodInfo;
        }
        return null;
    }

    public static MethodInfo getMethodFromConstantMethodHandle(ConstantMethodHandle constantMethodHandle, JavaClass javaClass) {
        ConstantPool constantPool = javaClass.getConstantPool();
        Constant constantCP = constantPool.getConstant(constantMethodHandle.getReferenceIndex());
        if (!(constantCP instanceof ConstantCP)) {
            System.err.println("### \u4e0d\u6ee1\u8db3instanceof ConstantCP " + constantCP.getClass().getName());
            return null;
        }
        ConstantCP constantClassAndMethod = (ConstantCP)constantCP;
        String className = constantPool.getConstantString(constantClassAndMethod.getClassIndex(), (byte)7);
        className = Utility.compactClassName((String)className, (boolean)false);
        Constant constantNAT = constantPool.getConstant(constantClassAndMethod.getNameAndTypeIndex());
        if (!(constantNAT instanceof ConstantNameAndType)) {
            System.err.println("### \u4e0d\u6ee1\u8db3instanceof ConstantNameAndType " + constantNAT.getClass().getName());
            return null;
        }
        ConstantNameAndType constantNameAndType = (ConstantNameAndType)constantNAT;
        String methodName = constantPool.constantToString(constantNameAndType.getNameIndex(), (byte)1);
        String methodArgs = constantPool.constantToString(constantNameAndType.getSignatureIndex(), (byte)1);
        if (methodName != null && methodArgs != null) {
            MethodInfo methodInfo = new MethodInfo();
            methodInfo.setClassName(className);
            methodInfo.setMethodName(methodName);
            Type[] types = Type.getArgumentTypes((String)methodArgs);
            methodInfo.setMethodArgumentTypes(types);
            return methodInfo;
        }
        System.err.println("### \u83b7\u53d6\u65b9\u6cd5\u4fe1\u606f\u5931\u8d25 " + javaClass.getClassName() + " " + className + " " + methodName + " " + methodArgs);
        return null;
    }

    private CommonUtil() {
        throw new IllegalStateException("illegal");
    }
}

