/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.stat;

import com.adrninistrator.javacg.dto.CallIdCounter;
import com.adrninistrator.javacg.dto.MethodCallDto;
import com.adrninistrator.javacg.dto.MethodInfo;
import com.adrninistrator.javacg.enums.CallTypeEnum;
import com.adrninistrator.javacg.extensions.code_parser.CustomCodeParserInterface;
import com.adrninistrator.javacg.util.CommonUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.BootstrapMethod;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantInvokeDynamic;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.generic.AnnotationEntryGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.ConstantPushInstruction;
import org.apache.bcel.generic.EmptyVisitor;
import org.apache.bcel.generic.INVOKEDYNAMIC;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConst;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ReturnInstruction;
import org.apache.bcel.generic.Type;
import org.apache.bcel.generic.Visitor;

public class MethodVisitor
extends EmptyVisitor {
    private JavaClass visitedClass;
    private MethodGen mg;
    private ConstantPoolGen cp;
    private String format;
    private List<MethodCallDto> methodCalls = new ArrayList<MethodCallDto>();
    private LineNumberTable lineNumberTable;
    private InstructionHandle ih;
    private Map<String, Set<String>> calleeMethodMap;
    private Map<String, Boolean> runnableImplClassMap;
    private Map<String, Boolean> callableImplClassMap;
    private Map<String, Boolean> threadChildClassMap;
    private Map<String, Set<String>> methodAnnotationMap;
    private CallIdCounter callIdCounter;
    private List<CustomCodeParserInterface> customCodeParserList;

    public MethodVisitor(MethodGen m, JavaClass jc) {
        this.visitedClass = jc;
        this.mg = m;
        this.cp = this.mg.getConstantPool();
        this.lineNumberTable = this.mg.getLineNumberTable(this.cp);
    }

    public void setCalleeMethodMap(Map<String, Set<String>> calleeMethodMap) {
        this.calleeMethodMap = calleeMethodMap;
    }

    public void setRunnableImplClassMap(Map<String, Boolean> runnableImplClassMap) {
        this.runnableImplClassMap = runnableImplClassMap;
    }

    public void setCallableImplClassMap(Map<String, Boolean> callableImplClassMap) {
        this.callableImplClassMap = callableImplClassMap;
    }

    public void setThreadChildClassMap(Map<String, Boolean> threadChildClassMap) {
        this.threadChildClassMap = threadChildClassMap;
    }

    public void setMethodAnnotationMap(Map<String, Set<String>> methodAnnotationMap) {
        this.methodAnnotationMap = methodAnnotationMap;
    }

    public void setCallIdCounter(CallIdCounter callIdCounter) {
        this.callIdCounter = callIdCounter;
    }

    public void setCustomCodeParserList(List<CustomCodeParserInterface> customCodeParserList) {
        this.customCodeParserList = customCodeParserList;
    }

    public void beforeStart() {
        String fullMethod = this.visitedClass.getClassName() + ":" + this.mg.getName() + CommonUtil.argumentList(this.mg.getArgumentTypes());
        this.handleAnnotationName(fullMethod);
        this.format = "M:%d " + fullMethod + " (%s)%s:%s%s";
    }

    private void handleAnnotationName(String fullMethod) {
        AnnotationEntryGen[] annotationEntryGens = this.mg.getAnnotationEntries();
        if (annotationEntryGens == null || annotationEntryGens.length == 0) {
            return;
        }
        Set<String> annotationNameSet = this.methodAnnotationMap.get(fullMethod);
        if (annotationNameSet != null) {
            return;
        }
        annotationNameSet = new HashSet<String>();
        for (AnnotationEntryGen annotationEntryGen : annotationEntryGens) {
            String annotationName = this.getAnnotationName(annotationEntryGen.getTypeName());
            annotationNameSet.add(annotationName);
        }
        this.methodAnnotationMap.put(fullMethod, annotationNameSet);
    }

    private String getAnnotationName(String origName) {
        String tmpName = origName.startsWith("L") && origName.endsWith(";") ? origName.substring(1, origName.length() - 1) : origName;
        return tmpName.replace("/", ".");
    }

    public List<MethodCallDto> start() {
        if (this.mg.isAbstract() || this.mg.isNative()) {
            return Collections.emptyList();
        }
        this.ih = this.mg.getInstructionList().getStart();
        while (this.ih != null) {
            Instruction i = this.ih.getInstruction();
            if (!this.visitInstruction(i)) {
                i.accept((Visitor)this);
            }
            this.ih = this.ih.getNext();
        }
        return this.methodCalls;
    }

    private boolean visitInstruction(Instruction i) {
        short opcode = i.getOpcode();
        return InstructionConst.getInstruction((int)opcode) != null && !(i instanceof ConstantPushInstruction) && !(i instanceof ReturnInstruction);
    }

    public void visitINVOKEVIRTUAL(INVOKEVIRTUAL i) {
        this.addMethodCalls("M", i.getReferenceType(this.cp).toString(), i.getMethodName(this.cp), i.getArgumentTypes(this.cp));
    }

    public void visitINVOKEINTERFACE(INVOKEINTERFACE i) {
        this.addMethodCalls("I", i.getReferenceType(this.cp).toString(), i.getMethodName(this.cp), i.getArgumentTypes(this.cp));
    }

    public void visitINVOKESPECIAL(INVOKESPECIAL i) {
        this.addMethodCalls("O", i.getReferenceType(this.cp).toString(), i.getMethodName(this.cp), i.getArgumentTypes(this.cp));
    }

    public void visitINVOKESTATIC(INVOKESTATIC i) {
        this.addMethodCalls("S", i.getReferenceType(this.cp).toString(), i.getMethodName(this.cp), i.getArgumentTypes(this.cp));
    }

    public void visitINVOKEDYNAMIC(INVOKEDYNAMIC i) {
        this.addMethodCalls("D", i.getType(this.cp).toString(), i.getMethodName(this.cp), i.getArgumentTypes(this.cp));
        Constant constantID = this.cp.getConstant(i.getIndex());
        if (!(constantID instanceof ConstantInvokeDynamic)) {
            return;
        }
        ConstantInvokeDynamic cid = (ConstantInvokeDynamic)constantID;
        BootstrapMethod bootstrapMethod = CommonUtil.getBootstrapMethod(this.visitedClass, cid.getBootstrapMethodAttrIndex());
        if (bootstrapMethod == null) {
            System.err.println("### \u65e0\u6cd5\u627e\u5230bootstrapMethod " + cid.getBootstrapMethodAttrIndex());
            return;
        }
        MethodInfo bootstrapMethodMethod = CommonUtil.getBootstrapMethodMethod(bootstrapMethod, this.visitedClass);
        if (bootstrapMethodMethod == null) {
            System.err.println("### \u65e0\u6cd5\u627e\u5230bootstrapMethod\u7684\u65b9\u6cd5\u4fe1\u606f " + this.visitedClass.getClassName() + " " + bootstrapMethod);
            return;
        }
        String callType = bootstrapMethodMethod.getMethodName().startsWith("lambda$") ? CallTypeEnum.CTE_LM.getType() : CallTypeEnum.CTE_ST.getType();
        this.addMethodCalls(callType, bootstrapMethodMethod.getClassName(), bootstrapMethodMethod.getMethodName(), bootstrapMethodMethod.getMethodArgumentTypes());
    }

    private void addMethodCalls(String type, String calleeClassName, String calleeMethodName, Type[] arguments) {
        String methodCall;
        String calleeMethodArgs = CommonUtil.argumentList(arguments);
        Set<String> calleeMethodWithArgsSet = this.calleeMethodMap.get(calleeClassName);
        if (calleeMethodWithArgsSet == null) {
            calleeMethodWithArgsSet = new HashSet<String>();
            this.calleeMethodMap.put(calleeClassName, calleeMethodWithArgsSet);
        }
        calleeMethodWithArgsSet.add(calleeMethodName + calleeMethodArgs);
        boolean skipRawMethodCall = false;
        if ("<init>".equals(calleeMethodName)) {
            Boolean recordedCallable;
            Boolean recordedRunnable = this.runnableImplClassMap.get(calleeClassName);
            if (recordedRunnable != null) {
                skipRawMethodCall = true;
                methodCall = String.format(this.format, this.callIdCounter.addAndGet(), CallTypeEnum.CTE_RIR.getType(), calleeClassName, calleeMethodName, calleeMethodArgs);
                MethodCallDto methodCallDto1 = MethodCallDto.genInstance(methodCall, this.getSourceLine());
                this.methodCalls.add(methodCallDto1);
                if (Boolean.FALSE.equals(recordedRunnable)) {
                    String runnableImplClassMethod = String.format("M:%d %s:%s%s (%s)%s:run()", this.callIdCounter.addAndGet(), calleeClassName, calleeMethodName, calleeMethodArgs, CallTypeEnum.CTE_RIR.getType(), calleeClassName);
                    MethodCallDto methodCallDto2 = MethodCallDto.genInstance(runnableImplClassMethod, 0);
                    this.methodCalls.add(methodCallDto2);
                    this.runnableImplClassMap.put(calleeClassName, Boolean.TRUE);
                }
            }
            if ((recordedCallable = this.callableImplClassMap.get(calleeClassName)) != null) {
                skipRawMethodCall = true;
                String methodCall2 = String.format(this.format, this.callIdCounter.addAndGet(), CallTypeEnum.CTE_CIC.getType(), calleeClassName, calleeMethodName, calleeMethodArgs);
                MethodCallDto methodCallDto1 = MethodCallDto.genInstance(methodCall2, this.getSourceLine());
                this.methodCalls.add(methodCallDto1);
                if (Boolean.FALSE.equals(recordedCallable)) {
                    String callableImplClassMethod = String.format("M:%d %s:%s%s (%s)%s:call()", this.callIdCounter.addAndGet(), calleeClassName, calleeMethodName, calleeMethodArgs, CallTypeEnum.CTE_CIC.getType(), calleeClassName);
                    MethodCallDto methodCallDto2 = MethodCallDto.genInstance(callableImplClassMethod, 0);
                    this.methodCalls.add(methodCallDto2);
                    this.callableImplClassMap.put(calleeClassName, Boolean.TRUE);
                }
            }
        } else if ("start".equals(calleeMethodName) && "()".equals(calleeMethodArgs) && Boolean.FALSE.equals(this.threadChildClassMap.get(calleeClassName))) {
            String threadChildClassMethod = String.format("M:%d %s:%s%s (%s)%s:run()", this.callIdCounter.addAndGet(), calleeClassName, calleeMethodName, calleeMethodArgs, CallTypeEnum.CTE_TSR.getType(), calleeClassName);
            MethodCallDto methodCallDto2 = MethodCallDto.genInstance(threadChildClassMethod, 0);
            this.methodCalls.add(methodCallDto2);
            this.threadChildClassMap.put(calleeClassName, Boolean.TRUE);
        }
        if (skipRawMethodCall) {
            return;
        }
        int callId = this.callIdCounter.addAndGet();
        methodCall = String.format(this.format, callId, type, calleeClassName, calleeMethodName, calleeMethodArgs);
        MethodCallDto methodCallDto = MethodCallDto.genInstance(methodCall, this.getSourceLine());
        this.methodCalls.add(methodCallDto);
        for (CustomCodeParserInterface customCodeParser : this.customCodeParserList) {
            customCodeParser.handleMethodCall(callId, calleeClassName, calleeMethodName, arguments, this.ih, this.mg);
        }
    }

    private int getSourceLine() {
        if (this.lineNumberTable == null) {
            return 0;
        }
        int sourceLine = this.lineNumberTable.getSourceLine(this.ih.getPosition());
        return Math.max(sourceLine, 0);
    }
}

