/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.stat;

import com.adrninistrator.javacg.dto.CallIdCounter;
import com.adrninistrator.javacg.dto.ClassInterfaceMethodInfo;
import com.adrninistrator.javacg.dto.ExtendsClassMethodInfo;
import com.adrninistrator.javacg.dto.MethodAttribute;
import com.adrninistrator.javacg.dto.MethodCallDto;
import com.adrninistrator.javacg.dto.TmpNode4ExtendsClassMethod;
import com.adrninistrator.javacg.enums.CallTypeEnum;
import com.adrninistrator.javacg.extensions.code_parser.CustomCodeParserInterface;
import com.adrninistrator.javacg.stat.ClassVisitor;
import com.adrninistrator.javacg.util.CommonUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class JCallGraph {
    public static final int INIT_SIZE_100 = 100;
    public static final int INIT_SIZE_500 = 500;
    public static final int INIT_SIZE_1000 = 1000;
    private static final String RUNNABLE_CLASS_NAME = Runnable.class.getName();
    private static final String CALLABLE_CLASS_NAME = Callable.class.getName();
    private static final String THREAD_CLASS_NAME = Thread.class.getName();
    private Map<String, Set<String>> calleeMethodMapGlobal;
    private Map<String, ClassInterfaceMethodInfo> classInterfaceMethodInfoMap;
    private Map<String, List<String>> interfaceMethodWithArgsMap;
    private Map<String, Boolean> runnableImplClassMap;
    private Map<String, Boolean> callableImplClassMap;
    private Map<String, Boolean> threadChildClassMap;
    private Map<String, Set<String>> methodAnnotationMap;
    private Set<String> extendsClassesSet;
    private Map<String, ExtendsClassMethodInfo> extendsClassMethodInfoMap;
    private Map<String, List<String>> childrenClassInfoMap;
    private CallIdCounter callIdCounter = CallIdCounter.newInstance();
    private List<CustomCodeParserInterface> customCodeParserList = new ArrayList<CustomCodeParserInterface>();
    private int jarNum = 0;

    public static void main(String[] args) {
        JCallGraph jCallGraph = new JCallGraph();
        jCallGraph.run(args);
    }

    public void addCustomCodeParser(CustomCodeParserInterface customCodeParser) {
        this.customCodeParserList.add(customCodeParser);
    }

    /*
     * Exception decompiling
     */
    public boolean run(String[] args) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 34[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void init() {
        this.classInterfaceMethodInfoMap = new HashMap<String, ClassInterfaceMethodInfo>(100);
        this.interfaceMethodWithArgsMap = new HashMap<String, List<String>>(100);
        this.runnableImplClassMap = new HashMap<String, Boolean>(100);
        this.callableImplClassMap = new HashMap<String, Boolean>(100);
        this.threadChildClassMap = new HashMap<String, Boolean>(100);
        this.methodAnnotationMap = new HashMap<String, Set<String>>(100);
        this.extendsClassesSet = new HashSet<String>(500);
        this.extendsClassMethodInfoMap = new HashMap<String, ExtendsClassMethodInfo>(500);
        this.childrenClassInfoMap = new HashMap<String, List<String>>(500);
    }

    private boolean handleOneJar(File jarFile, String jarFilePath, BufferedWriter resultWriter, BufferedWriter annotationOut) throws IOException {
        try (JarFile jar = new JarFile(jarFile);){
            this.writeResult(resultWriter, "J:" + this.jarNum + " " + jarFilePath);
            this.writeResult(resultWriter, "\n");
            this.init();
            if (!this.preHandleClasses(jarFilePath, jarFile)) {
                boolean bl = false;
                return bl;
            }
            Enumeration<JarEntry> enumeration = jar.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                if (jarEntry.isDirectory() || !jarEntry.getName().endsWith(".class")) continue;
                this.handleOneClass(jarFilePath, jarEntry, resultWriter);
            }
            if (!this.addInterfaceMethod4SuperClass()) {
                boolean bl = false;
                return bl;
            }
            if (!this.recordExtendsClassMethod(resultWriter)) {
                boolean bl = false;
                return bl;
            }
            this.recordInterfaceCallClassMethod(resultWriter);
            this.recordMethodAnnotationInfo(annotationOut);
            boolean bl = true;
            return bl;
        }
    }

    private void handleOneClass(String jarFilePath, JarEntry jarEntry, BufferedWriter resultWriter) throws IOException {
        ClassParser cp = new ClassParser(jarFilePath, jarEntry.getName());
        JavaClass javaClass = cp.parse();
        System.out.println("\u5904\u7406Class: " + javaClass.getClassName());
        if (javaClass.isClass() && this.extendsClassesSet.contains(javaClass.getClassName())) {
            this.findExtendsClassesInfo(javaClass);
        }
        ClassVisitor classVisitor = new ClassVisitor(javaClass);
        classVisitor.setCalleeMethodMap(this.calleeMethodMapGlobal);
        classVisitor.setRunnableImplClassMap(this.runnableImplClassMap);
        classVisitor.setCallableImplClassMap(this.callableImplClassMap);
        classVisitor.setThreadChildClassMap(this.threadChildClassMap);
        classVisitor.setMethodAnnotationMap(this.methodAnnotationMap);
        classVisitor.setCallIdCounter(this.callIdCounter);
        classVisitor.setCustomCodeParserList(this.customCodeParserList);
        classVisitor.start();
        List<MethodCallDto> methodCalls = classVisitor.methodCalls();
        for (MethodCallDto methodCallDto : methodCalls) {
            this.writeResult(resultWriter, methodCallDto.getMethodCall());
            if (methodCallDto.getSourceLine() != -1) {
                this.writeResult(resultWriter, " " + methodCallDto.getSourceLine());
                this.writeResult(resultWriter, " " + this.jarNum);
            }
            this.writeResult(resultWriter, "\n");
        }
        for (CustomCodeParserInterface customCodeParser : this.customCodeParserList) {
            customCodeParser.handleClass(javaClass);
        }
    }

    private boolean addInterfaceMethod4SuperClass() {
        for (Map.Entry<String, List<String>> childrenClassInfoEntry : this.childrenClassInfoMap.entrySet()) {
            ClassInterfaceMethodInfo classInterfaceMethodInfo;
            String superClassName = childrenClassInfoEntry.getKey();
            ExtendsClassMethodInfo extendsClassMethodInfo = this.extendsClassMethodInfoMap.get(superClassName);
            if (extendsClassMethodInfo == null || !extendsClassMethodInfo.isAbstractClass() || (classInterfaceMethodInfo = this.classInterfaceMethodInfoMap.get(superClassName)) == null) continue;
            Map<String, MethodAttribute> methodAttributeMap = extendsClassMethodInfo.getMethodAttributeMap();
            MethodAttribute methodAttribute = new MethodAttribute();
            methodAttribute.setAbstractMethod(true);
            methodAttribute.setPublicMethod(true);
            methodAttribute.setProtectedMethod(false);
            List<String> interfaceNameList = classInterfaceMethodInfo.getInterfaceNameList();
            for (String interfaceName : interfaceNameList) {
                List<String> interfaceMethodWithArgsList = this.interfaceMethodWithArgsMap.get(interfaceName);
                if (interfaceMethodWithArgsList == null) continue;
                for (String interfaceMethodWithArgs : interfaceMethodWithArgsList) {
                    methodAttributeMap.putIfAbsent(interfaceMethodWithArgs, methodAttribute);
                }
            }
        }
        return true;
    }

    private boolean recordExtendsClassMethod(BufferedWriter resultWriter) throws IOException {
        HashSet<String> topSuperClassNameSet = new HashSet<String>();
        for (Map.Entry<String, ExtendsClassMethodInfo> extendsClassMethodInfoEntry : this.extendsClassMethodInfoMap.entrySet()) {
            String className = extendsClassMethodInfoEntry.getKey();
            ExtendsClassMethodInfo extendsClassMethodInfo = extendsClassMethodInfoEntry.getValue();
            String superClassName = extendsClassMethodInfo.getSuperClassName();
            if (!superClassName.startsWith("java.")) continue;
            topSuperClassNameSet.add(className);
        }
        for (String topSuperClassName : topSuperClassNameSet) {
            if (this.handleOneTopSuperClass(topSuperClassName, resultWriter)) continue;
            return false;
        }
        return true;
    }

    private boolean handleOneTopSuperClass(String topSuperClassName, BufferedWriter resultWriter) throws IOException {
        System.out.println("\u5904\u7406\u4e00\u4e2a\u9876\u5c42\u7236\u7c7b: " + topSuperClassName);
        ArrayList<TmpNode4ExtendsClassMethod> tmpNodeList = new ArrayList<TmpNode4ExtendsClassMethod>();
        int currentLevel = 0;
        TmpNode4ExtendsClassMethod topNode = TmpNode4ExtendsClassMethod.genInstance(topSuperClassName, -1);
        tmpNodeList.add(topNode);
        while (true) {
            TmpNode4ExtendsClassMethod nextNode;
            TmpNode4ExtendsClassMethod currentNode;
            List<String> childrenClassInfoList;
            if ((childrenClassInfoList = this.childrenClassInfoMap.get((currentNode = (TmpNode4ExtendsClassMethod)tmpNodeList.get(currentLevel)).getSuperClassName())) == null) {
                System.err.println("### \u672a\u627e\u5230\u9876\u5c42\u7236\u7c7b: " + currentNode.getSuperClassName());
                return false;
            }
            int currentChildClassIndex = currentNode.getChildClassIndex() + 1;
            if (currentChildClassIndex >= childrenClassInfoList.size()) {
                if (currentLevel == 0) {
                    return true;
                }
                --currentLevel;
                continue;
            }
            String childClassName = childrenClassInfoList.get(currentChildClassIndex);
            if (!this.handleSuperAndChildClass(currentNode.getSuperClassName(), childClassName, resultWriter)) {
                return false;
            }
            currentNode.setChildClassIndex(currentChildClassIndex);
            List<String> nextChildClassList = this.childrenClassInfoMap.get(childClassName);
            if (nextChildClassList == null) continue;
            if (++currentLevel + 1 > tmpNodeList.size()) {
                nextNode = TmpNode4ExtendsClassMethod.genInstance(childClassName, -1);
                tmpNodeList.add(nextNode);
                continue;
            }
            nextNode = (TmpNode4ExtendsClassMethod)tmpNodeList.get(currentLevel);
            nextNode.setSuperClassName(childClassName);
            nextNode.setChildClassIndex(-1);
        }
    }

    private boolean handleSuperAndChildClass(String superClassName, String childClassName, BufferedWriter resultWriter) throws IOException {
        ExtendsClassMethodInfo superClassMethodInfo = this.extendsClassMethodInfoMap.get(superClassName);
        if (superClassMethodInfo == null) {
            System.err.println("### \u672a\u627e\u5230\u7236\u7c7b\u4fe1\u606f: " + superClassName);
            return false;
        }
        ExtendsClassMethodInfo childClassMethodInfo = this.extendsClassMethodInfoMap.get(childClassName);
        if (childClassMethodInfo == null) {
            System.err.println("### \u672a\u627e\u5230\u5b50\u7c7b\u4fe1\u606f: " + childClassName);
            return false;
        }
        Map<String, MethodAttribute> superMethodAttributeMap = superClassMethodInfo.getMethodAttributeMap();
        Map<String, MethodAttribute> childMethodAttributeMap = childClassMethodInfo.getMethodAttributeMap();
        for (Map.Entry<String, MethodAttribute> superMethodAttributeEntry : superMethodAttributeMap.entrySet()) {
            String superMethodWithArgs = superMethodAttributeEntry.getKey();
            MethodAttribute superMethodAttribute = superMethodAttributeEntry.getValue();
            if (superMethodAttribute.isAbstractMethod()) {
                childMethodAttributeMap.putIfAbsent(superMethodWithArgs, superMethodAttribute);
                String superCallChildClassMethod = String.format("M:%d %s:%s (%s)%s:%s %d", this.callIdCounter.addAndGet(), superClassName, superMethodWithArgs, CallTypeEnum.CTE_SCC.getType(), childClassName, superMethodWithArgs, 0);
                this.writeResult(resultWriter, superCallChildClassMethod);
                this.writeResult(resultWriter, " " + this.jarNum);
                this.writeResult(resultWriter, "\n");
                continue;
            }
            if (!superMethodAttribute.isPublicMethod() && !superMethodAttribute.isProtectedMethod() || childMethodAttributeMap.get(superMethodWithArgs) != null) continue;
            Set<String> childCalleeMethodWithArgsSet = this.calleeMethodMapGlobal.get(childClassName);
            if (!childClassMethodInfo.isAbstractClass() && (childCalleeMethodWithArgsSet == null || !childCalleeMethodWithArgsSet.contains(superMethodWithArgs))) continue;
            childMethodAttributeMap.put(superMethodWithArgs, superMethodAttribute);
            String childCallSuperClassMethod = String.format("M:%d %s:%s (%s)%s:%s %d", this.callIdCounter.addAndGet(), childClassName, superMethodWithArgs, CallTypeEnum.CTE_CCS.getType(), superClassName, superMethodWithArgs, 0);
            this.writeResult(resultWriter, childCallSuperClassMethod);
            this.writeResult(resultWriter, " " + this.jarNum);
            this.writeResult(resultWriter, "\n");
        }
        return true;
    }

    private void recordInterfaceCallClassMethod(BufferedWriter resultWriter) throws IOException {
        if (this.classInterfaceMethodInfoMap.isEmpty() || this.interfaceMethodWithArgsMap.isEmpty()) {
            return;
        }
        for (Map.Entry<String, ClassInterfaceMethodInfo> classMethodInfo : this.classInterfaceMethodInfoMap.entrySet()) {
            String className = classMethodInfo.getKey();
            ClassInterfaceMethodInfo classInterfaceMethodInfo = classMethodInfo.getValue();
            List<String> interfaceNameList = classInterfaceMethodInfo.getInterfaceNameList();
            for (String interfaceName : interfaceNameList) {
                List<String> interfaceMethodWithArgsList;
                Set<String> calleeMethodWithArgsSet = this.calleeMethodMapGlobal.get(interfaceName);
                if (calleeMethodWithArgsSet == null || (interfaceMethodWithArgsList = this.interfaceMethodWithArgsMap.get(interfaceName)) == null || interfaceMethodWithArgsList.isEmpty()) continue;
                List<String> classMethodWithArgsList = classInterfaceMethodInfo.getMethodWithArgsList();
                for (String classMethodWithArgs : classMethodWithArgsList) {
                    if (!interfaceMethodWithArgsList.contains(classMethodWithArgs) || !calleeMethodWithArgsSet.contains(classMethodWithArgs)) continue;
                    String interfaceCallClassMethod = String.format("M:%d %s:%s (%s)%s:%s %d", this.callIdCounter.addAndGet(), interfaceName, classMethodWithArgs, CallTypeEnum.CTE_ITF.getType(), className, classMethodWithArgs, 0);
                    this.writeResult(resultWriter, interfaceCallClassMethod);
                    this.writeResult(resultWriter, " " + this.jarNum);
                    this.writeResult(resultWriter, "\n");
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean preHandleClasses(String jarFilePath, File jarFile) {
        try (JarFile jar = new JarFile(jarFile);){
            Enumeration<JarEntry> enumeration = jar.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                if (jarEntry.isDirectory()) continue;
                if (jarEntry.getName().endsWith(".class")) {
                    this.preHandleOneFile(jarFilePath, jarEntry);
                }
                for (CustomCodeParserInterface customCodeParser : this.customCodeParserList) {
                    customCodeParser.handleJarEntryFile(jar, jarEntry);
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void preHandleOneFile(String jarFilePath, JarEntry jarEntry) throws IOException {
        Method[] methods;
        ClassParser cp = new ClassParser(jarFilePath, jarEntry.getName());
        JavaClass javaClass = cp.parse();
        String className = javaClass.getClassName();
        if (javaClass.isClass()) {
            this.preHandleClass(javaClass);
        } else if (javaClass.isInterface() && (methods = javaClass.getMethods()) != null && methods.length > 0 && this.interfaceMethodWithArgsMap.get(className) == null) {
            List<String> interfaceMethodWithArgsList = CommonUtil.genInterfaceAbstractMethodWithArgs(methods);
            this.interfaceMethodWithArgsMap.put(className, interfaceMethodWithArgsList);
        }
        String superClassName = javaClass.getSuperclassName();
        if (THREAD_CLASS_NAME.equals(superClassName)) {
            this.threadChildClassMap.put(javaClass.getClassName(), Boolean.FALSE);
        }
        if (!superClassName.startsWith("java.")) {
            this.extendsClassesSet.add(javaClass.getClassName());
            this.extendsClassesSet.add(superClassName);
        }
        for (CustomCodeParserInterface customCodeParser : this.customCodeParserList) {
            customCodeParser.preHandleClass(javaClass);
        }
    }

    private void preHandleClass(JavaClass javaClass) {
        String className = javaClass.getClassName();
        String[] interfaceNames = javaClass.getInterfaceNames();
        Method[] methods = javaClass.getMethods();
        if (interfaceNames != null && interfaceNames.length > 0 && methods != null && methods.length > 0 && this.classInterfaceMethodInfoMap.get(className) == null) {
            ClassInterfaceMethodInfo classInterfaceMethodInfo = new ClassInterfaceMethodInfo();
            ArrayList<String> interfaceNameList = new ArrayList<String>(interfaceNames.length);
            interfaceNameList.addAll(Arrays.asList(interfaceNames));
            List<String> implClassMethodWithArgsList = CommonUtil.genImplClassMethodWithArgs(methods);
            classInterfaceMethodInfo.setInterfaceNameList(interfaceNameList);
            classInterfaceMethodInfo.setMethodWithArgsList(implClassMethodWithArgsList);
            this.classInterfaceMethodInfoMap.put(className, classInterfaceMethodInfo);
            if (!javaClass.isAbstract()) {
                if (interfaceNameList.contains(RUNNABLE_CLASS_NAME)) {
                    this.runnableImplClassMap.put(className, Boolean.FALSE);
                }
                if (interfaceNameList.contains(CALLABLE_CLASS_NAME)) {
                    this.callableImplClassMap.put(className, Boolean.FALSE);
                }
            }
        }
    }

    private void findExtendsClassesInfo(JavaClass javaClass) {
        String className = javaClass.getClassName();
        if (this.extendsClassMethodInfoMap.get(className) != null) {
            return;
        }
        String superClassName = javaClass.getSuperclassName();
        if (!superClassName.startsWith("java.")) {
            List<String> childrenClassInfoList = this.childrenClassInfoMap.get(superClassName);
            if (childrenClassInfoList == null) {
                ArrayList<String> newChildrenClassInfoList = new ArrayList<String>();
                newChildrenClassInfoList.add(className);
                this.childrenClassInfoMap.put(superClassName, newChildrenClassInfoList);
            } else {
                childrenClassInfoList.add(className);
            }
        }
        ExtendsClassMethodInfo extendsClassMethodInfo = new ExtendsClassMethodInfo();
        extendsClassMethodInfo.setAbstractClass(javaClass.isAbstract());
        extendsClassMethodInfo.setSuperClassName(superClassName);
        HashMap<String, MethodAttribute> methodAttributeMap = new HashMap<String, MethodAttribute>();
        Method[] methods = javaClass.getMethods();
        if (methods != null && methods.length > 0) {
            for (Method method : methods) {
                String methodName = method.getName();
                if (methodName.startsWith("<") || method.isStatic() || !method.isAbstract() && !method.isPublic() && !method.isProtected()) continue;
                MethodAttribute methodAttribute = new MethodAttribute();
                methodAttribute.setAbstractMethod(method.isAbstract());
                methodAttribute.setPublicMethod(method.isPublic());
                methodAttribute.setProtectedMethod(method.isProtected());
                String methodWithArgs = methodName + CommonUtil.argumentList(method.getArgumentTypes());
                methodAttributeMap.put(methodWithArgs, methodAttribute);
            }
        }
        extendsClassMethodInfo.setMethodAttributeMap(methodAttributeMap);
        this.extendsClassMethodInfoMap.put(className, extendsClassMethodInfo);
    }

    private void recordMethodAnnotationInfo(BufferedWriter out) throws IOException {
        for (Map.Entry<String, Set<String>> entry : this.methodAnnotationMap.entrySet()) {
            String fullMethod = entry.getKey();
            Set<String> annotationSet = entry.getValue();
            for (String annotation : annotationSet) {
                String methodWithAnnotation = fullMethod + " " + annotation + "\n";
                out.write(methodWithAnnotation);
            }
        }
    }

    private void writeResult(BufferedWriter resultWriter, String data) throws IOException {
        resultWriter.write(data);
    }
}

