/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.stat;

import com.adrninistrator.javacg.dto.CallIdCounter;
import com.adrninistrator.javacg.dto.MethodCallDto;
import com.adrninistrator.javacg.extensions.code_parser.CustomCodeParserInterface;
import com.adrninistrator.javacg.stat.MethodVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.EmptyVisitor;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Visitor;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.MethodGen;

public class ClassVisitor
extends EmptyVisitor {
    private JavaClass clazz;
    private ConstantPoolGen constants;
    private String classReferenceFormat;
    private List<MethodCallDto> methodCalls = new ArrayList<MethodCallDto>();
    private Map<String, Set<String>> calleeMethodMap;
    private Map<String, Boolean> runnableImplClassMap;
    private Map<String, Boolean> callableImplClassMap;
    private Map<String, Boolean> threadChildClassMap;
    private Map<String, Set<String>> methodAnnotationMap;
    private CallIdCounter callIdCounter;
    private List<CustomCodeParserInterface> customCodeParserList;

    public ClassVisitor(JavaClass jc) {
        this.clazz = jc;
        this.constants = new ConstantPoolGen(this.clazz.getConstantPool());
        this.classReferenceFormat = "C:" + this.clazz.getClassName() + " %s";
    }

    public void visitJavaClass(JavaClass jc) {
        jc.getConstantPool().accept((Visitor)this);
        for (Method method : jc.getMethods()) {
            method.accept((Visitor)this);
        }
    }

    public void visitConstantPool(ConstantPool constantPool) {
        for (int i = 0; i < constantPool.getLength(); ++i) {
            Constant constant = constantPool.getConstant(i);
            if (constant == null || constant.getTag() != 7) continue;
            String referencedClass = constantPool.constantToString(constant);
            MethodCallDto methodCallDto = MethodCallDto.genInstance(String.format(this.classReferenceFormat, referencedClass), -1);
            this.methodCalls.add(methodCallDto);
        }
    }

    public void visitMethod(Method method) {
        MethodGen mg = new MethodGen(method, this.clazz.getClassName(), this.constants);
        MethodVisitor visitor = new MethodVisitor(mg, this.clazz);
        visitor.setCalleeMethodMap(this.calleeMethodMap);
        visitor.setRunnableImplClassMap(this.runnableImplClassMap);
        visitor.setCallableImplClassMap(this.callableImplClassMap);
        visitor.setThreadChildClassMap(this.threadChildClassMap);
        visitor.setMethodAnnotationMap(this.methodAnnotationMap);
        visitor.setCallIdCounter(this.callIdCounter);
        visitor.setCustomCodeParserList(this.customCodeParserList);
        visitor.beforeStart();
        List<MethodCallDto> methodCallDtos = visitor.start();
        this.methodCalls.addAll(methodCallDtos);
    }

    public ClassVisitor start() {
        this.visitJavaClass(this.clazz);
        return this;
    }

    public List<MethodCallDto> methodCalls() {
        return this.methodCalls;
    }

    public void setCalleeMethodMap(Map<String, Set<String>> calleeMethodMap) {
        this.calleeMethodMap = calleeMethodMap;
    }

    public void setRunnableImplClassMap(Map<String, Boolean> runnableImplClassMap) {
        this.runnableImplClassMap = runnableImplClassMap;
    }

    public void setCallableImplClassMap(Map<String, Boolean> callableImplClassMap) {
        this.callableImplClassMap = callableImplClassMap;
    }

    public void setThreadChildClassMap(Map<String, Boolean> threadChildClassMap) {
        this.threadChildClassMap = threadChildClassMap;
    }

    public void setMethodAnnotationMap(Map<String, Set<String>> methodAnnotationMap) {
        this.methodAnnotationMap = methodAnnotationMap;
    }

    public void setCallIdCounter(CallIdCounter callIdCounter) {
        this.callIdCounter = callIdCounter;
    }

    public void setCustomCodeParserList(List<CustomCodeParserInterface> customCodeParserList) {
        this.customCodeParserList = customCodeParserList;
    }
}

