/*
 * Decompiled with CFR 0.152.
 */
package com.force.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.force.api.DescribeSObjectBasic;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DescribeSObject
extends DescribeSObjectBasic {
    private List<Field> fields;
    private List<ChildEntity> childRelationships;

    public List<Field> getAllFields() {
        return this.fields;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public List<ChildEntity> getChildRelationships() {
        return this.childRelationships;
    }

    public Map<String, String> getChildEntities() {
        HashMap<String, String> children = new HashMap<String, String>();
        for (ChildEntity child : this.childRelationships) {
            if (!child.getField().equals("AccountId")) continue;
            if (child.getRelationshipName() != null) {
                children.put(child.getChildSObject(), child.getRelationshipName());
                continue;
            }
            children.put(child.getChildSObject(), child.getChildSObject() + "s");
        }
        return children;
    }

    public Set<Field> getRequiredFieldsForCreateUpdate() {
        HashSet<Field> required = new HashSet<Field>();
        for (Field field : this.fields) {
            if (!field.isCreateable().booleanValue() || field.isNillable().booleanValue() || field.isDefaultedOnCreate().booleanValue()) continue;
            required.add(field);
        }
        return required;
    }

    public Set<Field> getOptionalFieldsForCreateUpdate() {
        HashSet<Field> optional = new HashSet<Field>();
        for (Field field : this.fields) {
            if (!field.isCreateable().booleanValue() || !field.isNillable().booleanValue() && !field.isDefaultedOnCreate().booleanValue() || field.getRelationshipName() != null) continue;
            optional.add(field);
        }
        return optional;
    }

    public Set<Field> getParentEntitiesForCreateUpdate() {
        HashSet<Field> parentReference = new HashSet<Field>();
        for (Field field : this.fields) {
            if (!field.isCreateable().booleanValue() || !field.isNillable().booleanValue() && !field.isDefaultedOnCreate().booleanValue() || field.getRelationshipName() == null) continue;
            parentReference.add(field);
        }
        return parentReference;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ChildEntity {
        private String field;
        private String childSObject;
        private String relationshipName;
        private Boolean deprecatedAndHidden;
        private Boolean cascadeDelete;

        public String getField() {
            return this.field;
        }

        public String getChildSObject() {
            return this.childSObject;
        }

        public String getRelationshipName() {
            return this.relationshipName;
        }

        public Boolean isDeprecatedAndHidden() {
            return this.deprecatedAndHidden;
        }

        public Boolean isCascadeDelete() {
            return this.cascadeDelete;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class PicklistEntry {
        private String value;
        private Boolean active;
        private String label;
        private Boolean defaultValue;
        private byte[] validFor;

        public String getValue() {
            return this.value;
        }

        public Boolean isActive() {
            return this.active;
        }

        public String getLabel() {
            return this.label;
        }

        public Boolean isDefaultValue() {
            return this.defaultValue;
        }

        public byte[] getValidFor() {
            return this.validFor;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Field {
        private Integer length;
        private String name;
        private String type;
        private String soapType;
        private String defaultValue;
        private String label;
        private Boolean updateable;
        private Boolean calculated;
        private Boolean unique;
        private Boolean nillable;
        private Boolean caseSensitive;
        private String inlineHelpText;
        private Boolean nameField;
        private Boolean externalId;
        private Boolean idLookup;
        private Boolean filterable;
        private Boolean createable;
        private Boolean deprecatedAndHidden;
        private List<PicklistEntry> picklistValues;
        private Boolean autoNumber;
        private Boolean defaultedOnCreate;
        private Boolean groupable;
        private String relationshipName;
        private List<String> referenceTo;
        private Boolean restrictedPicklist;
        private Boolean namePointing;
        private Boolean custom;
        private Boolean htmlFormatted;
        private Boolean dependentPicklist;
        private Boolean writeRequiresMasterRead;
        private Boolean sortable;

        public Integer getLength() {
            return this.length;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getSoapType() {
            return this.soapType;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String getLabel() {
            return this.label;
        }

        public Boolean isUpdateable() {
            return this.updateable;
        }

        public Boolean isCalculated() {
            return this.calculated;
        }

        public Boolean isUnique() {
            return this.unique;
        }

        public Boolean isNillable() {
            return this.nillable;
        }

        public Boolean isCaseSensitive() {
            return this.caseSensitive;
        }

        public String getInlineHelpText() {
            return this.inlineHelpText;
        }

        public Boolean isNameField() {
            return this.nameField;
        }

        public Boolean isExternalId() {
            return this.externalId;
        }

        public Boolean isIdLookup() {
            return this.idLookup;
        }

        public Boolean isFilterable() {
            return this.filterable;
        }

        public Boolean isCreateable() {
            return this.createable;
        }

        public Boolean isDeprecatedAndHidden() {
            return this.deprecatedAndHidden;
        }

        public List<PicklistEntry> getPicklistValues() {
            return this.picklistValues;
        }

        public Boolean isAutoNumber() {
            return this.autoNumber;
        }

        public Boolean isDefaultedOnCreate() {
            return this.defaultedOnCreate;
        }

        public Boolean isGroupable() {
            return this.groupable;
        }

        public String getRelationshipName() {
            return this.relationshipName;
        }

        public List<String> getReferenceTo() {
            return this.referenceTo;
        }

        public List<String> getReferenceToEntity() {
            return this.referenceTo;
        }

        public Boolean isRestrictedPicklist() {
            return this.restrictedPicklist;
        }

        public Boolean isNamePointing() {
            return this.namePointing;
        }

        public Boolean isCustom() {
            return this.custom;
        }

        public Boolean isHtmlFormatted() {
            return this.htmlFormatted;
        }

        public Boolean isDependentPicklist() {
            return this.dependentPicklist;
        }

        public Boolean isWriteRequiresMasterRead() {
            return this.writeRequiresMasterRead;
        }

        public Boolean isSortable() {
            return this.sortable;
        }
    }
}

