/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.xml.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import com.fasterxml.jackson.dataformat.xml.util.StaxUtil;
import com.fasterxml.jackson.dataformat.xml.util.TypeUtil;
import com.fasterxml.jackson.dataformat.xml.util.XmlRootNameLookup;
import java.io.Closeable;
import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public class XmlSerializerProvider
extends DefaultSerializerProvider {
    private static final long serialVersionUID = 1L;
    protected final XmlRootNameLookup _rootNameLookup;

    public XmlSerializerProvider(XmlRootNameLookup rootNames) {
        this._rootNameLookup = rootNames;
    }

    public XmlSerializerProvider(XmlSerializerProvider src, SerializationConfig config, SerializerFactory f) {
        super((SerializerProvider)src, config, f);
        this._rootNameLookup = src._rootNameLookup;
    }

    protected XmlSerializerProvider(XmlSerializerProvider src) {
        super((DefaultSerializerProvider)src);
        this._rootNameLookup = new XmlRootNameLookup();
    }

    public DefaultSerializerProvider copy() {
        return new XmlSerializerProvider(this);
    }

    public DefaultSerializerProvider createInstance(SerializationConfig config, SerializerFactory jsf) {
        return new XmlSerializerProvider(this, config, jsf);
    }

    public void serializeValue(JsonGenerator gen, Object value) throws IOException {
        boolean asArray;
        this._generator = gen;
        if (value == null) {
            this._serializeXmlNull(gen);
            return;
        }
        Class<?> cls = value.getClass();
        ToXmlGenerator xgen = this._asXmlGenerator(gen);
        if (xgen == null) {
            asArray = false;
        } else {
            QName rootName = this._rootNameFromConfig();
            if (rootName == null) {
                rootName = this._rootNameLookup.findRootName(cls, (MapperConfig<?>)this._config);
            }
            this._initWithRootName(xgen, rootName);
            asArray = TypeUtil.isIndexedType(cls);
            if (asArray) {
                this._startRootArray(xgen, rootName);
            }
        }
        JsonSerializer ser = this.findTypedValueSerializer(cls, true, null);
        try {
            ser.serialize(value, gen, (SerializerProvider)this);
        }
        catch (Exception e) {
            throw this._wrapAsIOE(gen, e);
        }
        if (asArray) {
            gen.writeEndObject();
        }
    }

    public void serializeValue(JsonGenerator gen, Object value, JavaType rootType) throws IOException {
        this.serializeValue(gen, value, rootType, null);
    }

    public void serializeValue(JsonGenerator gen, Object value, JavaType rootType, JsonSerializer<Object> ser) throws IOException {
        boolean asArray;
        ToXmlGenerator xgen;
        this._generator = gen;
        if (value == null) {
            this._serializeXmlNull(gen);
            return;
        }
        if (rootType != null && !rootType.getRawClass().isAssignableFrom(value.getClass())) {
            this._reportIncompatibleRootType(value, rootType);
        }
        if ((xgen = this._asXmlGenerator(gen)) == null) {
            asArray = false;
        } else {
            QName rootName = this._rootNameFromConfig();
            if (rootName == null) {
                rootName = this._rootNameLookup.findRootName(rootType, (MapperConfig<?>)this._config);
            }
            this._initWithRootName(xgen, rootName);
            asArray = TypeUtil.isIndexedType(rootType);
            if (asArray) {
                this._startRootArray(xgen, rootName);
            }
        }
        if (ser == null) {
            ser = this.findTypedValueSerializer(rootType, true, null);
        }
        try {
            ser.serialize(value, gen, (SerializerProvider)this);
        }
        catch (Exception e) {
            throw this._wrapAsIOE(gen, e);
        }
        if (asArray) {
            gen.writeEndObject();
        }
    }

    public void serializePolymorphic(JsonGenerator gen, Object value, JavaType rootType, JsonSerializer<Object> valueSer, TypeSerializer typeSer) throws IOException {
        boolean asArray;
        ToXmlGenerator xgen;
        this._generator = gen;
        if (value == null) {
            this._serializeXmlNull(gen);
            return;
        }
        if (rootType != null && !rootType.getRawClass().isAssignableFrom(value.getClass())) {
            this._reportIncompatibleRootType(value, rootType);
        }
        if ((xgen = this._asXmlGenerator(gen)) == null) {
            asArray = false;
        } else {
            QName rootName = this._rootNameFromConfig();
            if (rootName == null) {
                rootName = this._rootNameLookup.findRootName(rootType, (MapperConfig<?>)this._config);
            }
            this._initWithRootName(xgen, rootName);
            asArray = TypeUtil.isIndexedType(rootType);
            if (asArray) {
                this._startRootArray(xgen, rootName);
            }
        }
        if (valueSer == null) {
            valueSer = rootType != null && rootType.isContainerType() ? this.findValueSerializer(rootType, null) : this.findValueSerializer(value.getClass(), null);
        }
        try {
            valueSer.serializeWithType(value, gen, (SerializerProvider)this, typeSer);
        }
        catch (Exception e) {
            throw this._wrapAsIOE(gen, e);
        }
        if (asArray) {
            gen.writeEndObject();
        }
    }

    protected void _serializeXmlNull(JsonGenerator gen) throws IOException {
        QName rootName = this._rootNameFromConfig();
        if (rootName == null) {
            rootName = XmlRootNameLookup.ROOT_NAME_FOR_NULL;
        }
        if (gen instanceof ToXmlGenerator) {
            this._initWithRootName((ToXmlGenerator)gen, rootName);
        }
        super.serializeValue(gen, null);
    }

    protected void _startRootArray(ToXmlGenerator xgen, QName rootName) throws IOException {
        xgen.writeStartObject();
        xgen.writeFieldName("item");
    }

    protected void _initWithRootName(ToXmlGenerator xgen, QName rootName) throws IOException {
        if (!xgen.setNextNameIfMissing(rootName) && xgen.inRoot()) {
            xgen.setNextName(rootName);
        }
        xgen.initGenerator();
        String ns = rootName.getNamespaceURI();
        if (ns != null && ns.length() > 0) {
            try {
                xgen.getStaxWriter().setDefaultNamespace(ns);
            }
            catch (XMLStreamException e) {
                StaxUtil.throwAsGenerationException(e, (JsonGenerator)xgen);
            }
        }
    }

    protected QName _rootNameFromConfig() {
        PropertyName name = this._config.getFullRootName();
        if (name == null) {
            return null;
        }
        String ns = name.getNamespace();
        if (ns == null || ns.isEmpty()) {
            return new QName(name.getSimpleName());
        }
        return new QName(ns, name.getSimpleName());
    }

    protected ToXmlGenerator _asXmlGenerator(JsonGenerator gen) throws JsonMappingException {
        if (!(gen instanceof ToXmlGenerator)) {
            if (!(gen instanceof TokenBuffer)) {
                throw JsonMappingException.from((JsonGenerator)gen, (String)("XmlMapper does not with generators of type other than ToXmlGenerator; got: " + gen.getClass().getName()));
            }
            return null;
        }
        return (ToXmlGenerator)gen;
    }

    protected IOException _wrapAsIOE(JsonGenerator g, Exception e) {
        if (e instanceof IOException) {
            return (IOException)e;
        }
        String msg = e.getMessage();
        if (msg == null) {
            msg = "[no message for " + e.getClass().getName() + "]";
        }
        return new JsonMappingException((Closeable)g, msg, (Throwable)e);
    }
}

