/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.ion;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import com.fasterxml.jackson.dataformat.ion.IonGenerator;
import java.io.IOException;
import java.lang.reflect.Type;

public class EnumAsIonSymbolSerializer
extends StdScalarSerializer<Enum<?>> {
    private static final long serialVersionUID = 1L;

    public EnumAsIonSymbolSerializer() {
        super(Enum.class, false);
    }

    public void serialize(Enum<?> value, JsonGenerator g, SerializerProvider provider) throws IOException {
        if (!IonGenerator.class.isAssignableFrom(g.getClass())) {
            throw new JsonGenerationException("Can only use EnumAsIonSymbolSerializer with IonGenerator", g);
        }
        String valueString = provider.isEnabled(SerializationFeature.WRITE_ENUMS_USING_TO_STRING) ? value.toString() : value.name();
        ((IonGenerator)g).writeSymbol(valueString);
    }

    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        this.visitStringFormat(visitor, typeHint);
    }

    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return this.createSchemaNode("string", true);
    }
}

