/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.csv.impl;

import com.fasterxml.jackson.core.util.BufferRecycler;
import com.fasterxml.jackson.dataformat.csv.impl.NumberInput;
import java.math.BigDecimal;
import java.util.LinkedList;

public final class TextBuffer {
    static final char[] NO_CHARS = new char[0];
    static final int MIN_SEGMENT_LEN = 1000;
    static final int MAX_SEGMENT_LEN = 262144;
    private final BufferRecycler _allocator;
    private char[] _inputBuffer;
    private int _inputStart;
    private int _inputLen;
    private LinkedList<char[]> _segments;
    private boolean _hasSegments = false;
    private int _segmentSize;
    private char[] _currentSegment;
    private int _currentSize;
    private String _resultString;
    private char[] _resultArray;

    public TextBuffer(BufferRecycler bufferRecycler) {
        this._allocator = bufferRecycler;
    }

    public void releaseBuffers() {
        if (this._allocator == null) {
            this.reset();
        } else if (this._currentSegment != null) {
            this.reset();
            char[] cArray = this._currentSegment;
            this._currentSegment = null;
            this._allocator.releaseCharBuffer(BufferRecycler.CharBufferType.TEXT_BUFFER, cArray);
        }
    }

    public void reset() {
        this._inputStart = -1;
        this._currentSize = 0;
        this._inputLen = 0;
        this._inputBuffer = null;
        this._resultString = null;
        this._resultArray = null;
        if (this._hasSegments) {
            this.clearSegments();
        }
    }

    public void resetWithShared(char[] cArray, int n, int n2) {
        this._resultString = null;
        this._resultArray = null;
        this._inputBuffer = cArray;
        this._inputStart = n;
        this._inputLen = n2;
        if (this._hasSegments) {
            this.clearSegments();
        }
    }

    public void resetWithString(String string) {
        this._inputBuffer = null;
        this._inputStart = -1;
        this._inputLen = 0;
        this._resultString = string;
        this._resultArray = null;
        if (this._hasSegments) {
            this.clearSegments();
        }
        this._currentSize = 0;
    }

    private final char[] findBuffer(int n) {
        if (this._allocator != null) {
            return this._allocator.allocCharBuffer(BufferRecycler.CharBufferType.TEXT_BUFFER, n);
        }
        return new char[Math.max(n, 1000)];
    }

    private final void clearSegments() {
        this._hasSegments = false;
        this._segments.clear();
        this._segmentSize = 0;
        this._currentSize = 0;
    }

    public int size() {
        if (this._inputStart >= 0) {
            return this._inputLen;
        }
        if (this._resultArray != null) {
            return this._resultArray.length;
        }
        if (this._resultString != null) {
            return this._resultString.length();
        }
        return this._segmentSize + this._currentSize;
    }

    public int getTextOffset() {
        return this._inputStart >= 0 ? this._inputStart : 0;
    }

    public boolean hasTextAsCharacters() {
        if (this._inputStart >= 0 || this._resultArray != null) {
            return true;
        }
        return this._resultString == null;
    }

    public char[] getTextBuffer() {
        if (this._inputStart >= 0) {
            return this._inputBuffer;
        }
        if (this._resultArray != null) {
            return this._resultArray;
        }
        if (this._resultString != null) {
            this._resultArray = this._resultString.toCharArray();
            return this._resultArray;
        }
        if (!this._hasSegments) {
            return this._currentSegment;
        }
        return this.contentsAsArray();
    }

    public String contentsAsString() {
        if (this._resultString == null) {
            if (this._resultArray != null) {
                this._resultString = new String(this._resultArray);
            } else if (this._inputStart >= 0) {
                if (this._inputLen < 1) {
                    this._resultString = "";
                    return "";
                }
                this._resultString = new String(this._inputBuffer, this._inputStart, this._inputLen);
            } else {
                int n = this._segmentSize;
                int n2 = this._currentSize;
                if (n == 0) {
                    this._resultString = n2 == 0 ? "" : new String(this._currentSegment, 0, n2);
                } else {
                    StringBuilder stringBuilder = new StringBuilder(n + n2);
                    if (this._segments != null) {
                        for (char[] cArray : this._segments) {
                            stringBuilder.append(cArray, 0, cArray.length);
                        }
                    }
                    stringBuilder.append(this._currentSegment, 0, this._currentSize);
                    this._resultString = stringBuilder.toString();
                }
            }
        }
        return this._resultString;
    }

    public char[] contentsAsArray() {
        char[] cArray = this._resultArray;
        if (cArray == null) {
            this._resultArray = cArray = this.buildResultArray();
        }
        return cArray;
    }

    public BigDecimal contentsAsDecimal() throws NumberFormatException {
        if (this._resultArray != null) {
            return new BigDecimal(this._resultArray);
        }
        if (this._inputStart >= 0) {
            return new BigDecimal(this._inputBuffer, this._inputStart, this._inputLen);
        }
        if (this._segmentSize == 0) {
            return new BigDecimal(this._currentSegment, 0, this._currentSize);
        }
        return new BigDecimal(this.contentsAsArray());
    }

    public double contentsAsDouble() throws NumberFormatException {
        return NumberInput.parseDouble(this.contentsAsString());
    }

    public void ensureNotShared() {
        if (this._inputStart >= 0) {
            this.unshare(16);
        }
    }

    public char[] getCurrentSegment() {
        if (this._inputStart >= 0) {
            this.unshare(1);
        } else {
            char[] cArray = this._currentSegment;
            if (cArray == null) {
                this._currentSegment = this.findBuffer(0);
            } else if (this._currentSize >= cArray.length) {
                this.expand(1);
            }
        }
        return this._currentSegment;
    }

    public final char[] emptyAndGetCurrentSegment() {
        char[] cArray;
        this._inputStart = -1;
        this._currentSize = 0;
        this._inputLen = 0;
        this._inputBuffer = null;
        this._resultString = null;
        this._resultArray = null;
        if (this._hasSegments) {
            this.clearSegments();
        }
        if ((cArray = this._currentSegment) == null) {
            this._currentSegment = cArray = this.findBuffer(0);
        }
        return cArray;
    }

    public int getCurrentSegmentSize() {
        return this._currentSize;
    }

    public String finishAndReturn(int n, boolean bl) {
        int n2;
        if (bl && this._currentSegment[n2 = n - 1] <= ' ') {
            return this._doTrim(n2);
        }
        this._currentSize = n;
        return this.contentsAsString();
    }

    private String _doTrim(int n) {
        while (true) {
            char[] cArray = this._currentSegment;
            while (--n >= 0) {
                if (cArray[n] <= ' ') continue;
                this._currentSize = n + 1;
                return this.contentsAsString();
            }
            if (this._segments == null || this._segments.isEmpty()) break;
            this._currentSegment = this._segments.removeLast();
            n = this._currentSegment.length;
        }
        this._currentSize = 0;
        this._hasSegments = false;
        return this.contentsAsString();
    }

    public char[] finishCurrentSegment() {
        if (this._segments == null) {
            this._segments = new LinkedList();
        }
        this._hasSegments = true;
        this._segments.add(this._currentSegment);
        int n = this._currentSegment.length;
        this._segmentSize += n;
        int n2 = Math.min(n + (n >> 1), 262144);
        char[] cArray = this._charArray(n2);
        this._currentSize = 0;
        this._currentSegment = cArray;
        return cArray;
    }

    public String toString() {
        return this.contentsAsString();
    }

    private void unshare(int n) {
        int n2 = this._inputLen;
        this._inputLen = 0;
        char[] cArray = this._inputBuffer;
        this._inputBuffer = null;
        int n3 = this._inputStart;
        this._inputStart = -1;
        int n4 = n2 + n;
        if (this._currentSegment == null || n4 > this._currentSegment.length) {
            this._currentSegment = this.findBuffer(n4);
        }
        if (n2 > 0) {
            System.arraycopy(cArray, n3, this._currentSegment, 0, n2);
        }
        this._segmentSize = 0;
        this._currentSize = n2;
    }

    private void expand(int n) {
        if (this._segments == null) {
            this._segments = new LinkedList();
        }
        char[] cArray = this._currentSegment;
        this._hasSegments = true;
        this._segments.add(cArray);
        this._segmentSize += cArray.length;
        int n2 = cArray.length;
        int n3 = n2 >> 1;
        if (n3 < n) {
            n3 = n;
        }
        cArray = this._charArray(Math.min(262144, n2 + n3));
        this._currentSize = 0;
        this._currentSegment = cArray;
    }

    private char[] buildResultArray() {
        char[] cArray;
        if (this._resultString != null) {
            return this._resultString.toCharArray();
        }
        if (this._inputStart >= 0) {
            if (this._inputLen < 1) {
                return NO_CHARS;
            }
            cArray = this._charArray(this._inputLen);
            System.arraycopy(this._inputBuffer, this._inputStart, cArray, 0, this._inputLen);
        } else {
            int n = this.size();
            if (n < 1) {
                return NO_CHARS;
            }
            int n2 = 0;
            cArray = this._charArray(n);
            if (this._segments != null) {
                for (char[] cArray2 : this._segments) {
                    int n3 = cArray2.length;
                    System.arraycopy(cArray2, 0, cArray, n2, n3);
                    n2 += n3;
                }
            }
            System.arraycopy(this._currentSegment, 0, cArray, n2, this._currentSize);
        }
        return cArray;
    }

    private final char[] _charArray(int n) {
        return new char[n];
    }
}

