/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.csv.impl;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.format.InputAccessor;
import com.fasterxml.jackson.core.format.MatchStrength;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.io.MergedStream;
import com.fasterxml.jackson.core.io.UTF32Reader;
import com.fasterxml.jackson.dataformat.csv.CsvParser;
import java.io.ByteArrayInputStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public final class CsvParserBootstrapper {
    static final byte UTF8_BOM_1 = -17;
    static final byte UTF8_BOM_2 = -69;
    static final byte UTF8_BOM_3 = -65;
    protected final IOContext _context;
    protected final InputStream _in;
    protected final byte[] _inputBuffer;
    private int _inputPtr;
    private int _inputEnd;
    protected int _inputProcessed;
    protected boolean _bigEndian = true;
    protected int _bytesPerChar = 0;

    public CsvParserBootstrapper(IOContext iOContext, char c, InputStream inputStream) {
        this._context = iOContext;
        this._in = inputStream;
        this._inputBuffer = iOContext.allocReadIOBuffer();
        this._inputPtr = 0;
        this._inputEnd = 0;
        this._inputProcessed = 0;
    }

    public CsvParserBootstrapper(IOContext iOContext, char c, byte[] byArray, int n, int n2) {
        this._context = iOContext;
        this._in = null;
        this._inputBuffer = byArray;
        this._inputPtr = n;
        this._inputEnd = n + n2;
        this._inputProcessed = -n;
    }

    public JsonEncoding detectEncoding() throws IOException, JsonParseException {
        JsonEncoding jsonEncoding;
        int n;
        boolean bl = false;
        if (this.ensureLoaded(4)) {
            n = this._inputBuffer[this._inputPtr] << 24 | (this._inputBuffer[this._inputPtr + 1] & 0xFF) << 16 | (this._inputBuffer[this._inputPtr + 2] & 0xFF) << 8 | this._inputBuffer[this._inputPtr + 3] & 0xFF;
            if (this.handleBOM(n)) {
                bl = true;
            } else if (this.checkUTF32(n)) {
                bl = true;
            } else if (this.checkUTF16(n >>> 16)) {
                bl = true;
            }
        } else if (this.ensureLoaded(2) && this.checkUTF16(n = (this._inputBuffer[this._inputPtr] & 0xFF) << 8 | this._inputBuffer[this._inputPtr + 1] & 0xFF)) {
            bl = true;
        }
        if (!bl) {
            jsonEncoding = JsonEncoding.UTF8;
        } else if (this._bytesPerChar == 2) {
            jsonEncoding = this._bigEndian ? JsonEncoding.UTF16_BE : JsonEncoding.UTF16_LE;
        } else if (this._bytesPerChar == 4) {
            jsonEncoding = this._bigEndian ? JsonEncoding.UTF32_BE : JsonEncoding.UTF32_LE;
        } else {
            throw new RuntimeException("Internal error");
        }
        this._context.setEncoding(jsonEncoding);
        return jsonEncoding;
    }

    public Reader constructReader() throws IOException {
        JsonEncoding jsonEncoding = this._context.getEncoding();
        switch (jsonEncoding) {
            case UTF32_BE: 
            case UTF32_LE: {
                return new UTF32Reader(this._context, this._in, this._inputBuffer, this._inputPtr, this._inputEnd, this._context.getEncoding().isBigEndian());
            }
            case UTF16_BE: 
            case UTF16_LE: 
            case UTF8: {
                InputStream inputStream = this._in;
                if (inputStream == null) {
                    inputStream = new ByteArrayInputStream(this._inputBuffer, this._inputPtr, this._inputEnd);
                } else if (this._inputPtr < this._inputEnd) {
                    inputStream = new MergedStream(this._context, inputStream, this._inputBuffer, this._inputPtr, this._inputEnd);
                }
                return new InputStreamReader(inputStream, jsonEncoding.getJavaName());
            }
        }
        throw new RuntimeException("Internal error");
    }

    public CsvParser constructParser(int n, int n2, ObjectCodec objectCodec) throws IOException, JsonParseException {
        throw new Error();
    }

    public static MatchStrength hasCSVFormat(InputAccessor inputAccessor, char c, char c2) throws IOException {
        int n;
        if (!inputAccessor.hasMoreBytes()) {
            return MatchStrength.INCONCLUSIVE;
        }
        byte by = inputAccessor.nextByte();
        if (by == -17) {
            if (!inputAccessor.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (inputAccessor.nextByte() != -69) {
                return MatchStrength.NO_MATCH;
            }
            if (!inputAccessor.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (inputAccessor.nextByte() != -65) {
                return MatchStrength.NO_MATCH;
            }
            if (!inputAccessor.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            by = inputAccessor.nextByte();
        }
        if ((n = CsvParserBootstrapper.skipSpace(inputAccessor, by)) < 0) {
            return MatchStrength.INCONCLUSIVE;
        }
        if (n == c || n == c2) {
            return MatchStrength.WEAK_MATCH;
        }
        return MatchStrength.INCONCLUSIVE;
    }

    private static final int skipSpace(InputAccessor inputAccessor, byte by) throws IOException {
        int n;
        while ((n = by & 0xFF) == 32 || n == 13 || n == 10 || n == 9) {
            if (!inputAccessor.hasMoreBytes()) {
                return -1;
            }
            by = inputAccessor.nextByte();
            n = by & 0xFF;
        }
        return n;
    }

    private boolean handleBOM(int n) throws IOException {
        switch (n) {
            case 65279: {
                this._bigEndian = true;
                this._inputPtr += 4;
                this._bytesPerChar = 4;
                return true;
            }
            case -131072: {
                this._inputPtr += 4;
                this._bytesPerChar = 4;
                this._bigEndian = false;
                return true;
            }
            case 65534: {
                this.reportWeirdUCS4("2143");
            }
            case -16842752: {
                this.reportWeirdUCS4("3412");
            }
        }
        int n2 = n >>> 16;
        if (n2 == 65279) {
            this._inputPtr += 2;
            this._bytesPerChar = 2;
            this._bigEndian = true;
            return true;
        }
        if (n2 == 65534) {
            this._inputPtr += 2;
            this._bytesPerChar = 2;
            this._bigEndian = false;
            return true;
        }
        if (n >>> 8 == 0xEFBBBF) {
            this._inputPtr += 3;
            this._bytesPerChar = 1;
            this._bigEndian = true;
            return true;
        }
        return false;
    }

    private boolean checkUTF32(int n) throws IOException {
        if (n >> 8 == 0) {
            this._bigEndian = true;
        } else if ((n & 0xFFFFFF) == 0) {
            this._bigEndian = false;
        } else if ((n & 0xFF00FFFF) == 0) {
            this.reportWeirdUCS4("3412");
        } else if ((n & 0xFFFF00FF) == 0) {
            this.reportWeirdUCS4("2143");
        } else {
            return false;
        }
        this._bytesPerChar = 4;
        return true;
    }

    private boolean checkUTF16(int n) {
        if ((n & 0xFF00) == 0) {
            this._bigEndian = true;
        } else if ((n & 0xFF) == 0) {
            this._bigEndian = false;
        } else {
            return false;
        }
        this._bytesPerChar = 2;
        return true;
    }

    private void reportWeirdUCS4(String string) throws IOException {
        throw new CharConversionException("Unsupported UCS-4 endianness (" + string + ") detected");
    }

    protected boolean ensureLoaded(int n) throws IOException {
        int n2;
        for (int i = this._inputEnd - this._inputPtr; i < n; i += n2) {
            n2 = this._in == null ? -1 : this._in.read(this._inputBuffer, this._inputEnd, this._inputBuffer.length - this._inputEnd);
            if (n2 < 1) {
                return false;
            }
            this._inputEnd += n2;
        }
        return true;
    }
}

