/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.csv.impl;

import com.fasterxml.jackson.dataformat.csv.impl.CsvWriter;
import java.io.IOException;

public abstract class BufferedValue {
    protected BufferedValue() {
    }

    public abstract void write(CsvWriter var1) throws IOException;

    public static BufferedValue buffered(String string) {
        return new TextValue(string);
    }

    public static BufferedValue buffered(int n) {
        return new IntValue(n);
    }

    public static BufferedValue buffered(long l) {
        return new LongValue(l);
    }

    public static BufferedValue buffered(double d) {
        return new DoubleValue(d);
    }

    public static BufferedValue buffered(boolean bl) {
        return new BooleanValue(bl);
    }

    protected static final class BooleanValue
    extends BufferedValue {
        private final boolean _value;

        public BooleanValue(boolean bl) {
            this._value = bl;
        }

        @Override
        public void write(CsvWriter csvWriter) throws IOException {
            csvWriter.appendValue(this._value);
        }
    }

    protected static final class DoubleValue
    extends BufferedValue {
        private final double _value;

        public DoubleValue(double d) {
            this._value = d;
        }

        @Override
        public void write(CsvWriter csvWriter) throws IOException {
            csvWriter.appendValue(this._value);
        }
    }

    protected static final class LongValue
    extends BufferedValue {
        private final long _value;

        public LongValue(long l) {
            this._value = l;
        }

        @Override
        public void write(CsvWriter csvWriter) throws IOException {
            csvWriter.appendValue(this._value);
        }
    }

    protected static final class IntValue
    extends BufferedValue {
        private final int _value;

        public IntValue(int n) {
            this._value = n;
        }

        @Override
        public void write(CsvWriter csvWriter) throws IOException {
            csvWriter.appendValue(this._value);
        }
    }

    protected static final class TextValue
    extends BufferedValue {
        private final String _value;

        public TextValue(String string) {
            this._value = string;
        }

        @Override
        public void write(CsvWriter csvWriter) throws IOException {
            csvWriter.appendValue(this._value);
        }
    }
}

