/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.text.BoringLayout;
import android.text.Layout;
import android.text.Spannable;
import android.text.Spanned;
import android.text.StaticLayout;
import android.text.TextPaint;
import androidx.annotation.Nullable;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ReactNoCrashSoftException;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.NativeViewHierarchyOptimizer;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ReactShadowNode;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIViewOperationQueue;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.uimanager.events.RCTEventEmitter;
import com.facebook.react.views.text.FontMetricsUtil;
import com.facebook.react.views.text.ReactAbsoluteSizeSpan;
import com.facebook.react.views.text.ReactBaseTextShadowNode;
import com.facebook.react.views.text.ReactTextUpdate;
import com.facebook.react.views.text.ReactTextViewManagerCallback;
import com.facebook.react.views.text.TextInlineViewPlaceholderSpan;
import com.facebook.yoga.YogaBaselineFunction;
import com.facebook.yoga.YogaConstants;
import com.facebook.yoga.YogaDirection;
import com.facebook.yoga.YogaMeasureFunction;
import com.facebook.yoga.YogaMeasureMode;
import com.facebook.yoga.YogaMeasureOutput;
import com.facebook.yoga.YogaNode;
import java.util.ArrayList;

@TargetApi(value=23)
public class ReactTextShadowNode
extends ReactBaseTextShadowNode {
    private static final TextPaint sTextPaintInstance = new TextPaint(1);
    @Nullable
    private Spannable mPreparedSpannableText;
    private boolean mShouldNotifyOnTextLayout;
    private final YogaMeasureFunction mTextMeasureFunction = new YogaMeasureFunction(){

        @Override
        public long measure(YogaNode node, float width, YogaMeasureMode widthMode, float height, YogaMeasureMode heightMode) {
            Spannable text = (Spannable)Assertions.assertNotNull((Object)ReactTextShadowNode.this.mPreparedSpannableText, (String)"Spannable element has not been prepared in onBeforeLayout");
            Layout layout2 = ReactTextShadowNode.this.measureSpannedText(text, width, widthMode);
            if (ReactTextShadowNode.this.mAdjustsFontSizeToFit) {
                int initialFontSize = ReactTextShadowNode.this.mTextAttributes.getEffectiveFontSize();
                int currentFontSize = ReactTextShadowNode.this.mTextAttributes.getEffectiveFontSize();
                int minimumFontSize = (int)Math.max(ReactTextShadowNode.this.mMinimumFontScale * (float)initialFontSize, PixelUtil.toPixelFromDIP(4.0f));
                while (currentFontSize > minimumFontSize && (ReactTextShadowNode.this.mNumberOfLines != -1 && layout2.getLineCount() > ReactTextShadowNode.this.mNumberOfLines || heightMode != YogaMeasureMode.UNDEFINED && (float)layout2.getHeight() > height)) {
                    ReactAbsoluteSizeSpan[] sizeSpans;
                    float ratio = (float)(currentFontSize -= (int)PixelUtil.toPixelFromDIP(1.0f)) / (float)initialFontSize;
                    for (ReactAbsoluteSizeSpan span : sizeSpans = (ReactAbsoluteSizeSpan[])text.getSpans(0, text.length(), ReactAbsoluteSizeSpan.class)) {
                        text.setSpan((Object)new ReactAbsoluteSizeSpan((int)Math.max((float)span.getSize() * ratio, (float)minimumFontSize)), text.getSpanStart((Object)span), text.getSpanEnd((Object)span), text.getSpanFlags((Object)span));
                        text.removeSpan((Object)span);
                    }
                    layout2 = ReactTextShadowNode.this.measureSpannedText(text, width, widthMode);
                }
            }
            if (ReactTextShadowNode.this.mShouldNotifyOnTextLayout) {
                ThemedReactContext themedReactContext = ReactTextShadowNode.this.getThemedContext();
                WritableArray lines = FontMetricsUtil.getFontMetrics((CharSequence)text, layout2, sTextPaintInstance, (Context)themedReactContext);
                WritableMap event = Arguments.createMap();
                event.putArray("lines", lines);
                if (themedReactContext.hasActiveReactInstance()) {
                    themedReactContext.getJSModule(RCTEventEmitter.class).receiveEvent(ReactTextShadowNode.this.getReactTag(), "topTextLayout", event);
                } else {
                    ReactSoftExceptionLogger.logSoftException("ReactTextShadowNode", new ReactNoCrashSoftException("Cannot get RCTEventEmitter, no CatalystInstance"));
                }
            }
            int lineCount = ReactTextShadowNode.this.mNumberOfLines == -1 ? layout2.getLineCount() : Math.min(ReactTextShadowNode.this.mNumberOfLines, layout2.getLineCount());
            float layoutWidth = 0.0f;
            if (widthMode == YogaMeasureMode.EXACTLY) {
                layoutWidth = width;
            } else {
                for (int lineIndex = 0; lineIndex < lineCount; ++lineIndex) {
                    float lineWidth;
                    boolean endsWithNewLine = text.length() > 0 && text.charAt(layout2.getLineEnd(lineIndex) - 1) == '\n';
                    float f = lineWidth = endsWithNewLine ? layout2.getLineMax(lineIndex) : layout2.getLineWidth(lineIndex);
                    if (!(lineWidth > layoutWidth)) continue;
                    layoutWidth = lineWidth;
                }
                if (widthMode == YogaMeasureMode.AT_MOST && layoutWidth > width) {
                    layoutWidth = width;
                }
            }
            if (Build.VERSION.SDK_INT > 29) {
                layoutWidth = (float)Math.ceil(layoutWidth);
            }
            float layoutHeight = height;
            if (heightMode != YogaMeasureMode.EXACTLY) {
                layoutHeight = layout2.getLineBottom(lineCount - 1);
                if (heightMode == YogaMeasureMode.AT_MOST && layoutHeight > height) {
                    layoutHeight = height;
                }
            }
            return YogaMeasureOutput.make(layoutWidth, layoutHeight);
        }
    };
    private final YogaBaselineFunction mTextBaselineFunction = new YogaBaselineFunction(){

        @Override
        public float baseline(YogaNode node, float width, float height) {
            Spannable text = (Spannable)Assertions.assertNotNull((Object)ReactTextShadowNode.this.mPreparedSpannableText, (String)"Spannable element has not been prepared in onBeforeLayout");
            Layout layout2 = ReactTextShadowNode.this.measureSpannedText(text, width, YogaMeasureMode.EXACTLY);
            return layout2.getLineBaseline(layout2.getLineCount() - 1);
        }
    };

    public ReactTextShadowNode() {
        this(null);
    }

    public ReactTextShadowNode(@Nullable ReactTextViewManagerCallback reactTextViewManagerCallback) {
        super(reactTextViewManagerCallback);
        this.initMeasureFunction();
    }

    private void initMeasureFunction() {
        if (!this.isVirtual()) {
            this.setMeasureFunction(this.mTextMeasureFunction);
            this.setBaselineFunction(this.mTextBaselineFunction);
        }
    }

    private Layout measureSpannedText(Spannable text, float width, YogaMeasureMode widthMode) {
        BoringLayout layout2;
        TextPaint textPaint = sTextPaintInstance;
        textPaint.setTextSize((float)this.mTextAttributes.getEffectiveFontSize());
        BoringLayout.Metrics boring = BoringLayout.isBoring((CharSequence)text, (TextPaint)textPaint);
        float desiredWidth = boring == null ? Layout.getDesiredWidth((CharSequence)text, (TextPaint)textPaint) : Float.NaN;
        boolean unconstrainedWidth = widthMode == YogaMeasureMode.UNDEFINED || width < 0.0f;
        Layout.Alignment alignment = Layout.Alignment.ALIGN_NORMAL;
        switch (this.getTextAlign()) {
            case 3: {
                alignment = Layout.Alignment.ALIGN_NORMAL;
                break;
            }
            case 5: {
                alignment = Layout.Alignment.ALIGN_OPPOSITE;
                break;
            }
            case 1: {
                alignment = Layout.Alignment.ALIGN_CENTER;
            }
        }
        if (boring == null && (unconstrainedWidth || !YogaConstants.isUndefined(desiredWidth) && desiredWidth <= width)) {
            int hintWidth = (int)Math.ceil(desiredWidth);
            if (Build.VERSION.SDK_INT < 23) {
                layout2 = new StaticLayout((CharSequence)text, textPaint, hintWidth, alignment, 1.0f, 0.0f, this.mIncludeFontPadding);
            } else {
                StaticLayout.Builder builder = StaticLayout.Builder.obtain((CharSequence)text, (int)0, (int)text.length(), (TextPaint)textPaint, (int)hintWidth).setAlignment(alignment).setLineSpacing(0.0f, 1.0f).setIncludePad(this.mIncludeFontPadding).setBreakStrategy(this.mTextBreakStrategy).setHyphenationFrequency(this.mHyphenationFrequency);
                if (Build.VERSION.SDK_INT >= 26) {
                    builder.setJustificationMode(this.mJustificationMode);
                }
                if (Build.VERSION.SDK_INT >= 28) {
                    builder.setUseLineSpacingFromFallbacks(true);
                }
                layout2 = builder.build();
            }
        } else if (boring != null && (unconstrainedWidth || (float)boring.width <= width)) {
            layout2 = BoringLayout.make((CharSequence)text, (TextPaint)textPaint, (int)Math.max(boring.width, 0), (Layout.Alignment)alignment, (float)1.0f, (float)0.0f, (BoringLayout.Metrics)boring, (boolean)this.mIncludeFontPadding);
        } else if (Build.VERSION.SDK_INT < 23) {
            layout2 = new StaticLayout((CharSequence)text, textPaint, (int)width, alignment, 1.0f, 0.0f, this.mIncludeFontPadding);
        } else {
            if (Build.VERSION.SDK_INT > 29) {
                width = (float)Math.ceil(width);
            }
            StaticLayout.Builder builder = StaticLayout.Builder.obtain((CharSequence)text, (int)0, (int)text.length(), (TextPaint)textPaint, (int)((int)width)).setAlignment(alignment).setLineSpacing(0.0f, 1.0f).setIncludePad(this.mIncludeFontPadding).setBreakStrategy(this.mTextBreakStrategy).setHyphenationFrequency(this.mHyphenationFrequency);
            if (Build.VERSION.SDK_INT >= 28) {
                builder.setUseLineSpacingFromFallbacks(true);
            }
            layout2 = builder.build();
        }
        return layout2;
    }

    private int getTextAlign() {
        int textAlign = this.mTextAlign;
        if (this.getLayoutDirection() == YogaDirection.RTL) {
            if (textAlign == 5) {
                textAlign = 3;
            } else if (textAlign == 3) {
                textAlign = 5;
            }
        }
        return textAlign;
    }

    @Override
    public void onBeforeLayout(NativeViewHierarchyOptimizer nativeViewHierarchyOptimizer) {
        this.mPreparedSpannableText = this.spannedFromShadowNode(this, null, true, nativeViewHierarchyOptimizer);
        this.markUpdated();
    }

    @Override
    public boolean isVirtualAnchor() {
        return false;
    }

    @Override
    public boolean hoistNativeChildren() {
        return true;
    }

    @Override
    public void markUpdated() {
        super.markUpdated();
        super.dirty();
    }

    @Override
    public void onCollectExtraUpdates(UIViewOperationQueue uiViewOperationQueue) {
        super.onCollectExtraUpdates(uiViewOperationQueue);
        if (this.mPreparedSpannableText != null) {
            ReactTextUpdate reactTextUpdate = new ReactTextUpdate(this.mPreparedSpannableText, -1, this.mContainsImages, this.getPadding(4), this.getPadding(1), this.getPadding(5), this.getPadding(3), this.getTextAlign(), this.mTextBreakStrategy, this.mJustificationMode);
            uiViewOperationQueue.enqueueUpdateExtraData(this.getReactTag(), reactTextUpdate);
        }
    }

    @ReactProp(name="onTextLayout")
    public void setShouldNotifyOnTextLayout(boolean shouldNotifyOnTextLayout) {
        this.mShouldNotifyOnTextLayout = shouldNotifyOnTextLayout;
    }

    @Override
    public Iterable<? extends ReactShadowNode> calculateLayoutOnChildren() {
        if (this.mInlineViews == null || this.mInlineViews.isEmpty()) {
            return null;
        }
        Spanned text = (Spanned)Assertions.assertNotNull((Object)this.mPreparedSpannableText, (String)"Spannable element has not been prepared in onBeforeLayout");
        TextInlineViewPlaceholderSpan[] placeholders = (TextInlineViewPlaceholderSpan[])text.getSpans(0, text.length(), TextInlineViewPlaceholderSpan.class);
        ArrayList<ReactShadowNode> shadowNodes = new ArrayList<ReactShadowNode>(placeholders.length);
        for (TextInlineViewPlaceholderSpan placeholder : placeholders) {
            ReactShadowNode child = (ReactShadowNode)this.mInlineViews.get(placeholder.getReactTag());
            child.calculateLayout();
            shadowNodes.add(child);
        }
        return shadowNodes;
    }
}

