/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.modal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStructure;
import android.view.Window;
import android.view.accessibility.AccessibilityEvent;
import android.widget.FrameLayout;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.R;
import com.facebook.react.bridge.GuardedRunnable;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.bridge.WritableNativeMap;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.config.ReactFeatureFlags;
import com.facebook.react.uimanager.FabricViewStateManager;
import com.facebook.react.uimanager.JSPointerDispatcher;
import com.facebook.react.uimanager.JSTouchDispatcher;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.RootView;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.views.common.ContextUtils;
import com.facebook.react.views.view.ReactViewGroup;
import java.util.ArrayList;

public class ReactModalHostView
extends ViewGroup
implements LifecycleEventListener,
FabricViewStateManager.HasFabricViewStateManager {
    private static final String TAG = "ReactModalHost";
    private DialogRootViewGroup mHostView;
    @Nullable
    private Dialog mDialog;
    private boolean mTransparent;
    private boolean mStatusBarTranslucent;
    private String mAnimationType;
    private boolean mHardwareAccelerated;
    private boolean mPropertyRequiresNewDialog;
    @Nullable
    private DialogInterface.OnShowListener mOnShowListener;
    @Nullable
    private OnRequestCloseListener mOnRequestCloseListener;

    public ReactModalHostView(ThemedReactContext context) {
        super((Context)context);
        context.addLifecycleEventListener(this);
        this.mHostView = new DialogRootViewGroup((Context)context);
    }

    @TargetApi(value=23)
    public void dispatchProvideStructure(ViewStructure structure) {
        this.mHostView.dispatchProvideStructure(structure);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.dismiss();
    }

    public void addView(View child, int index) {
        UiThreadUtil.assertOnUiThread();
        this.mHostView.addView(child, index);
    }

    public int getChildCount() {
        return this.mHostView == null ? 0 : this.mHostView.getChildCount();
    }

    public View getChildAt(int index) {
        return this.mHostView.getChildAt(index);
    }

    public void removeView(View child) {
        UiThreadUtil.assertOnUiThread();
        this.mHostView.removeView(child);
    }

    public void removeViewAt(int index) {
        UiThreadUtil.assertOnUiThread();
        View child = this.getChildAt(index);
        this.mHostView.removeView(child);
    }

    public void addChildrenForAccessibility(ArrayList<View> outChildren) {
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        return false;
    }

    public void onDropInstance() {
        ((ThemedReactContext)this.getContext()).removeLifecycleEventListener(this);
        this.dismiss();
    }

    private void dismiss() {
        UiThreadUtil.assertOnUiThread();
        if (this.mDialog != null) {
            Activity dialogContext;
            if (this.mDialog.isShowing() && ((dialogContext = ContextUtils.findContextOfType(this.mDialog.getContext(), Activity.class)) == null || !dialogContext.isFinishing())) {
                this.mDialog.dismiss();
            }
            this.mDialog = null;
            ViewGroup parent = (ViewGroup)this.mHostView.getParent();
            parent.removeViewAt(0);
        }
    }

    protected void setOnRequestCloseListener(OnRequestCloseListener listener) {
        this.mOnRequestCloseListener = listener;
    }

    protected void setOnShowListener(DialogInterface.OnShowListener listener) {
        this.mOnShowListener = listener;
    }

    protected void setTransparent(boolean transparent) {
        this.mTransparent = transparent;
    }

    protected void setStatusBarTranslucent(boolean statusBarTranslucent) {
        this.mStatusBarTranslucent = statusBarTranslucent;
        this.mPropertyRequiresNewDialog = true;
    }

    protected void setAnimationType(String animationType) {
        this.mAnimationType = animationType;
        this.mPropertyRequiresNewDialog = true;
    }

    protected void setHardwareAccelerated(boolean hardwareAccelerated) {
        this.mHardwareAccelerated = hardwareAccelerated;
        this.mPropertyRequiresNewDialog = true;
    }

    void setEventDispatcher(EventDispatcher eventDispatcher) {
        this.mHostView.setEventDispatcher(eventDispatcher);
    }

    @Override
    public void onHostResume() {
        this.showOrUpdate();
    }

    @Override
    public void onHostPause() {
    }

    @Override
    public void onHostDestroy() {
        this.onDropInstance();
    }

    @VisibleForTesting
    @Nullable
    public Dialog getDialog() {
        return this.mDialog;
    }

    @Nullable
    private Activity getCurrentActivity() {
        return ((ThemedReactContext)this.getContext()).getCurrentActivity();
    }

    protected void showOrUpdate() {
        UiThreadUtil.assertOnUiThread();
        if (this.mDialog != null) {
            Context dialogContext = (Context)ContextUtils.findContextOfType(this.mDialog.getContext(), Activity.class);
            FLog.e((String)TAG, (String)("Updating existing dialog with context: " + dialogContext + "@" + dialogContext.hashCode()));
            if (this.mPropertyRequiresNewDialog) {
                this.dismiss();
            } else {
                this.updateProperties();
                return;
            }
        }
        this.mPropertyRequiresNewDialog = false;
        int theme = R.style.Theme_FullScreenDialog;
        if (this.mAnimationType.equals("fade")) {
            theme = R.style.Theme_FullScreenDialogAnimatedFade;
        } else if (this.mAnimationType.equals("slide")) {
            theme = R.style.Theme_FullScreenDialogAnimatedSlide;
        }
        Activity currentActivity = this.getCurrentActivity();
        Activity context = currentActivity == null ? this.getContext() : currentActivity;
        this.mDialog = new Dialog((Context)context, theme);
        this.mDialog.getWindow().setFlags(8, 8);
        FLog.e((String)TAG, (String)("Creating new dialog from context: " + context + "@" + context.hashCode()));
        this.mDialog.setContentView(this.getContentView());
        this.updateProperties();
        this.mDialog.setOnShowListener(this.mOnShowListener);
        this.mDialog.setOnKeyListener(new DialogInterface.OnKeyListener(){

            public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                if (event.getAction() == 1) {
                    if (keyCode == 4 || keyCode == 111) {
                        Assertions.assertNotNull((Object)ReactModalHostView.this.mOnRequestCloseListener, (String)"setOnRequestCloseListener must be called by the manager");
                        ReactModalHostView.this.mOnRequestCloseListener.onRequestClose(dialog);
                        return true;
                    }
                    Activity currentActivity = ((ReactContext)ReactModalHostView.this.getContext()).getCurrentActivity();
                    if (currentActivity != null) {
                        return currentActivity.onKeyUp(keyCode, event);
                    }
                }
                return false;
            }
        });
        this.mDialog.getWindow().setSoftInputMode(16);
        if (this.mHardwareAccelerated) {
            this.mDialog.getWindow().addFlags(0x1000000);
        }
        if (currentActivity != null && !currentActivity.isFinishing()) {
            this.mDialog.show();
            if (context instanceof Activity) {
                if (Build.VERSION.SDK_INT > 30) {
                    int appearance = context.getWindow().getInsetsController().getSystemBarsAppearance();
                    this.mDialog.getWindow().getInsetsController().setSystemBarsAppearance(appearance, appearance);
                } else {
                    this.mDialog.getWindow().getDecorView().setSystemUiVisibility(context.getWindow().getDecorView().getSystemUiVisibility());
                }
            }
            this.mDialog.getWindow().clearFlags(8);
        }
    }

    private View getContentView() {
        FrameLayout frameLayout = new FrameLayout(this.getContext());
        frameLayout.addView((View)this.mHostView);
        if (this.mStatusBarTranslucent) {
            frameLayout.setSystemUiVisibility(1024);
        } else {
            frameLayout.setFitsSystemWindows(true);
        }
        return frameLayout;
    }

    private void updateProperties() {
        Assertions.assertNotNull((Object)this.mDialog, (String)"mDialog must exist when we call updateProperties");
        Activity currentActivity = this.getCurrentActivity();
        Window window = this.mDialog.getWindow();
        if (currentActivity == null || currentActivity.isFinishing() || !window.isActive()) {
            return;
        }
        int activityWindowFlags = currentActivity.getWindow().getAttributes().flags;
        if ((activityWindowFlags & 0x400) != 0) {
            window.addFlags(1024);
        } else {
            window.clearFlags(1024);
        }
        if (this.mTransparent) {
            window.clearFlags(2);
        } else {
            window.setDimAmount(0.5f);
            window.setFlags(2, 2);
        }
    }

    @Override
    public FabricViewStateManager getFabricViewStateManager() {
        return this.mHostView.getFabricViewStateManager();
    }

    public void updateState(int width, int height) {
        this.mHostView.updateState(width, height);
    }

    static class DialogRootViewGroup
    extends ReactViewGroup
    implements RootView,
    FabricViewStateManager.HasFabricViewStateManager {
        private boolean hasAdjustedSize = false;
        private int viewWidth;
        private int viewHeight;
        private EventDispatcher mEventDispatcher;
        private final FabricViewStateManager mFabricViewStateManager = new FabricViewStateManager();
        private final JSTouchDispatcher mJSTouchDispatcher = new JSTouchDispatcher(this);
        @Nullable
        private JSPointerDispatcher mJSPointerDispatcher;

        public DialogRootViewGroup(Context context) {
            super(context);
            if (ReactFeatureFlags.dispatchPointerEvents) {
                this.mJSPointerDispatcher = new JSPointerDispatcher(this);
            }
        }

        private void setEventDispatcher(EventDispatcher eventDispatcher) {
            this.mEventDispatcher = eventDispatcher;
        }

        @Override
        protected void onSizeChanged(int w, int h, int oldw, int oldh) {
            super.onSizeChanged(w, h, oldw, oldh);
            this.viewWidth = w;
            this.viewHeight = h;
            this.updateFirstChildView();
        }

        private void updateFirstChildView() {
            if (this.getChildCount() > 0) {
                this.hasAdjustedSize = false;
                final int viewTag = this.getChildAt(0).getId();
                if (this.mFabricViewStateManager.hasStateWrapper()) {
                    this.updateState(this.viewWidth, this.viewHeight);
                } else {
                    ThemedReactContext reactContext = this.getReactContext();
                    reactContext.runOnNativeModulesQueueThread(new GuardedRunnable(reactContext){

                        @Override
                        public void runGuarded() {
                            UIManagerModule uiManager = this.getReactContext().getReactApplicationContext().getNativeModule(UIManagerModule.class);
                            if (uiManager == null) {
                                return;
                            }
                            uiManager.updateNodeSize(viewTag, viewWidth, viewHeight);
                        }
                    });
                }
            } else {
                this.hasAdjustedSize = true;
            }
        }

        @UiThread
        public void updateState(int width, int height) {
            final float realWidth = PixelUtil.toDIPFromPixel(width);
            final float realHeight = PixelUtil.toDIPFromPixel(height);
            ReadableMap currentState = this.getFabricViewStateManager().getStateData();
            if (currentState != null) {
                float stateScreenWidth;
                float delta = 0.9f;
                float stateScreenHeight = currentState.hasKey("screenHeight") ? (float)currentState.getDouble("screenHeight") : 0.0f;
                float f = stateScreenWidth = currentState.hasKey("screenWidth") ? (float)currentState.getDouble("screenWidth") : 0.0f;
                if (Math.abs(stateScreenWidth - realWidth) < delta && Math.abs(stateScreenHeight - realHeight) < delta) {
                    return;
                }
            }
            this.mFabricViewStateManager.setState(new FabricViewStateManager.StateUpdateCallback(){

                @Override
                public WritableMap getStateUpdate() {
                    WritableNativeMap map = new WritableNativeMap();
                    map.putDouble("screenWidth", realWidth);
                    map.putDouble("screenHeight", realHeight);
                    return map;
                }
            });
        }

        @Override
        public void addView(View child, int index, ViewGroup.LayoutParams params) {
            super.addView(child, index, params);
            if (this.hasAdjustedSize) {
                this.updateFirstChildView();
            }
        }

        @Override
        public void handleException(Throwable t) {
            this.getReactContext().getReactApplicationContext().handleException(new RuntimeException(t));
        }

        private ThemedReactContext getReactContext() {
            return (ThemedReactContext)this.getContext();
        }

        @Override
        public boolean onInterceptTouchEvent(MotionEvent event) {
            this.mJSTouchDispatcher.handleTouchEvent(event, this.mEventDispatcher);
            if (this.mJSPointerDispatcher != null) {
                this.mJSPointerDispatcher.handleMotionEvent(event, this.mEventDispatcher, true);
            }
            return super.onInterceptTouchEvent(event);
        }

        @Override
        public boolean onTouchEvent(MotionEvent event) {
            this.mJSTouchDispatcher.handleTouchEvent(event, this.mEventDispatcher);
            if (this.mJSPointerDispatcher != null) {
                this.mJSPointerDispatcher.handleMotionEvent(event, this.mEventDispatcher, false);
            }
            super.onTouchEvent(event);
            return true;
        }

        public boolean onInterceptHoverEvent(MotionEvent event) {
            if (this.mJSPointerDispatcher != null) {
                this.mJSPointerDispatcher.handleMotionEvent(event, this.mEventDispatcher, true);
            }
            return super.onHoverEvent(event);
        }

        public boolean onHoverEvent(MotionEvent event) {
            if (this.mJSPointerDispatcher != null) {
                this.mJSPointerDispatcher.handleMotionEvent(event, this.mEventDispatcher, false);
            }
            return super.onHoverEvent(event);
        }

        @Override
        public void onChildStartedNativeGesture(MotionEvent ev) {
            this.onChildStartedNativeGesture(null, ev);
        }

        @Override
        public void onChildStartedNativeGesture(View childView, MotionEvent ev) {
            this.mJSTouchDispatcher.onChildStartedNativeGesture(ev, this.mEventDispatcher);
            if (this.mJSPointerDispatcher != null) {
                this.mJSPointerDispatcher.onChildStartedNativeGesture(childView, ev, this.mEventDispatcher);
            }
        }

        @Override
        public void onChildEndedNativeGesture(View childView, MotionEvent ev) {
            this.mJSTouchDispatcher.onChildEndedNativeGesture(ev, this.mEventDispatcher);
            if (this.mJSPointerDispatcher != null) {
                this.mJSPointerDispatcher.onChildEndedNativeGesture();
            }
        }

        public void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        }

        @Override
        public FabricViewStateManager getFabricViewStateManager() {
            return this.mFabricViewStateManager;
        }
    }

    public static interface OnRequestCloseListener {
        public void onRequestClose(DialogInterface var1);
    }
}

