/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.events;

import android.view.MotionEvent;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.events.RCTEventEmitter;
import com.facebook.react.uimanager.events.RCTModernEventEmitter;
import com.facebook.react.uimanager.events.TouchEvent;
import com.facebook.react.uimanager.events.TouchEventType;
import com.facebook.systrace.Systrace;

public class TouchesHelper {
    public static final String TARGET_SURFACE_KEY = "targetSurface";
    public static final String TARGET_KEY = "target";
    public static final String CHANGED_TOUCHES_KEY = "changedTouches";
    public static final String TOUCHES_KEY = "touches";
    private static final String PAGE_X_KEY = "pageX";
    private static final String PAGE_Y_KEY = "pageY";
    private static final String TIMESTAMP_KEY = "timestamp";
    private static final String POINTER_IDENTIFIER_KEY = "identifier";
    private static final String LOCATION_X_KEY = "locationX";
    private static final String LOCATION_Y_KEY = "locationY";
    private static final String TAG = "TouchesHelper";

    private static WritableMap[] createPointersArray(TouchEvent event) {
        MotionEvent motionEvent = event.getMotionEvent();
        WritableMap[] touches = new WritableMap[motionEvent.getPointerCount()];
        float targetViewCoordinateX = motionEvent.getX() - event.getViewX();
        float targetViewCoordinateY = motionEvent.getY() - event.getViewY();
        for (int index = 0; index < motionEvent.getPointerCount(); ++index) {
            WritableMap touch = Arguments.createMap();
            touch.putDouble(PAGE_X_KEY, PixelUtil.toDIPFromPixel(motionEvent.getX(index)));
            touch.putDouble(PAGE_Y_KEY, PixelUtil.toDIPFromPixel(motionEvent.getY(index)));
            float locationX = motionEvent.getX(index) - targetViewCoordinateX;
            float locationY = motionEvent.getY(index) - targetViewCoordinateY;
            touch.putDouble(LOCATION_X_KEY, PixelUtil.toDIPFromPixel(locationX));
            touch.putDouble(LOCATION_Y_KEY, PixelUtil.toDIPFromPixel(locationY));
            touch.putInt(TARGET_SURFACE_KEY, event.getSurfaceId());
            touch.putInt(TARGET_KEY, event.getViewTag());
            touch.putDouble(TIMESTAMP_KEY, event.getTimestampMs());
            touch.putDouble(POINTER_IDENTIFIER_KEY, motionEvent.getPointerId(index));
            touches[index] = touch;
        }
        return touches;
    }

    public static void sendTouchesLegacy(RCTEventEmitter rctEventEmitter, TouchEvent touchEvent) {
        TouchEventType type = touchEvent.getTouchEventType();
        WritableArray pointers = TouchesHelper.getWritableArray(false, TouchesHelper.createPointersArray(touchEvent));
        MotionEvent motionEvent = touchEvent.getMotionEvent();
        WritableArray changedIndices = Arguments.createArray();
        if (type == TouchEventType.MOVE || type == TouchEventType.CANCEL) {
            for (int i = 0; i < motionEvent.getPointerCount(); ++i) {
                changedIndices.pushInt(i);
            }
        } else if (type == TouchEventType.START || type == TouchEventType.END) {
            changedIndices.pushInt(motionEvent.getActionIndex());
        } else {
            throw new RuntimeException("Unknown touch type: " + (Object)((Object)type));
        }
        rctEventEmitter.receiveTouches(TouchEventType.getJSEventName(type), pointers, changedIndices);
    }

    public static void sendTouchEvent(RCTModernEventEmitter eventEmitter, TouchEvent event) {
        Systrace.beginSection(0L, "TouchesHelper.sentTouchEventModern(" + event.getEventName() + ")");
        TouchEventType type = event.getTouchEventType();
        MotionEvent motionEvent = event.getMotionEvent();
        if (motionEvent == null) {
            ReactSoftExceptionLogger.logSoftException(TAG, new IllegalStateException("Cannot dispatch a TouchEvent that has no MotionEvent; the TouchEvent has been recycled"));
            return;
        }
        WritableMap[] touches = TouchesHelper.createPointersArray(event);
        WritableMap[] changedTouches = null;
        switch (type) {
            case START: {
                int newPointerIndex = motionEvent.getActionIndex();
                changedTouches = new WritableMap[]{touches[newPointerIndex].copy()};
                break;
            }
            case END: {
                int finishedPointerIndex = motionEvent.getActionIndex();
                WritableMap finishedPointer = touches[finishedPointerIndex];
                touches[finishedPointerIndex] = null;
                changedTouches = new WritableMap[]{finishedPointer};
                break;
            }
            case MOVE: {
                changedTouches = new WritableMap[touches.length];
                for (int i = 0; i < touches.length; ++i) {
                    changedTouches[i] = touches[i].copy();
                }
                break;
            }
            case CANCEL: {
                changedTouches = touches;
                touches = new WritableMap[]{};
            }
        }
        for (WritableMap touchData : changedTouches) {
            WritableMap eventData = touchData.copy();
            WritableArray changedTouchesArray = TouchesHelper.getWritableArray(true, changedTouches);
            WritableArray touchesArray = TouchesHelper.getWritableArray(true, touches);
            eventData.putArray(CHANGED_TOUCHES_KEY, changedTouchesArray);
            eventData.putArray(TOUCHES_KEY, touchesArray);
            eventEmitter.receiveEvent(event.getSurfaceId(), event.getViewTag(), event.getEventName(), event.canCoalesce(), 0, eventData, event.getEventCategory());
        }
        Systrace.endSection(0L);
    }

    private static WritableArray getWritableArray(boolean copyObjects, WritableMap ... objects) {
        WritableArray result = Arguments.createArray();
        for (WritableMap object : objects) {
            if (object == null) continue;
            result.pushMap(copyObjects ? object.copy() : object);
        }
        return result;
    }
}

