/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.turbomodule.core;

import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.facebook.infer.annotation.Assertions;
import com.facebook.jni.HybridData;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.CxxModuleWrapper;
import com.facebook.react.bridge.JSIModule;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.RuntimeExecutor;
import com.facebook.react.turbomodule.core.CallInvokerHolderImpl;
import com.facebook.react.turbomodule.core.TurboModuleManagerDelegate;
import com.facebook.react.turbomodule.core.TurboModulePerfLogger;
import com.facebook.react.turbomodule.core.interfaces.CallInvokerHolder;
import com.facebook.react.turbomodule.core.interfaces.TurboModule;
import com.facebook.react.turbomodule.core.interfaces.TurboModuleRegistry;
import com.facebook.soloader.SoLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TurboModuleManager
implements JSIModule,
TurboModuleRegistry {
    private static volatile boolean sIsSoLibraryLoaded;
    private final List<String> mEagerInitModuleNames;
    private final ModuleProvider<TurboModule> mJavaModuleProvider;
    private final ModuleProvider<TurboModule> mCxxModuleProvider;
    private final Object mModuleCleanupLock = new Object();
    @GuardedBy(value="mModuleCleanupLock")
    private boolean mModuleCleanupStarted = false;
    @GuardedBy(value="mModuleCleanupLock")
    private final Map<String, ModuleHolder> mModuleHolders = new HashMap<String, ModuleHolder>();
    @DoNotStrip
    private final HybridData mHybridData;

    public TurboModuleManager(RuntimeExecutor runtimeExecutor, final @Nullable TurboModuleManagerDelegate delegate, CallInvokerHolder jsCallInvokerHolder, CallInvokerHolder nativeCallInvokerHolder) {
        TurboModuleManager.maybeLoadSoLibrary();
        this.mHybridData = this.initHybrid(runtimeExecutor, (CallInvokerHolderImpl)jsCallInvokerHolder, (CallInvokerHolderImpl)nativeCallInvokerHolder, delegate);
        this.installJSIBindings();
        this.mEagerInitModuleNames = delegate == null ? new ArrayList() : delegate.getEagerInitModuleNames();
        this.mJavaModuleProvider = new ModuleProvider<TurboModule>(){

            @Override
            @Nullable
            public TurboModule getModule(String moduleName) {
                if (delegate == null) {
                    return null;
                }
                return delegate.getModule(moduleName);
            }
        };
        this.mCxxModuleProvider = new ModuleProvider<TurboModule>(){

            @Override
            @Nullable
            public TurboModule getModule(String moduleName) {
                if (delegate == null) {
                    return null;
                }
                CxxModuleWrapper nativeModule = delegate.getLegacyCxxModule(moduleName);
                if (nativeModule != null) {
                    Assertions.assertCondition((boolean)(nativeModule instanceof TurboModule), (String)("CxxModuleWrapper \"" + moduleName + "\" is not a TurboModule"));
                    return (TurboModule)((Object)nativeModule);
                }
                return null;
            }
        };
    }

    @Override
    public List<String> getEagerInitModuleNames() {
        return this.mEagerInitModuleNames;
    }

    @DoNotStrip
    @Nullable
    private CxxModuleWrapper getLegacyCxxModule(String moduleName) {
        TurboModule turboModule = this.getModule(moduleName);
        if (!(turboModule instanceof CxxModuleWrapper)) {
            return null;
        }
        return (CxxModuleWrapper)((Object)turboModule);
    }

    @DoNotStrip
    @Nullable
    private TurboModule getJavaModule(String moduleName) {
        TurboModule turboModule = this.getModule(moduleName);
        if (turboModule instanceof CxxModuleWrapper) {
            return null;
        }
        return turboModule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public TurboModule getModule(String moduleName) {
        ModuleHolder moduleHolder;
        Object object = this.mModuleCleanupLock;
        synchronized (object) {
            if (this.mModuleCleanupStarted) {
                return null;
            }
            if (!this.mModuleHolders.containsKey(moduleName)) {
                this.mModuleHolders.put(moduleName, new ModuleHolder());
            }
            moduleHolder = this.mModuleHolders.get(moduleName);
        }
        TurboModulePerfLogger.moduleCreateStart(moduleName, moduleHolder.getModuleId());
        TurboModule module = (TurboModule)((Object)this.getOrCreateModule(moduleName, moduleHolder, true));
        if (module != null) {
            TurboModulePerfLogger.moduleCreateEnd(moduleName, moduleHolder.getModuleId());
        } else {
            TurboModulePerfLogger.moduleCreateFail(moduleName, moduleHolder.getModuleId());
        }
        return module;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private NativeModule getOrCreateModule(String moduleName, @NonNull ModuleHolder moduleHolder, boolean shouldPerfLog) {
        boolean shouldCreateModule = false;
        ModuleHolder moduleHolder2 = moduleHolder;
        synchronized (moduleHolder2) {
            if (moduleHolder.isDoneCreatingModule()) {
                if (shouldPerfLog) {
                    TurboModulePerfLogger.moduleCreateCacheHit(moduleName, moduleHolder.getModuleId());
                }
                return moduleHolder.getModule();
            }
            if (!moduleHolder.isCreatingModule()) {
                shouldCreateModule = true;
                moduleHolder.startCreatingModule();
            }
        }
        if (shouldCreateModule) {
            ModuleHolder moduleHolder3;
            TurboModulePerfLogger.moduleCreateConstructStart(moduleName, moduleHolder.getModuleId());
            NativeModule nativeModule = (NativeModule)((Object)this.mJavaModuleProvider.getModule(moduleName));
            if (nativeModule == null) {
                nativeModule = (NativeModule)((Object)this.mCxxModuleProvider.getModule(moduleName));
            }
            TurboModulePerfLogger.moduleCreateConstructEnd(moduleName, moduleHolder.getModuleId());
            TurboModulePerfLogger.moduleCreateSetUpStart(moduleName, moduleHolder.getModuleId());
            if (nativeModule != null) {
                moduleHolder3 = moduleHolder;
                synchronized (moduleHolder3) {
                    moduleHolder.setModule(nativeModule);
                }
                nativeModule.initialize();
            }
            TurboModulePerfLogger.moduleCreateSetUpEnd(moduleName, moduleHolder.getModuleId());
            moduleHolder3 = moduleHolder;
            synchronized (moduleHolder3) {
                moduleHolder.endCreatingModule();
                moduleHolder.notifyAll();
            }
            return nativeModule;
        }
        moduleHolder2 = moduleHolder;
        synchronized (moduleHolder2) {
            boolean wasInterrupted = false;
            while (moduleHolder.isCreatingModule()) {
                try {
                    moduleHolder.wait();
                }
                catch (InterruptedException e) {
                    wasInterrupted = true;
                }
            }
            if (wasInterrupted) {
                Thread.currentThread().interrupt();
            }
            return moduleHolder.getModule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<TurboModule> getModules() {
        ArrayList<ModuleHolder> moduleHolders = new ArrayList<ModuleHolder>();
        Object object = this.mModuleCleanupLock;
        synchronized (object) {
            moduleHolders.addAll(this.mModuleHolders.values());
        }
        ArrayList<TurboModule> turboModules = new ArrayList<TurboModule>();
        Iterator iterator2 = moduleHolders.iterator();
        while (iterator2.hasNext()) {
            ModuleHolder moduleHolder;
            ModuleHolder moduleHolder2 = moduleHolder = (ModuleHolder)iterator2.next();
            synchronized (moduleHolder2) {
                if (moduleHolder.getModule() != null) {
                    turboModules.add((TurboModule)((Object)moduleHolder.getModule()));
                }
            }
        }
        return turboModules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasModule(String moduleName) {
        ModuleHolder moduleHolder;
        Object object = this.mModuleCleanupLock;
        synchronized (object) {
            moduleHolder = this.mModuleHolders.get(moduleName);
        }
        if (moduleHolder != null) {
            object = moduleHolder;
            synchronized (object) {
                if (moduleHolder.getModule() != null) {
                    return true;
                }
            }
        }
        return false;
    }

    private native HybridData initHybrid(RuntimeExecutor var1, CallInvokerHolderImpl var2, CallInvokerHolderImpl var3, TurboModuleManagerDelegate var4);

    private native void installJSIBindings();

    @Override
    public void initialize() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCatalystInstanceDestroy() {
        Iterator<Map.Entry<String, ModuleHolder>> iterator2 = this.mModuleCleanupLock;
        synchronized (iterator2) {
            this.mModuleCleanupStarted = true;
        }
        for (Map.Entry<String, ModuleHolder> moduleHolderEntry : this.mModuleHolders.entrySet()) {
            ModuleHolder moduleHolder;
            String moduleName = moduleHolderEntry.getKey();
            NativeModule nativeModule = this.getOrCreateModule(moduleName, moduleHolder = moduleHolderEntry.getValue(), false);
            if (nativeModule == null) continue;
            nativeModule.invalidate();
        }
        this.mModuleHolders.clear();
        this.mHybridData.resetNative();
    }

    private static synchronized void maybeLoadSoLibrary() {
        if (!sIsSoLibraryLoaded) {
            SoLoader.loadLibrary((String)"turbomodulejsijni");
            sIsSoLibraryLoaded = true;
        }
    }

    private static interface ModuleProvider<T> {
        @Nullable
        public T getModule(String var1);
    }

    private static class ModuleHolder {
        private volatile NativeModule mModule = null;
        private volatile boolean mIsTryingToCreate = false;
        private volatile boolean mIsDoneCreatingModule = false;
        private static volatile int sHolderCount = 0;
        private volatile int mModuleId = sHolderCount++;

        int getModuleId() {
            return this.mModuleId;
        }

        void setModule(@NonNull NativeModule module) {
            this.mModule = module;
        }

        @Nullable
        NativeModule getModule() {
            return this.mModule;
        }

        void startCreatingModule() {
            this.mIsTryingToCreate = true;
        }

        void endCreatingModule() {
            this.mIsTryingToCreate = false;
            this.mIsDoneCreatingModule = true;
        }

        boolean isDoneCreatingModule() {
            return this.mIsDoneCreatingModule;
        }

        boolean isCreatingModule() {
            return this.mIsTryingToCreate;
        }
    }
}

