/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.vibration;

import android.annotation.SuppressLint;
import android.os.Build;
import android.os.VibrationEffect;
import android.os.Vibrator;
import com.facebook.fbreact.specs.NativeVibrationSpec;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.module.annotations.ReactModule;

@ReactModule(name="Vibration")
@SuppressLint(value={"MissingPermission"})
public class VibrationModule
extends NativeVibrationSpec {
    public VibrationModule(ReactApplicationContext reactContext) {
        super(reactContext);
    }

    @Override
    public void vibrate(double durationDouble) {
        int duration = (int)durationDouble;
        Vibrator v = (Vibrator)this.getReactApplicationContext().getSystemService("vibrator");
        if (v == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 26) {
            v.vibrate(VibrationEffect.createOneShot((long)duration, (int)-1));
        } else {
            v.vibrate((long)duration);
        }
    }

    @Override
    public void vibrateByPattern(ReadableArray pattern, double repeatDouble) {
        int repeat = (int)repeatDouble;
        Vibrator v = (Vibrator)this.getReactApplicationContext().getSystemService("vibrator");
        if (v == null) {
            return;
        }
        long[] patternLong = new long[pattern.size()];
        for (int i = 0; i < pattern.size(); ++i) {
            patternLong[i] = pattern.getInt(i);
        }
        if (Build.VERSION.SDK_INT >= 26) {
            v.vibrate(VibrationEffect.createWaveform((long[])patternLong, (int)repeat));
        } else {
            v.vibrate(patternLong, repeat);
        }
    }

    @Override
    public void cancel() {
        Vibrator v = (Vibrator)this.getReactApplicationContext().getSystemService("vibrator");
        if (v != null) {
            v.cancel();
        }
    }
}

