/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.network;

import android.content.Context;
import androidx.annotation.Nullable;
import com.facebook.react.modules.network.OkHttpClientFactory;
import com.facebook.react.modules.network.ReactCookieJarContainer;
import java.io.File;
import java.util.concurrent.TimeUnit;
import okhttp3.Cache;
import okhttp3.CookieJar;
import okhttp3.OkHttpClient;

public class OkHttpClientProvider {
    @Nullable
    private static OkHttpClient sClient;
    @Nullable
    private static OkHttpClientFactory sFactory;

    public static void setOkHttpClientFactory(OkHttpClientFactory factory) {
        sFactory = factory;
    }

    public static OkHttpClient getOkHttpClient() {
        if (sClient == null) {
            sClient = OkHttpClientProvider.createClient();
        }
        return sClient;
    }

    public static OkHttpClient createClient() {
        if (sFactory != null) {
            return sFactory.createNewNetworkModuleClient();
        }
        return OkHttpClientProvider.createClientBuilder().build();
    }

    public static OkHttpClient createClient(Context context) {
        if (sFactory != null) {
            return sFactory.createNewNetworkModuleClient();
        }
        return OkHttpClientProvider.createClientBuilder(context).build();
    }

    public static OkHttpClient.Builder createClientBuilder() {
        OkHttpClient.Builder client = new OkHttpClient.Builder().connectTimeout(0L, TimeUnit.MILLISECONDS).readTimeout(0L, TimeUnit.MILLISECONDS).writeTimeout(0L, TimeUnit.MILLISECONDS).cookieJar((CookieJar)new ReactCookieJarContainer());
        return client;
    }

    public static OkHttpClient.Builder createClientBuilder(Context context) {
        int cacheSize = 0xA00000;
        return OkHttpClientProvider.createClientBuilder(context, cacheSize);
    }

    public static OkHttpClient.Builder createClientBuilder(Context context, int cacheSize) {
        OkHttpClient.Builder client = OkHttpClientProvider.createClientBuilder();
        if (cacheSize == 0) {
            return client;
        }
        File cacheDirectory = new File(context.getCacheDir(), "http-cache");
        Cache cache = new Cache(cacheDirectory, (long)cacheSize);
        return client.cache(cache);
    }
}

