/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.blob;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import androidx.annotation.Nullable;
import com.facebook.react.ReactApplication;
import com.facebook.react.ReactNativeHost;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.modules.blob.BlobModule;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class BlobProvider
extends ContentProvider {
    private static final int PIPE_CAPACITY = 65536;
    private ExecutorService executor = Executors.newSingleThreadExecutor();

    public boolean onCreate() {
        return true;
    }

    @Nullable
    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        return null;
    }

    @Nullable
    public String getType(Uri uri) {
        return null;
    }

    @Nullable
    public Uri insert(Uri uri, ContentValues values) {
        return null;
    }

    public int delete(Uri uri, String selection, String[] selectionArgs) {
        return 0;
    }

    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        return 0;
    }

    public ParcelFileDescriptor openFile(Uri uri, String mode) throws FileNotFoundException {
        ParcelFileDescriptor readSide;
        block14: {
            ParcelFileDescriptor[] pipe;
            if (!mode.equals("r")) {
                throw new FileNotFoundException("Cannot open " + uri.toString() + " in mode '" + mode + "'");
            }
            BlobModule blobModule = null;
            Context context = this.getContext().getApplicationContext();
            if (context instanceof ReactApplication) {
                ReactNativeHost host = ((ReactApplication)context).getReactNativeHost();
                ReactContext reactContext = host.getReactInstanceManager().getCurrentReactContext();
                blobModule = reactContext.getNativeModule(BlobModule.class);
            }
            if (blobModule == null) {
                throw new RuntimeException("No blob module associated with BlobProvider");
            }
            final byte[] data = blobModule.resolve(uri);
            if (data == null) {
                throw new FileNotFoundException("Cannot open " + uri.toString() + ", blob not found.");
            }
            try {
                pipe = ParcelFileDescriptor.createPipe();
            }
            catch (IOException exception) {
                return null;
            }
            readSide = pipe[0];
            final ParcelFileDescriptor writeSide = pipe[1];
            if (data.length <= 65536) {
                try (ParcelFileDescriptor.AutoCloseOutputStream outputStream = new ParcelFileDescriptor.AutoCloseOutputStream(writeSide);){
                    outputStream.write(data);
                    break block14;
                }
                catch (IOException exception) {
                    return null;
                }
            }
            Runnable writer = new Runnable(){

                @Override
                public void run() {
                    try (ParcelFileDescriptor.AutoCloseOutputStream outputStream = new ParcelFileDescriptor.AutoCloseOutputStream(writeSide);){
                        outputStream.write(data);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            };
            this.executor.submit(writer);
        }
        return readSide;
    }
}

