/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.animated;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.view.View;
import com.facebook.react.animated.AnimatedNode;
import com.facebook.react.animated.AnimatedNodeWithUpdateableConfig;
import com.facebook.react.animated.NativeAnimatedNodesManager;
import com.facebook.react.animated.PropsAnimatedNode;
import com.facebook.react.animated.ValueAnimatedNode;
import com.facebook.react.bridge.ColorPropConverter;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.views.view.ColorUtil;
import java.util.Iterator;

class ColorAnimatedNode
extends AnimatedNode
implements AnimatedNodeWithUpdateableConfig {
    private final NativeAnimatedNodesManager mNativeAnimatedNodesManager;
    private final ReactApplicationContext mReactApplicationContext;
    private int mRNodeId;
    private int mGNodeId;
    private int mBNodeId;
    private int mANodeId;
    private ReadableMap mNativeColor;
    private boolean mNativeColorApplied;

    public ColorAnimatedNode(ReadableMap config, NativeAnimatedNodesManager nativeAnimatedNodesManager, ReactApplicationContext reactApplicationContext) {
        this.mNativeAnimatedNodesManager = nativeAnimatedNodesManager;
        this.mReactApplicationContext = reactApplicationContext;
        this.onUpdateConfig(config);
    }

    public int getColor() {
        this.tryApplyNativeColor();
        ValueAnimatedNode rNode = (ValueAnimatedNode)this.mNativeAnimatedNodesManager.getNodeById(this.mRNodeId);
        ValueAnimatedNode gNode = (ValueAnimatedNode)this.mNativeAnimatedNodesManager.getNodeById(this.mGNodeId);
        ValueAnimatedNode bNode = (ValueAnimatedNode)this.mNativeAnimatedNodesManager.getNodeById(this.mBNodeId);
        ValueAnimatedNode aNode = (ValueAnimatedNode)this.mNativeAnimatedNodesManager.getNodeById(this.mANodeId);
        double r = rNode.getValue();
        double g = gNode.getValue();
        double b = bNode.getValue();
        double a = aNode.getValue();
        return ColorUtil.normalize(r, g, b, a);
    }

    @Override
    public void onUpdateConfig(ReadableMap config) {
        this.mRNodeId = config.getInt("r");
        this.mGNodeId = config.getInt("g");
        this.mBNodeId = config.getInt("b");
        this.mANodeId = config.getInt("a");
        this.mNativeColor = config.getMap("nativeColor");
        this.mNativeColorApplied = false;
        this.tryApplyNativeColor();
    }

    @Override
    public String prettyPrint() {
        return "ColorAnimatedNode[" + this.mTag + "]: r: " + this.mRNodeId + " g: " + this.mGNodeId + " b: " + this.mBNodeId + " a: " + this.mANodeId;
    }

    private void tryApplyNativeColor() {
        if (this.mNativeColor == null || this.mNativeColorApplied) {
            return;
        }
        Context context = this.getContext();
        if (context == null) {
            return;
        }
        int color = ColorPropConverter.getColor(this.mNativeColor, context);
        ValueAnimatedNode rNode = (ValueAnimatedNode)this.mNativeAnimatedNodesManager.getNodeById(this.mRNodeId);
        ValueAnimatedNode gNode = (ValueAnimatedNode)this.mNativeAnimatedNodesManager.getNodeById(this.mGNodeId);
        ValueAnimatedNode bNode = (ValueAnimatedNode)this.mNativeAnimatedNodesManager.getNodeById(this.mBNodeId);
        ValueAnimatedNode aNode = (ValueAnimatedNode)this.mNativeAnimatedNodesManager.getNodeById(this.mANodeId);
        rNode.mValue = Color.red((int)color);
        gNode.mValue = Color.green((int)color);
        bNode.mValue = Color.blue((int)color);
        aNode.mValue = (double)Color.alpha((int)color) / 255.0;
        this.mNativeColorApplied = true;
    }

    private Context getContext() {
        Activity context = this.mReactApplicationContext.getCurrentActivity();
        if (context != null) {
            return context;
        }
        return ColorAnimatedNode.getContextHelper(this);
    }

    private static Context getContextHelper(AnimatedNode node) {
        Iterator<AnimatedNode> iterator2;
        if (node.mChildren != null && (iterator2 = node.mChildren.iterator()).hasNext()) {
            AnimatedNode child = iterator2.next();
            if (child instanceof PropsAnimatedNode) {
                View view = ((PropsAnimatedNode)child).getConnectedView();
                return view != null ? view.getContext() : null;
            }
            return ColorAnimatedNode.getContextHelper(child);
        }
        return null;
    }
}

