/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.columnar;

import java.util.List;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.columnar.LazyBinaryColumnarSerDe;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinarySerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.io.Writable;

public class OptimizedLazyBinaryColumnarSerde
extends LazyBinaryColumnarSerDe {
    @Override
    public Writable serialize(Object obj, ObjectInspector objInspector) throws SerDeException {
        if (objInspector.getCategory() != ObjectInspector.Category.STRUCT) {
            throw new SerDeException(this.getClass().toString() + " can only serialize struct types, but we got: " + objInspector.getTypeName());
        }
        StructObjectInspector soi = (StructObjectInspector)objInspector;
        List<? extends StructField> fields = soi.getAllStructFieldRefs();
        List<Object> list = soi.getStructFieldsDataAsList(obj);
        LazyBinarySerDe.BooleanRef warnedOnceNullMapKey = new LazyBinarySerDe.BooleanRef(false);
        this.serializeStream.reset();
        this.serializedSize = 0L;
        int streamOffset = 0;
        for (int i = 0; i < fields.size(); ++i) {
            Object f;
            ObjectInspector foi = fields.get(i).getFieldObjectInspector();
            Object object = f = list == null ? null : list.get(i);
            if (f != null && foi.getCategory().equals((Object)ObjectInspector.Category.PRIMITIVE) && ((PrimitiveObjectInspector)foi).getPrimitiveCategory().equals((Object)PrimitiveObjectInspector.PrimitiveCategory.STRING) && ((StringObjectInspector)foi).getPrimitiveWritableObject(f).getLength() == 0) {
                this.serializeStream.write(INVALID_UTF__SINGLE_BYTE, 0, 1);
            } else {
                LazyBinarySerDe.serialize(this.serializeStream, f, foi, true, warnedOnceNullMapKey);
            }
            this.field[i].set(this.serializeStream.getData(), streamOffset, this.serializeStream.getLength() - streamOffset);
            streamOffset = this.serializeStream.getLength();
        }
        this.serializedSize = this.serializeStream.getLength();
        this.lastOperationSerialize = true;
        this.lastOperationDeserialize = false;
        return this.serializeCache;
    }
}

