/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import com.facebook.presto.hive.$internal.org.slf4j.Logger;
import com.facebook.presto.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.ValidReaderWriteIdList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.ReplChangeManager;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.ShowLocksRequest;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponseElement;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.txn.CompactionInfo;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorThread;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;

public class Cleaner
extends CompactorThread {
    private static final String CLASS_NAME = Cleaner.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger(CLASS_NAME);
    private long cleanerCheckInterval = 0L;
    private ReplChangeManager replChangeManager;
    private Map<Long, Set<Long>> compactId2LockMap = new HashMap<Long, Set<Long>>();
    private Map<Long, CompactionInfo> compactId2CompactInfoMap = new HashMap<Long, CompactionInfo>();

    @Override
    public void init(AtomicBoolean stop, AtomicBoolean looped) throws MetaException {
        super.init(stop, looped);
        this.replChangeManager = ReplChangeManager.getInstance(this.conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.cleanerCheckInterval == 0L) {
            this.cleanerCheckInterval = this.conf.getTimeVar(HiveConf.ConfVars.HIVE_COMPACTOR_CLEANER_RUN_INTERVAL, TimeUnit.MILLISECONDS);
        }
        do {
            long elapsedTime;
            boolean setLooped = !this.looped.get();
            TxnStore.MutexAPI.LockHandle handle = null;
            long startedAt = -1L;
            try {
                handle = this.txnHandler.getMutexAPI().acquireLock(TxnStore.MUTEX_KEY.Cleaner.name());
                startedAt = System.currentTimeMillis();
                List<CompactionInfo> toClean = this.txnHandler.findReadyToClean();
                HashSet<Long> currentToCleanSet = new HashSet<Long>();
                for (CompactionInfo compactionInfo : toClean) {
                    currentToCleanSet.add(compactionInfo.id);
                }
                HashSet<Long> cleanPerformedByOthers = new HashSet<Long>();
                for (long id : this.compactId2CompactInfoMap.keySet()) {
                    if (currentToCleanSet.contains(id)) continue;
                    cleanPerformedByOthers.add(id);
                }
                Iterator iterator = cleanPerformedByOthers.iterator();
                while (iterator.hasNext()) {
                    long id;
                    id = (Long)iterator.next();
                    this.compactId2CompactInfoMap.remove(id);
                    this.compactId2LockMap.remove(id);
                }
                if (toClean.size() > 0 || this.compactId2LockMap.size() > 0) {
                    ShowLocksResponse locksResponse = this.txnHandler.showLocks(new ShowLocksRequest());
                    if (LOG.isDebugEnabled()) {
                        this.dumpLockState(locksResponse);
                    }
                    for (CompactionInfo compactionInfo : toClean) {
                        if (this.compactId2LockMap.containsKey(compactionInfo.id)) continue;
                        this.compactId2LockMap.put(compactionInfo.id, this.findRelatedLocks(compactionInfo, locksResponse));
                        this.compactId2CompactInfoMap.put(compactionInfo.id, compactionInfo);
                    }
                    Set<Long> currentLocks = this.buildCurrentLockSet(locksResponse);
                    ArrayList<Long> arrayList = new ArrayList<Long>();
                    ArrayList<Long> compactionsCleaned = new ArrayList<Long>();
                    try {
                        for (Map.Entry<Long, Set<Long>> queueEntry : this.compactId2LockMap.entrySet()) {
                            boolean sawLock = false;
                            for (Long lockId : queueEntry.getValue()) {
                                if (currentLocks.contains(lockId)) {
                                    sawLock = true;
                                    break;
                                }
                                arrayList.add(lockId);
                            }
                            if (!sawLock) {
                                compactionsCleaned.add(queueEntry.getKey());
                                this.clean(this.compactId2CompactInfoMap.get(queueEntry.getKey()));
                                continue;
                            }
                            for (Long lockId : arrayList) {
                                queueEntry.getValue().remove(lockId);
                            }
                            LOG.info("Skipping cleaning of " + Cleaner.idWatermark(this.compactId2CompactInfoMap.get(queueEntry.getKey())) + " due to reader present: " + queueEntry.getValue());
                        }
                    }
                    finally {
                        if (compactionsCleaned.size() > 0) {
                            for (Long compactId : compactionsCleaned) {
                                this.compactId2LockMap.remove(compactId);
                                this.compactId2CompactInfoMap.remove(compactId);
                            }
                        }
                    }
                }
            }
            catch (Throwable t) {
                LOG.error("Caught an exception in the main loop of compactor cleaner, " + StringUtils.stringifyException((Throwable)t));
            }
            finally {
                if (handle != null) {
                    handle.releaseLocks();
                }
            }
            if (setLooped) {
                this.looped.set(true);
            }
            if ((elapsedTime = System.currentTimeMillis() - startedAt) >= this.cleanerCheckInterval || this.stop.get()) continue;
            try {
                Thread.sleep(this.cleanerCheckInterval - elapsedTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!this.stop.get());
    }

    private Set<Long> findRelatedLocks(CompactionInfo ci, ShowLocksResponse locksResponse) {
        HashSet<Long> relatedLocks = new HashSet<Long>();
        for (ShowLocksResponseElement lock2 : locksResponse.getLocks()) {
            if (!ci.dbname.equalsIgnoreCase(lock2.getDbname()) || (ci.tableName != null || lock2.getTablename() != null) && (ci.tableName == null || !ci.tableName.equalsIgnoreCase(lock2.getTablename())) || (ci.partName != null || lock2.getPartname() != null) && (ci.partName == null || !ci.partName.equals(lock2.getPartname()))) continue;
            relatedLocks.add(lock2.getLockid());
        }
        return relatedLocks;
    }

    private Set<Long> buildCurrentLockSet(ShowLocksResponse locksResponse) {
        HashSet<Long> currentLocks = new HashSet<Long>(locksResponse.getLocks().size());
        for (ShowLocksResponseElement lock2 : locksResponse.getLocks()) {
            currentLocks.add(lock2.getLockid());
        }
        return currentLocks;
    }

    private void clean(final CompactionInfo ci) throws MetaException {
        LOG.info("Starting cleaning for " + ci);
        try {
            ValidReaderWriteIdList validWriteIdList;
            Table t = this.resolveTable(ci);
            if (t == null) {
                LOG.info("Unable to find table " + ci.getFullTableName() + ", assuming it was dropped." + Cleaner.idWatermark(ci));
                this.txnHandler.markCleaned(ci);
                return;
            }
            Partition p = null;
            if (ci.partName != null && (p = this.resolvePartition(ci)) == null) {
                LOG.info("Unable to find partition " + ci.getFullPartitionName() + ", assuming it was dropped." + Cleaner.idWatermark(ci));
                this.txnHandler.markCleaned(ci);
                return;
            }
            StorageDescriptor sd = this.resolveStorageDescriptor(t, p);
            final String location = sd.getLocation();
            ValidReaderWriteIdList validReaderWriteIdList = validWriteIdList = ci.highestWriteId > 0L ? new ValidReaderWriteIdList(ci.getFullTableName(), new long[0], new BitSet(), ci.highestWriteId) : new ValidReaderWriteIdList();
            if (this.runJobAsSelf(ci.runAs)) {
                this.removeFiles(location, validWriteIdList, ci);
            } else {
                LOG.info("Cleaning as user " + ci.runAs + " for " + ci.getFullPartitionName());
                UserGroupInformation ugi = UserGroupInformation.createProxyUser((String)ci.runAs, (UserGroupInformation)UserGroupInformation.getLoginUser());
                ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        Cleaner.this.removeFiles(location, validWriteIdList, ci);
                        return null;
                    }
                });
                try {
                    FileSystem.closeAllForUGI((UserGroupInformation)ugi);
                }
                catch (IOException exception) {
                    LOG.error("Could not clean up file-system handles for UGI: " + ugi + " for " + ci.getFullPartitionName() + Cleaner.idWatermark(ci), exception);
                }
            }
            this.txnHandler.markCleaned(ci);
        }
        catch (Exception e) {
            LOG.error("Caught exception when cleaning, unable to complete cleaning of " + ci + " " + StringUtils.stringifyException((Throwable)e));
            this.txnHandler.markFailed(ci);
        }
    }

    private static String idWatermark(CompactionInfo ci) {
        return " id=" + ci.id;
    }

    private void removeFiles(String location, ValidWriteIdList writeIdList, CompactionInfo ci) throws IOException {
        Path locPath = new Path(location);
        AcidUtils.Directory dir = AcidUtils.getAcidState(locPath, this.conf, writeIdList);
        List<FileStatus> obsoleteDirs = dir.getObsolete();
        ArrayList<Path> filesToDelete = new ArrayList<Path>(obsoleteDirs.size());
        StringBuilder extraDebugInfo = new StringBuilder("[");
        for (FileStatus stat : obsoleteDirs) {
            filesToDelete.add(stat.getPath());
            extraDebugInfo.append(stat.getPath().getName()).append(",");
            if (FileUtils.isPathWithinSubtree(stat.getPath(), locPath)) continue;
            LOG.info(Cleaner.idWatermark(ci) + " found unexpected file: " + stat.getPath());
        }
        extraDebugInfo.setCharAt(extraDebugInfo.length() - 1, ']');
        ArrayList<Long> compactIds = new ArrayList<Long>(this.compactId2CompactInfoMap.keySet());
        Collections.sort(compactIds);
        extraDebugInfo.append("compactId2CompactInfoMap.keySet(").append(compactIds).append(")");
        LOG.info(Cleaner.idWatermark(ci) + " About to remove " + filesToDelete.size() + " obsolete directories from " + location + ". " + extraDebugInfo.toString());
        if (filesToDelete.size() < 1) {
            LOG.warn("Hmm, nothing to delete in the cleaner for directory " + location + ", that hardly seems right.");
            return;
        }
        FileSystem fs = ((Path)filesToDelete.get(0)).getFileSystem((Configuration)this.conf);
        for (Path dead : filesToDelete) {
            LOG.debug("Going to delete path " + dead.toString());
            this.replChangeManager.recycle(dead, ReplChangeManager.RecycleType.MOVE, true);
            fs.delete(dead, true);
        }
    }

    private void dumpLockState(ShowLocksResponse slr) {
        Iterator<ShowLocksResponseElement> l = slr.getLocksIterator();
        ArrayList<ShowLocksResponseElement> sortedList = new ArrayList<ShowLocksResponseElement>();
        while (l.hasNext()) {
            sortedList.add(l.next());
        }
        sortedList.sort(new LockComparator());
        LOG.info("dumping locks");
        for (ShowLocksResponseElement lock2 : sortedList) {
            LOG.info(lock2.toString());
        }
    }

    private static class LockComparator
    implements Comparator<ShowLocksResponseElement> {
        private LockComparator() {
        }

        @Override
        public int compare(ShowLocksResponseElement o1, ShowLocksResponseElement o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            int v = o1.getDbname().compareToIgnoreCase(o2.getDbname());
            if (v != 0) {
                return v;
            }
            if (o1.getTablename() == null) {
                return -1;
            }
            if (o2.getTablename() == null) {
                return 1;
            }
            v = o1.getTablename().compareToIgnoreCase(o2.getTablename());
            if (v != 0) {
                return v;
            }
            if (o1.getPartname() == null) {
                return -1;
            }
            if (o2.getPartname() == null) {
                return 1;
            }
            v = o1.getPartname().compareToIgnoreCase(o2.getPartname());
            if (v != 0) {
                return v;
            }
            v = Long.compare(o1.getLockid(), o2.getLockid());
            if (v != 0) {
                return v;
            }
            return Long.compare(o1.getLockIdInternal(), o2.getLockIdInternal());
        }
    }
}

