/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import com.facebook.presto.hive.$internal.org.slf4j.Logger;
import com.facebook.presto.hive.$internal.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.ResourceType;
import org.apache.hadoop.hive.metastore.api.ResourceUri;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.FunctionUtils;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.CreateFunctionDesc;
import org.apache.hadoop.hive.ql.plan.DropFunctionDesc;
import org.apache.hadoop.hive.ql.plan.FunctionWork;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.ReloadFunctionDesc;

public class FunctionSemanticAnalyzer
extends BaseSemanticAnalyzer {
    private static final Logger LOG = LoggerFactory.getLogger(FunctionSemanticAnalyzer.class);
    private static final Logger SESISON_STATE_LOG = LoggerFactory.getLogger("SessionState");

    public FunctionSemanticAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode ast) throws SemanticException {
        if (ast.getType() == 783) {
            this.analyzeCreateFunction(ast);
        } else if (ast.getType() == 820) {
            this.analyzeDropFunction(ast);
        } else if (ast.getType() == 962) {
            this.rootTasks.add(TaskFactory.get(new FunctionWork(new ReloadFunctionDesc())));
        }
        LOG.info("analyze done");
    }

    private void analyzeCreateFunction(ASTNode ast) throws SemanticException {
        String functionName = ast.getChild(0).getText().toLowerCase();
        boolean isTemporaryFunction = ast.getFirstChildWithType(1070) != null;
        String className = FunctionSemanticAnalyzer.unescapeSQLString(ast.getChild(1).getText());
        if (isTemporaryFunction && FunctionUtils.isQualifiedFunctionName(functionName)) {
            throw new SemanticException("Temporary function cannot be created with a qualified name.");
        }
        List<ResourceUri> resources = this.getResourceList(ast);
        if (!isTemporaryFunction && resources == null) {
            SESISON_STATE_LOG.warn("permanent functions created without USING  clause will not be replicated.");
        }
        CreateFunctionDesc desc = new CreateFunctionDesc(functionName, isTemporaryFunction, className, resources, null);
        this.rootTasks.add(TaskFactory.get(new FunctionWork(desc)));
        this.addEntities(functionName, className, isTemporaryFunction, resources);
    }

    private void analyzeDropFunction(ASTNode ast) throws SemanticException {
        String functionName = ast.getChild(0).getText();
        boolean ifExists = ast.getFirstChildWithType(858) != null;
        boolean throwException = !ifExists && !HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.DROPIGNORESNONEXISTENT);
        FunctionInfo info = FunctionRegistry.getFunctionInfo(functionName);
        if (info == null) {
            if (throwException) {
                throw new SemanticException(ErrorMsg.INVALID_FUNCTION.getMsg(functionName));
            }
            return;
        }
        if (info.isBuiltIn()) {
            throw new SemanticException(ErrorMsg.DROP_NATIVE_FUNCTION.getMsg(functionName));
        }
        boolean isTemporaryFunction = ast.getFirstChildWithType(1070) != null;
        DropFunctionDesc desc = new DropFunctionDesc(functionName, isTemporaryFunction, null);
        this.rootTasks.add(TaskFactory.get(new FunctionWork(desc)));
        this.addEntities(functionName, info.getClassName(), isTemporaryFunction, null);
    }

    private ResourceType getResourceType(ASTNode token) throws SemanticException {
        switch (token.getType()) {
            case 879: {
                return ResourceType.JAR;
            }
            case 839: {
                return ResourceType.FILE;
            }
            case 767: {
                return ResourceType.ARCHIVE;
            }
        }
        throw new SemanticException("Unexpected token " + token.toString());
    }

    private List<ResourceUri> getResourceList(ASTNode ast) throws SemanticException {
        ArrayList<ResourceUri> resources = null;
        ASTNode resourcesNode = (ASTNode)ast.getFirstChildWithType(973);
        if (resourcesNode != null) {
            resources = new ArrayList<ResourceUri>();
            for (int idx = 0; idx < resourcesNode.getChildCount(); ++idx) {
                ASTNode resNode = (ASTNode)resourcesNode.getChild(idx);
                if (resNode.getToken().getType() != 974) {
                    throw new SemanticException("Expected token type TOK_RESOURCE_URI but found " + resNode.getToken().toString());
                }
                if (resNode.getChildCount() != 2) {
                    throw new SemanticException("Expected 2 child nodes of TOK_RESOURCE_URI but found " + resNode.getChildCount());
                }
                ASTNode resTypeNode = (ASTNode)resNode.getChild(0);
                ASTNode resUriNode = (ASTNode)resNode.getChild(1);
                ResourceType resourceType = this.getResourceType(resTypeNode);
                resources.add(new ResourceUri(resourceType, PlanUtils.stripQuotes(resUriNode.getText())));
            }
        }
        return resources;
    }

    private void addEntities(String functionName, String className, boolean isTemporaryFunction, List<ResourceUri> resources) throws SemanticException {
        Database database = null;
        if (!isTemporaryFunction) {
            try {
                String[] qualifiedNameParts = FunctionUtils.getQualifiedFunctionNameParts(functionName);
                String dbName = qualifiedNameParts[0];
                functionName = qualifiedNameParts[1];
                database = this.getDatabase(dbName);
            }
            catch (HiveException e) {
                LOG.error("Failed to get database ", e);
                throw new SemanticException(e);
            }
        }
        if (database != null) {
            this.outputs.add(new WriteEntity(database, WriteEntity.WriteType.DDL_NO_LOCK));
        }
        this.outputs.add(new WriteEntity(database, functionName, className, Entity.Type.FUNCTION, WriteEntity.WriteType.DDL_NO_LOCK));
        if (resources != null) {
            for (ResourceUri resource : resources) {
                String uriPath = resource.getUri();
                this.outputs.add(this.toWriteEntity(uriPath));
            }
        }
    }
}

