/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.physical;

import com.facebook.presto.hive.$internal.org.slf4j.Logger;
import com.facebook.presto.hive.$internal.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.LimitOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.optimizer.physical.MetadataOnlyOptimizer;
import org.apache.hadoop.hive.ql.optimizer.physical.NullScanTaskDispatcher;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalContext;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalPlanResolver;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.LimitDesc;

public class NullScanOptimizer
implements PhysicalPlanResolver {
    private static final Logger LOG = LoggerFactory.getLogger(NullScanOptimizer.class.getName());

    @Override
    public PhysicalContext resolve(PhysicalContext pctx) throws SemanticException {
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        opRules.put(new RuleRegExp("R1", TableScanOperator.getOperatorName() + "%.*" + FilterOperator.getOperatorName() + "%"), new WhereFalseProcessor());
        NullScanTaskDispatcher disp = new NullScanTaskDispatcher(pctx, opRules);
        DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(pctx.getRootTasks());
        ogw.startWalking(topNodes, null);
        opRules.clear();
        opRules.put(new RuleRegExp("R1", TableScanOperator.getOperatorName() + "%"), new TSMarker());
        opRules.put(new RuleRegExp("R2", LimitOperator.getOperatorName() + "%"), new Limit0Processor());
        disp = new NullScanTaskDispatcher(pctx, opRules);
        ogw = new DefaultGraphWalker(disp);
        topNodes = new ArrayList();
        topNodes.addAll(pctx.getRootTasks());
        ogw.startWalking(topNodes, null);
        return pctx;
    }

    private static boolean isNullOpPresentInAllBranches(TableScanOperator ts, Node causeOfNullNode) {
        Node curNode = null;
        List<? extends Node> curChd = null;
        LinkedList<Node> middleNodes = new LinkedList<Node>();
        middleNodes.addLast(ts);
        while (!middleNodes.isEmpty()) {
            curNode = (Node)middleNodes.remove();
            curChd = curNode.getChildren();
            for (Node node : curChd) {
                if (node.getChildren() == null || node.getChildren().isEmpty() || node == causeOfNullNode) {
                    if (node == causeOfNullNode) continue;
                    return false;
                }
                middleNodes.addLast(node);
            }
        }
        return true;
    }

    private static class TSMarker
    implements NodeProcessor {
        private TSMarker() {
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            ((MetadataOnlyOptimizer.WalkerCtx)procCtx).setMayBeMetadataOnly((TableScanOperator)nd);
            return null;
        }
    }

    private static class Limit0Processor
    implements NodeProcessor {
        private Limit0Processor() {
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            LimitOperator limitOp = (LimitOperator)nd;
            if (((LimitDesc)limitOp.getConf()).getLimit() != 0) {
                return null;
            }
            HashSet<TableScanOperator> tsOps = ((MetadataOnlyOptimizer.WalkerCtx)procCtx).getMayBeMetadataOnlyTableScans();
            if (tsOps != null) {
                Iterator<TableScanOperator> tsOp = tsOps.iterator();
                while (tsOp.hasNext()) {
                    if (NullScanOptimizer.isNullOpPresentInAllBranches(tsOp.next(), limitOp)) continue;
                    tsOp.remove();
                }
            }
            LOG.info("Found Limit 0 TableScan. " + nd);
            ((MetadataOnlyOptimizer.WalkerCtx)procCtx).convertMetadataOnly();
            return null;
        }
    }

    private static class WhereFalseProcessor
    implements NodeProcessor {
        private WhereFalseProcessor() {
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            FilterOperator filter = (FilterOperator)nd;
            ExprNodeDesc condition = ((FilterDesc)filter.getConf()).getPredicate();
            if (!(condition instanceof ExprNodeConstantDesc)) {
                return null;
            }
            ExprNodeConstantDesc c = (ExprNodeConstantDesc)condition;
            if (!Boolean.FALSE.equals(c.getValue())) {
                return null;
            }
            MetadataOnlyOptimizer.WalkerCtx ctx = (MetadataOnlyOptimizer.WalkerCtx)procCtx;
            for (Node op : stack) {
                if (!(op instanceof TableScanOperator) || !NullScanOptimizer.isNullOpPresentInAllBranches((TableScanOperator)op, filter)) continue;
                ctx.setMayBeMetadataOnly((TableScanOperator)op);
                LOG.info("Found where false TableScan. " + op);
            }
            ctx.convertMetadataOnly();
            return null;
        }
    }
}

