/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import com.facebook.presto.hive.$internal.com.google.common.collect.Lists;
import com.facebook.presto.hive.$internal.org.slf4j.Logger;
import com.facebook.presto.hive.$internal.org.slf4j.LoggerFactory;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.metadata.RelColumnOrigin;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.util.Pair;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveIn;
import org.apache.hadoop.hive.ql.plan.ColStatistics;
import org.apache.hadoop.hive.ql.stats.StatsUtils;

public class HiveReduceExpressionsWithStatsRule
extends RelOptRule {
    protected static final Logger LOG = LoggerFactory.getLogger(HiveReduceExpressionsWithStatsRule.class);
    public static final HiveReduceExpressionsWithStatsRule INSTANCE = new HiveReduceExpressionsWithStatsRule();
    private static final Set<SqlKind> COMPARISON = EnumSet.of(SqlKind.EQUALS, SqlKind.GREATER_THAN_OR_EQUAL, SqlKind.LESS_THAN_OR_EQUAL, SqlKind.GREATER_THAN, SqlKind.LESS_THAN);

    private HiveReduceExpressionsWithStatsRule() {
        super(HiveReduceExpressionsWithStatsRule.operand(Filter.class, (RelOptRuleOperand)HiveReduceExpressionsWithStatsRule.operand(RelNode.class, (RelOptRuleOperandChildren)HiveReduceExpressionsWithStatsRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]));
    }

    public void onMatch(RelOptRuleCall call) {
        Filter filter = (Filter)call.rel(0);
        RexBuilder rexBuilder = filter.getCluster().getRexBuilder();
        RelMetadataQuery metadataProvider = call.getMetadataQuery();
        RexNode newFilterCondition = RexUtil.pullFactors((RexBuilder)rexBuilder, (RexNode)filter.getCondition());
        RexReplacer replacer = new RexReplacer(filter, rexBuilder, metadataProvider);
        newFilterCondition = replacer.apply(newFilterCondition);
        if (!filter.getCondition().toString().equals(newFilterCondition.toString())) {
            Filter newFilter = filter.copy(filter.getTraitSet(), filter.getInput(), newFilterCondition);
            call.transformTo((RelNode)newFilter);
        }
    }

    protected static class RexReplacer
    extends RexShuttle {
        private final Filter filterOp;
        private final RexBuilder rexBuilder;
        private final RelMetadataQuery metadataProvider;

        RexReplacer(Filter filterOp, RexBuilder rexBuilder, RelMetadataQuery metadataProvider) {
            this.filterOp = filterOp;
            this.rexBuilder = rexBuilder;
            this.metadataProvider = metadataProvider;
        }

        public RexNode visitCall(RexCall call) {
            RexNode node;
            if (COMPARISON.contains(call.getOperator().getKind())) {
                RexNode reduced;
                RexInputRef ref = null;
                RexLiteral literal = null;
                SqlKind kind = null;
                if (call.operands.get(0) instanceof RexInputRef && call.operands.get(1) instanceof RexLiteral) {
                    ref = (RexInputRef)call.operands.get(0);
                    literal = (RexLiteral)call.operands.get(1);
                    kind = call.getOperator().getKind();
                } else if (call.operands.get(1) instanceof RexInputRef && call.operands.get(0) instanceof RexLiteral) {
                    ref = (RexInputRef)call.operands.get(1);
                    literal = (RexLiteral)call.operands.get(0);
                    kind = call.getOperator().getKind().reverse();
                }
                Number max = null;
                Number min = null;
                if (ref != null && literal != null && kind != null) {
                    Pair<Number, Number> maxMin = this.extractMaxMin(ref);
                    max = (Number)maxMin.left;
                    min = (Number)maxMin.right;
                }
                if (max != null && min != null && (reduced = this.reduceCall(literal, kind, max, min)) != null) {
                    return reduced;
                }
                return call;
            }
            if (call.getOperator().getKind() == SqlKind.IN) {
                if (call.getOperands().get(0) instanceof RexInputRef) {
                    RexInputRef ref = (RexInputRef)call.getOperands().get(0);
                    Number max = null;
                    Number min = null;
                    if (ref != null) {
                        Pair<Number, Number> maxMin = this.extractMaxMin(ref);
                        max = (Number)maxMin.left;
                        min = (Number)maxMin.right;
                    }
                    if (max != null && min != null) {
                        ArrayList<Object> newOperands = Lists.newArrayList();
                        newOperands.add(ref);
                        for (int i = 1; i < call.getOperands().size(); ++i) {
                            RexNode operand = (RexNode)call.getOperands().get(i);
                            if (operand instanceof RexLiteral) {
                                RexLiteral literal = (RexLiteral)operand;
                                RexNode reduced = this.reduceCall(literal, SqlKind.EQUALS, max, min);
                                if (reduced != null) {
                                    if (!reduced.isAlwaysTrue()) continue;
                                    return this.rexBuilder.makeLiteral(true);
                                }
                                newOperands.add(literal);
                                continue;
                            }
                            newOperands.add(operand);
                        }
                        if (newOperands.size() == 1) {
                            return this.rexBuilder.makeLiteral(false);
                        }
                        return this.rexBuilder.makeCall((SqlOperator)HiveIn.INSTANCE, newOperands);
                    }
                } else if (((RexNode)call.getOperands().get(0)).getKind() == SqlKind.ROW) {
                    RexCall struct = (RexCall)call.getOperands().get(0);
                    ArrayList<RexInputRef> refs = Lists.newArrayList();
                    ArrayList<Pair<Number, Number>> maxMinStats = Lists.newArrayList();
                    for (RexNode operand : struct.getOperands()) {
                        if (!(operand instanceof RexInputRef)) {
                            return call;
                        }
                        RexInputRef ref = (RexInputRef)operand;
                        refs.add(ref);
                        maxMinStats.add(this.extractMaxMin(ref));
                    }
                    ArrayList newOperands = Lists.newArrayList();
                    newOperands.add(struct);
                    for (int i = 1; i < call.getOperands().size(); ++i) {
                        RexCall constStruct = (RexCall)call.getOperands().get(i);
                        boolean allTrue = true;
                        boolean addOperand = true;
                        int j = 0;
                        while (i < constStruct.getOperands().size()) {
                            RexNode operand = (RexNode)constStruct.getOperands().get(j);
                            if (operand instanceof RexLiteral) {
                                RexLiteral literal = (RexLiteral)operand;
                                RexNode reduced = this.reduceCall(literal, SqlKind.EQUALS, (Number)((Pair)maxMinStats.get((int)j)).left, (Number)((Pair)maxMinStats.get((int)j)).right);
                                if (reduced != null) {
                                    if (reduced.isAlwaysFalse()) {
                                        allTrue = false;
                                        addOperand = false;
                                        break;
                                    }
                                } else {
                                    allTrue = false;
                                }
                            } else {
                                allTrue = false;
                            }
                            ++j;
                        }
                        if (allTrue) {
                            return this.rexBuilder.makeLiteral(true);
                        }
                        if (!addOperand) continue;
                        newOperands.add(constStruct);
                    }
                    if (newOperands.size() == 1) {
                        return this.rexBuilder.makeLiteral(false);
                    }
                    return this.rexBuilder.makeCall((SqlOperator)HiveIn.INSTANCE, (List)newOperands);
                }
                return call;
            }
            if (call.getOperator().getKind() == SqlKind.IS_NULL || call.getOperator().getKind() == SqlKind.IS_NOT_NULL) {
                SqlKind kind = call.getOperator().getKind();
                if (call.operands.get(0) instanceof RexInputRef) {
                    RexInputRef ref = (RexInputRef)call.operands.get(0);
                    ColStatistics stat = this.extractColStats(ref);
                    Long rowCount = this.extractRowCount(ref);
                    if (stat != null && rowCount != null && (stat.getNumNulls() == 0L || stat.getNumNulls() == rowCount.longValue())) {
                        boolean allNulls;
                        boolean bl = allNulls = stat.getNumNulls() == rowCount.longValue();
                        if (kind == SqlKind.IS_NULL) {
                            return this.rexBuilder.makeLiteral(allNulls);
                        }
                        return this.rexBuilder.makeLiteral(!allNulls);
                    }
                }
            }
            if ((node = super.visitCall(call)) != call) {
                node = RexUtil.simplify((RexBuilder)this.rexBuilder, (RexNode)node);
            }
            return node;
        }

        private Pair<Number, Number> extractMaxMin(RexInputRef ref) {
            ColStatistics cs = this.extractColStats(ref);
            Number max = null;
            Number min = null;
            if (cs != null && cs.getRange() != null) {
                max = cs.getRange().maxValue;
                min = cs.getRange().minValue;
            }
            return Pair.of(max, min);
        }

        private ColStatistics extractColStats(RexInputRef ref) {
            ColStatistics colStats;
            RelOptHiveTable table;
            RelColumnOrigin columnOrigin = this.metadataProvider.getColumnOrigin((RelNode)this.filterOp, ref.getIndex());
            if (columnOrigin != null && (table = (RelOptHiveTable)columnOrigin.getOriginTable()) != null && (colStats = table.getColStat(Lists.newArrayList(columnOrigin.getOriginColumnOrdinal())).get(0)) != null && StatsSetupConst.areColumnStatsUptoDate(table.getHiveTableMD().getParameters(), colStats.getColumnName())) {
                return colStats;
            }
            return null;
        }

        private Long extractRowCount(RexInputRef ref) {
            RelOptHiveTable table;
            RelColumnOrigin columnOrigin = this.metadataProvider.getColumnOrigin((RelNode)this.filterOp, ref.getIndex());
            if (columnOrigin != null && (table = (RelOptHiveTable)columnOrigin.getOriginTable()) != null && StatsSetupConst.areBasicStatsUptoDate(table.getHiveTableMD().getParameters())) {
                return StatsUtils.getNumRows(table.getHiveTableMD());
            }
            return null;
        }

        private RexNode reduceCall(RexLiteral literal, SqlKind kind, Number max, Number min) {
            if (max != null && min != null) {
                BigDecimal maxVal = new BigDecimal(max.floatValue());
                BigDecimal minVal = new BigDecimal(min.floatValue());
                RexLiteral maxLiteral = this.rexBuilder.makeExactLiteral(maxVal, literal.getType());
                RexLiteral minLiteral = this.rexBuilder.makeExactLiteral(minVal, literal.getType());
                if (kind == SqlKind.EQUALS && (minLiteral.getValue().compareTo(literal.getValue()) > 0 || maxLiteral.getValue().compareTo(literal.getValue()) < 0)) {
                    return this.rexBuilder.makeLiteral(false);
                }
                if (kind == SqlKind.GREATER_THAN) {
                    if (minLiteral.getValue().compareTo(literal.getValue()) > 0) {
                        return this.rexBuilder.makeLiteral(true);
                    }
                    if (maxLiteral.getValue().compareTo(literal.getValue()) <= 0) {
                        return this.rexBuilder.makeLiteral(false);
                    }
                } else if (kind == SqlKind.GREATER_THAN_OR_EQUAL) {
                    if (minLiteral.getValue().compareTo(literal.getValue()) >= 0) {
                        return this.rexBuilder.makeLiteral(true);
                    }
                    if (maxLiteral.getValue().compareTo(literal.getValue()) < 0) {
                        return this.rexBuilder.makeLiteral(false);
                    }
                } else if (kind == SqlKind.LESS_THAN) {
                    if (minLiteral.getValue().compareTo(literal.getValue()) >= 0) {
                        return this.rexBuilder.makeLiteral(false);
                    }
                    if (maxLiteral.getValue().compareTo(literal.getValue()) < 0) {
                        return this.rexBuilder.makeLiteral(true);
                    }
                } else if (kind == SqlKind.LESS_THAN_OR_EQUAL) {
                    if (minLiteral.getValue().compareTo(literal.getValue()) > 0) {
                        return this.rexBuilder.makeLiteral(false);
                    }
                    if (maxLiteral.getValue().compareTo(literal.getValue()) <= 0) {
                        return this.rexBuilder.makeLiteral(true);
                    }
                }
            }
            return null;
        }
    }
}

