/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import java.util.Arrays;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.NullUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class IntervalDayTimeScalarNotEqualIntervalDayTimeColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private final HiveIntervalDayTime value;
    private final int colNum;

    public IntervalDayTimeScalarNotEqualIntervalDayTimeColumn(HiveIntervalDayTime value, int colNum, int outputColumnNum) {
        super(outputColumnNum);
        this.value = value;
        this.colNum = colNum;
    }

    public IntervalDayTimeScalarNotEqualIntervalDayTimeColumn() {
        this.value = null;
        this.colNum = -1;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        int n = batch.size;
        if (n == 0) {
            return;
        }
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        IntervalDayTimeColumnVector inputColVector2 = (IntervalDayTimeColumnVector)batch.cols[this.colNum];
        LongColumnVector outputColVector = (LongColumnVector)batch.cols[this.outputColumnNum];
        int[] sel = batch.selected;
        boolean[] inputIsNull = inputColVector2.isNull;
        boolean[] outputIsNull = outputColVector.isNull;
        long[] outputVector = outputColVector.vector;
        outputColVector.isRepeating = false;
        if (inputColVector2.isRepeating) {
            if (inputColVector2.noNulls || !inputIsNull[0]) {
                outputIsNull[0] = false;
                outputVector[0] = inputColVector2.compareTo(this.value, 0) != 0 ? 1L : 0L;
            } else {
                outputIsNull[0] = true;
                outputColVector.noNulls = false;
            }
            outputColVector.isRepeating = true;
            NullUtil.setNullOutputEntriesColScalar(outputColVector, batch.selectedInUse, sel, n);
            return;
        }
        if (inputColVector2.noNulls) {
            if (batch.selectedInUse) {
                if (!outputColVector.noNulls) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputIsNull[i] = false;
                        outputVector[i] = inputColVector2.compareTo(this.value, i) != 0 ? 1L : 0L;
                    }
                } else {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputVector[i] = inputColVector2.compareTo(this.value, i) != 0 ? 1L : 0L;
                    }
                }
            } else {
                if (!outputColVector.noNulls) {
                    Arrays.fill(outputIsNull, false);
                    outputColVector.noNulls = true;
                }
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = inputColVector2.compareTo(this.value, i) != 0 ? 1L : 0L;
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (!inputIsNull[i]) {
                    outputIsNull[i] = false;
                    outputVector[i] = inputColVector2.compareTo(this.value, i) != 0 ? 1L : 0L;
                    continue;
                }
                outputIsNull[i] = true;
                outputColVector.noNulls = false;
            }
        } else {
            System.arraycopy(inputIsNull, 0, outputIsNull, 0, n);
            for (int i = 0; i != n; ++i) {
                if (!inputIsNull[i]) {
                    outputIsNull[i] = false;
                    outputVector[i] = inputColVector2.compareTo(this.value, i) != 0 ? 1L : 0L;
                    continue;
                }
                outputIsNull[i] = true;
                outputColVector.noNulls = false;
            }
        }
    }

    @Override
    public String vectorExpressionParameters() {
        return "val " + this.value.toString() + ", " + this.getColumnParamString(1, this.colNum);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("interval_day_time"), VectorExpressionDescriptor.ArgumentType.getType("interval_day_time")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.SCALAR, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

