/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import com.facebook.presto.hive.$internal.com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Calendar;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hive.common.util.DateUtils;

public abstract class VectorUDFTimestampFieldTimestamp
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    protected final int colNum;
    protected final int field;
    protected final transient Calendar calendar = Calendar.getInstance();

    public VectorUDFTimestampFieldTimestamp(int field, int colNum, int outputColumnNum) {
        super(outputColumnNum);
        this.colNum = colNum;
        this.field = field;
    }

    public VectorUDFTimestampFieldTimestamp() {
        this.colNum = -1;
        this.field = -1;
    }

    public void initCalendar() {
    }

    @Override
    public void transientInit() throws HiveException {
        super.transientInit();
        this.initCalendar();
    }

    protected long getTimestampField(TimestampColumnVector timestampColVector, int elementNum) {
        this.calendar.setTime(timestampColVector.asScratchTimestamp(elementNum));
        return this.calendar.get(this.field);
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        boolean selectedInUse;
        Preconditions.checkState(((PrimitiveTypeInfo)this.inputTypeInfos[0]).getPrimitiveCategory() == PrimitiveObjectInspector.PrimitiveCategory.TIMESTAMP);
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector outV = (LongColumnVector)batch.cols[this.outputColumnNum];
        ColumnVector inputColVec = batch.cols[this.colNum];
        int n = inputColVec.isRepeating ? 1 : batch.size;
        int[] sel = batch.selected;
        boolean bl = selectedInUse = !inputColVec.isRepeating && batch.selectedInUse;
        if (batch.size == 0) {
            return;
        }
        outV.isRepeating = false;
        TimestampColumnVector timestampColVector = (TimestampColumnVector)inputColVec;
        if (inputColVec.isRepeating) {
            if (inputColVec.noNulls || !inputColVec.isNull[0]) {
                outV.isNull[0] = false;
                outV.vector[0] = this.getTimestampField(timestampColVector, 0);
            } else {
                outV.isNull[0] = true;
                outV.noNulls = false;
            }
            outV.isRepeating = true;
            return;
        }
        if (inputColVec.noNulls) {
            if (selectedInUse) {
                for (int j = 0; j < n; ++j) {
                    int i = sel[j];
                    outV.isNull[i] = false;
                    outV.vector[i] = this.getTimestampField(timestampColVector, i);
                }
            } else {
                Arrays.fill(outV.isNull, 0, n, false);
                for (int i = 0; i < n; ++i) {
                    outV.vector[i] = this.getTimestampField(timestampColVector, i);
                }
            }
        } else {
            outV.noNulls = false;
            if (selectedInUse) {
                for (int j = 0; j < n; ++j) {
                    int i = sel[j];
                    outV.isNull[i] = inputColVec.isNull[i];
                    if (inputColVec.isNull[i]) continue;
                    outV.vector[i] = this.getTimestampField(timestampColVector, i);
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    outV.isNull[i] = inputColVec.isNull[i];
                    if (inputColVec.isNull[i]) continue;
                    outV.vector[i] = this.getTimestampField(timestampColVector, i);
                }
            }
        }
    }

    @Override
    public String vectorExpressionParameters() {
        if (this.field == -1) {
            return this.getColumnParamString(0, this.colNum);
        }
        return this.getColumnParamString(0, this.colNum) + ", field " + DateUtils.getFieldName(this.field);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(1).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.TIMESTAMP).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN);
        return b.build();
    }
}

