/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class StringScalarConcatStringGroupCol
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private final int colNum;
    private final byte[] value;

    public StringScalarConcatStringGroupCol(byte[] value, int colNum, int outputColumnNum) {
        super(outputColumnNum);
        this.colNum = colNum;
        this.value = value;
    }

    public StringScalarConcatStringGroupCol() {
        this.colNum = -1;
        this.value = null;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        BytesColumnVector inputColVector = (BytesColumnVector)batch.cols[this.colNum];
        BytesColumnVector outputColVector = (BytesColumnVector)batch.cols[this.outputColumnNum];
        int[] sel = batch.selected;
        int n = batch.size;
        byte[][] vector = inputColVector.vector;
        int[] start = inputColVector.start;
        int[] length = inputColVector.length;
        boolean[] inputIsNull = inputColVector.isNull;
        boolean[] outputIsNull = outputColVector.isNull;
        if (n == 0) {
            return;
        }
        outputColVector.initBuffer();
        outputColVector.isRepeating = false;
        if (inputColVector.isRepeating) {
            if (inputColVector.noNulls || !inputIsNull[0]) {
                outputIsNull[0] = false;
                outputColVector.setConcat(0, this.value, 0, this.value.length, vector[0], start[0], length[0]);
            } else {
                outputIsNull[0] = true;
                outputColVector.noNulls = false;
            }
            outputColVector.isRepeating = true;
            return;
        }
        if (inputColVector.noNulls) {
            if (batch.selectedInUse) {
                if (!outputColVector.noNulls) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputIsNull[i] = false;
                        outputColVector.setConcat(i, this.value, 0, this.value.length, vector[i], start[i], length[i]);
                    }
                } else {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputColVector.setConcat(i, this.value, 0, this.value.length, vector[i], start[i], length[i]);
                    }
                }
            } else {
                if (!outputColVector.noNulls) {
                    Arrays.fill(outputIsNull, false);
                    outputColVector.noNulls = true;
                }
                for (int i = 0; i != n; ++i) {
                    outputColVector.setConcat(i, this.value, 0, this.value.length, vector[i], start[i], length[i]);
                }
            }
        } else {
            outputColVector.noNulls = false;
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (!inputColVector.isNull[i]) {
                        outputColVector.setConcat(i, this.value, 0, this.value.length, vector[i], start[i], length[i]);
                    }
                    outputColVector.isNull[i] = inputColVector.isNull[i];
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    if (!inputColVector.isNull[i]) {
                        outputColVector.setConcat(i, this.value, 0, this.value.length, vector[i], start[i], length[i]);
                    }
                    outputColVector.isNull[i] = inputColVector.isNull[i];
                }
            }
        }
    }

    @Override
    public String vectorExpressionParameters() {
        return "val " + StringScalarConcatStringGroupCol.displayUtf8Bytes(this.value) + ", " + this.getColumnParamString(1, this.colNum);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.STRING, VectorExpressionDescriptor.ArgumentType.STRING_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.SCALAR, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

