/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.columnstats.aggr;

import com.facebook.presto.hive.$internal.org.slf4j.Logger;
import com.facebook.presto.hive.$internal.org.slf4j.LoggerFactory;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.common.ndv.NumDistinctValueEstimator;
import org.apache.hadoop.hive.common.ndv.NumDistinctValueEstimatorFactory;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.columnstats.aggr.ColumnStatsAggregator;
import org.apache.hadoop.hive.metastore.columnstats.aggr.ColumnStatsAggregatorFactory;
import org.apache.hadoop.hive.metastore.columnstats.aggr.IExtrapolatePartStatus;
import org.apache.hadoop.hive.metastore.columnstats.cache.LongColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;

public class LongColumnStatsAggregator
extends ColumnStatsAggregator
implements IExtrapolatePartStatus {
    private static final Logger LOG = LoggerFactory.getLogger(LongColumnStatsAggregator.class);

    @Override
    public ColumnStatisticsObj aggregate(List<MetaStoreUtils.ColStatsObjWithSourceInfo> colStatsWithSourceInfo, List<String> partNames, boolean areAllPartsFound) throws MetaException {
        ColumnStatisticsObj statsObj = null;
        String colType = null;
        String colName = null;
        boolean doAllPartitionContainStats = partNames.size() == colStatsWithSourceInfo.size();
        NumDistinctValueEstimator ndvEstimator = null;
        for (MetaStoreUtils.ColStatsObjWithSourceInfo csp : colStatsWithSourceInfo) {
            LongColumnStatsDataInspector longColumnStatsData;
            ColumnStatisticsObj cso = csp.getColStatsObj();
            if (statsObj == null) {
                colName = cso.getColName();
                colType = cso.getColType();
                statsObj = ColumnStatsAggregatorFactory.newColumnStaticsObj(colName, colType, (ColumnStatisticsData._Fields)cso.getStatsData().getSetField());
                LOG.trace("doAllPartitionContainStats for column: {} is: {}", (Object)colName, (Object)doAllPartitionContainStats);
            }
            if ((longColumnStatsData = (LongColumnStatsDataInspector)cso.getStatsData().getLongStats()).getNdvEstimator() == null) {
                ndvEstimator = null;
                break;
            }
            NumDistinctValueEstimator estimator = longColumnStatsData.getNdvEstimator();
            if (ndvEstimator == null) {
                ndvEstimator = estimator;
                continue;
            }
            if (ndvEstimator.canMerge(estimator)) continue;
            ndvEstimator = null;
            break;
        }
        if (ndvEstimator != null) {
            ndvEstimator = NumDistinctValueEstimatorFactory.getEmptyNumDistinctValueEstimator(ndvEstimator);
        }
        LOG.debug("all of the bit vectors can merge for " + colName + " is " + (ndvEstimator != null));
        ColumnStatisticsData columnStatisticsData = new ColumnStatisticsData();
        if (doAllPartitionContainStats || colStatsWithSourceInfo.size() < 2) {
            LongColumnStatsData aggregateData = null;
            long lowerBound = 0L;
            long higherBound = 0L;
            double densityAvgSum = 0.0;
            for (MetaStoreUtils.ColStatsObjWithSourceInfo csp : colStatsWithSourceInfo) {
                ColumnStatisticsObj cso = csp.getColStatsObj();
                LongColumnStatsDataInspector newData = (LongColumnStatsDataInspector)cso.getStatsData().getLongStats();
                lowerBound = Math.max(lowerBound, newData.getNumDVs());
                higherBound += newData.getNumDVs();
                densityAvgSum += (double)((newData.getHighValue() - newData.getLowValue()) / newData.getNumDVs());
                if (ndvEstimator != null) {
                    ndvEstimator.mergeEstimators(newData.getNdvEstimator());
                }
                if (aggregateData == null) {
                    aggregateData = newData.deepCopy();
                    continue;
                }
                aggregateData.setLowValue(Math.min(aggregateData.getLowValue(), newData.getLowValue()));
                aggregateData.setHighValue(Math.max(aggregateData.getHighValue(), newData.getHighValue()));
                aggregateData.setNumNulls(aggregateData.getNumNulls() + newData.getNumNulls());
                aggregateData.setNumDVs(Math.max(aggregateData.getNumDVs(), newData.getNumDVs()));
            }
            if (ndvEstimator != null) {
                aggregateData.setNumDVs(ndvEstimator.estimateNumDistinctValues());
            } else {
                long estimation;
                if (this.useDensityFunctionForNDVEstimation) {
                    double densityAvg = densityAvgSum / (double)partNames.size();
                    estimation = (long)((double)(aggregateData.getHighValue() - aggregateData.getLowValue()) / densityAvg);
                    if (estimation < lowerBound) {
                        estimation = lowerBound;
                    } else if (estimation > higherBound) {
                        estimation = higherBound;
                    }
                } else {
                    estimation = (long)((double)lowerBound + (double)(higherBound - lowerBound) * this.ndvTuner);
                }
                aggregateData.setNumDVs(estimation);
            }
            columnStatisticsData.setLongStats(aggregateData);
        } else {
            LOG.debug("start extrapolation for " + colName);
            HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
            for (int index = 0; index < partNames.size(); ++index) {
                indexMap.put(partNames.get(index), index);
            }
            HashMap<String, Double> adjustedIndexMap = new HashMap<String, Double>();
            HashMap<String, ColumnStatisticsData> adjustedStatsMap = new HashMap<String, ColumnStatisticsData>();
            double densityAvgSum = 0.0;
            if (ndvEstimator == null) {
                for (MetaStoreUtils.ColStatsObjWithSourceInfo csp : colStatsWithSourceInfo) {
                    ColumnStatisticsObj cso = csp.getColStatsObj();
                    String partName = csp.getPartName();
                    LongColumnStatsData newData = cso.getStatsData().getLongStats();
                    if (this.useDensityFunctionForNDVEstimation) {
                        densityAvgSum += (double)((newData.getHighValue() - newData.getLowValue()) / newData.getNumDVs());
                    }
                    adjustedIndexMap.put(partName, (double)((Integer)indexMap.get(partName)));
                    adjustedStatsMap.put(partName, cso.getStatsData());
                }
            } else {
                StringBuilder pseudoPartName = new StringBuilder();
                double pseudoIndexSum = 0.0;
                int length = 0;
                int curIndex = -1;
                LongColumnStatsData aggregateData = null;
                for (MetaStoreUtils.ColStatsObjWithSourceInfo csp : colStatsWithSourceInfo) {
                    ColumnStatisticsObj cso = csp.getColStatsObj();
                    String partName = csp.getPartName();
                    LongColumnStatsDataInspector newData = (LongColumnStatsDataInspector)cso.getStatsData().getLongStats();
                    if ((Integer)indexMap.get(partName) != curIndex) {
                        if (length > 0) {
                            adjustedIndexMap.put(pseudoPartName.toString(), pseudoIndexSum / (double)length);
                            aggregateData.setNumDVs(ndvEstimator.estimateNumDistinctValues());
                            ColumnStatisticsData csd = new ColumnStatisticsData();
                            csd.setLongStats(aggregateData);
                            adjustedStatsMap.put(pseudoPartName.toString(), csd);
                            if (this.useDensityFunctionForNDVEstimation) {
                                densityAvgSum += (double)((aggregateData.getHighValue() - aggregateData.getLowValue()) / aggregateData.getNumDVs());
                            }
                            pseudoPartName = new StringBuilder();
                            pseudoIndexSum = 0.0;
                            length = 0;
                            ndvEstimator = NumDistinctValueEstimatorFactory.getEmptyNumDistinctValueEstimator(ndvEstimator);
                        }
                        aggregateData = null;
                    }
                    curIndex = (Integer)indexMap.get(partName);
                    pseudoPartName.append(partName);
                    pseudoIndexSum += (double)curIndex;
                    ++length;
                    ++curIndex;
                    if (aggregateData == null) {
                        aggregateData = newData.deepCopy();
                    } else {
                        aggregateData.setLowValue(Math.min(aggregateData.getLowValue(), newData.getLowValue()));
                        aggregateData.setHighValue(Math.max(aggregateData.getHighValue(), newData.getHighValue()));
                        aggregateData.setNumNulls(aggregateData.getNumNulls() + newData.getNumNulls());
                    }
                    ndvEstimator.mergeEstimators(newData.getNdvEstimator());
                }
                if (length > 0) {
                    adjustedIndexMap.put(pseudoPartName.toString(), pseudoIndexSum / (double)length);
                    aggregateData.setNumDVs(ndvEstimator.estimateNumDistinctValues());
                    ColumnStatisticsData csd = new ColumnStatisticsData();
                    csd.setLongStats(aggregateData);
                    adjustedStatsMap.put(pseudoPartName.toString(), csd);
                    if (this.useDensityFunctionForNDVEstimation) {
                        densityAvgSum += (double)((aggregateData.getHighValue() - aggregateData.getLowValue()) / aggregateData.getNumDVs());
                    }
                }
            }
            this.extrapolate(columnStatisticsData, partNames.size(), colStatsWithSourceInfo.size(), adjustedIndexMap, adjustedStatsMap, densityAvgSum / (double)adjustedStatsMap.size());
        }
        LOG.debug("Ndv estimatation for {} is {} # of partitions requested: {} # of partitions found: {}", colName, columnStatisticsData.getLongStats().getNumDVs(), partNames.size(), colStatsWithSourceInfo.size());
        statsObj.setStatsData(columnStatisticsData);
        return statsObj;
    }

    @Override
    public void extrapolate(ColumnStatisticsData extrapolateData, int numParts, int numPartsWithStats, Map<String, Double> adjustedIndexMap, Map<String, ColumnStatisticsData> adjustedStatsMap, double densityAvg) {
        int rightBorderInd = numParts;
        LongColumnStatsDataInspector extrapolateLongData = new LongColumnStatsDataInspector();
        HashMap<String, LongColumnStatsData> extractedAdjustedStatsMap = new HashMap<String, LongColumnStatsData>();
        for (Map.Entry<String, ColumnStatisticsData> entry : adjustedStatsMap.entrySet()) {
            extractedAdjustedStatsMap.put(entry.getKey(), entry.getValue().getLongStats());
        }
        LinkedList list = new LinkedList(extractedAdjustedStatsMap.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, LongColumnStatsData>>(){

            @Override
            public int compare(Map.Entry<String, LongColumnStatsData> o1, Map.Entry<String, LongColumnStatsData> o2) {
                return Long.compare(o1.getValue().getLowValue(), o2.getValue().getLowValue());
            }
        });
        double minInd = adjustedIndexMap.get(((Map.Entry)list.get(0)).getKey());
        double maxInd = adjustedIndexMap.get(((Map.Entry)list.get(list.size() - 1)).getKey());
        long lowValue = 0L;
        long min = ((LongColumnStatsData)((Map.Entry)list.get(0)).getValue()).getLowValue();
        long max = ((LongColumnStatsData)((Map.Entry)list.get(list.size() - 1)).getValue()).getLowValue();
        lowValue = minInd == maxInd ? min : (minInd < maxInd ? (long)((double)max - (double)(max - min) * maxInd / (maxInd - minInd)) : (long)((double)max - (double)(max - min) * ((double)rightBorderInd - maxInd) / (minInd - maxInd)));
        Collections.sort(list, new Comparator<Map.Entry<String, LongColumnStatsData>>(){

            @Override
            public int compare(Map.Entry<String, LongColumnStatsData> o1, Map.Entry<String, LongColumnStatsData> o2) {
                return Long.compare(o1.getValue().getHighValue(), o2.getValue().getHighValue());
            }
        });
        minInd = adjustedIndexMap.get(((Map.Entry)list.get(0)).getKey());
        maxInd = adjustedIndexMap.get(((Map.Entry)list.get(list.size() - 1)).getKey());
        long highValue = 0L;
        min = ((LongColumnStatsData)((Map.Entry)list.get(0)).getValue()).getHighValue();
        max = ((LongColumnStatsData)((Map.Entry)list.get(list.size() - 1)).getValue()).getHighValue();
        highValue = minInd == maxInd ? min : (minInd < maxInd ? (long)((double)min + (double)(max - min) * ((double)rightBorderInd - minInd) / (maxInd - minInd)) : (long)((double)min + (double)(max - min) * minInd / (minInd - maxInd)));
        long numNulls = 0L;
        for (Map.Entry entry : extractedAdjustedStatsMap.entrySet()) {
            numNulls += ((LongColumnStatsData)entry.getValue()).getNumNulls();
        }
        numNulls = numNulls * (long)numParts / (long)numPartsWithStats;
        long ndv = 0L;
        Collections.sort(list, new Comparator<Map.Entry<String, LongColumnStatsData>>(){

            @Override
            public int compare(Map.Entry<String, LongColumnStatsData> o1, Map.Entry<String, LongColumnStatsData> o2) {
                return Long.compare(o1.getValue().getNumDVs(), o2.getValue().getNumDVs());
            }
        });
        long lowerBound = ((LongColumnStatsData)((Map.Entry)list.get(list.size() - 1)).getValue()).getNumDVs();
        long higherBound = 0L;
        for (Map.Entry entry : list) {
            higherBound += ((LongColumnStatsData)entry.getValue()).getNumDVs();
        }
        if (this.useDensityFunctionForNDVEstimation && densityAvg != 0.0) {
            ndv = (long)((double)(highValue - lowValue) / densityAvg);
            if (ndv < lowerBound) {
                ndv = lowerBound;
            } else if (ndv > higherBound) {
                ndv = higherBound;
            }
        } else {
            minInd = adjustedIndexMap.get(((Map.Entry)list.get(0)).getKey());
            maxInd = adjustedIndexMap.get(((Map.Entry)list.get(list.size() - 1)).getKey());
            min = ((LongColumnStatsData)((Map.Entry)list.get(0)).getValue()).getNumDVs();
            max = ((LongColumnStatsData)((Map.Entry)list.get(list.size() - 1)).getValue()).getNumDVs();
            ndv = minInd == maxInd ? min : (minInd < maxInd ? (long)((double)min + (double)(max - min) * ((double)rightBorderInd - minInd) / (maxInd - minInd)) : (long)((double)min + (double)(max - min) * minInd / (minInd - maxInd)));
        }
        extrapolateLongData.setLowValue(lowValue);
        extrapolateLongData.setHighValue(highValue);
        extrapolateLongData.setNumNulls(numNulls);
        extrapolateLongData.setNumDVs(ndv);
        extrapolateData.setLongStats(extrapolateLongData);
    }
}

