/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.jodd.util;

import com.facebook.presto.hive.$internal.jodd.JoddCore;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;

public class URLDecoder {
    public static String decode(String url) {
        return URLDecoder.decode(url, JoddCore.encoding, false);
    }

    public static String decode(String source, String encoding) {
        return URLDecoder.decode(source, encoding, false);
    }

    public static String decodeQuery(String source) {
        return URLDecoder.decode(source, JoddCore.encoding, true);
    }

    public static String decodeQuery(String source, String encoding) {
        return URLDecoder.decode(source, encoding, true);
    }

    private static String decode(String source, String encoding, boolean decodePlus) {
        int length = source.length();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(length);
        boolean changed = false;
        block6: for (int i = 0; i < length; ++i) {
            int ch = source.charAt(i);
            switch (ch) {
                case 37: {
                    if (i + 2 < length) {
                        char hex1 = source.charAt(i + 1);
                        char hex2 = source.charAt(i + 2);
                        int u = Character.digit(hex1, 16);
                        int l = Character.digit(hex2, 16);
                        if (u == -1 || l == -1) {
                            throw new IllegalArgumentException("Invalid sequence: " + source.substring(i));
                        }
                        bos.write((char)((u << 4) + l));
                        i += 2;
                        changed = true;
                        continue block6;
                    }
                    throw new IllegalArgumentException("Invalid sequence: " + source.substring(i));
                }
                case 43: {
                    if (decodePlus) {
                        ch = 32;
                        changed = true;
                    }
                }
                default: {
                    bos.write(ch);
                }
            }
        }
        try {
            return changed ? new String(bos.toByteArray(), encoding) : source;
        }
        catch (UnsupportedEncodingException ignore) {
            return null;
        }
    }
}

