/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.jodd.util;

import com.facebook.presto.hive.$internal.jodd.util.StringUtil;
import java.util.Map;

public class StringTemplateParser {
    public static final String DEFAULT_MACRO_START = "${";
    public static final String DEFAULT_MACRO_END = "}";
    protected boolean replaceMissingKey = true;
    protected String missingKeyReplacement;
    protected boolean resolveEscapes = true;
    protected String macroStart = "${";
    protected String macroEnd = "}";
    protected char escapeChar = (char)92;
    protected boolean parseValues;

    public boolean isReplaceMissingKey() {
        return this.replaceMissingKey;
    }

    public void setReplaceMissingKey(boolean replaceMissingKey) {
        this.replaceMissingKey = replaceMissingKey;
    }

    public String getMissingKeyReplacement() {
        return this.missingKeyReplacement;
    }

    public void setMissingKeyReplacement(String missingKeyReplacement) {
        this.missingKeyReplacement = missingKeyReplacement;
    }

    public boolean isResolveEscapes() {
        return this.resolveEscapes;
    }

    public void setResolveEscapes(boolean resolveEscapes) {
        this.resolveEscapes = resolveEscapes;
    }

    public String getMacroStart() {
        return this.macroStart;
    }

    public void setMacroStart(String macroStart) {
        this.macroStart = macroStart;
    }

    public String getMacroEnd() {
        return this.macroEnd;
    }

    public void setMacroEnd(String macroEnd) {
        this.macroEnd = macroEnd;
    }

    public char getEscapeChar() {
        return this.escapeChar;
    }

    public void setEscapeChar(char escapeChar) {
        this.escapeChar = escapeChar;
    }

    public boolean isParseValues() {
        return this.parseValues;
    }

    public void setParseValues(boolean parseValues) {
        this.parseValues = parseValues;
    }

    public String parse(String template, MacroResolver macroResolver) {
        StringBuilder result = new StringBuilder(template.length());
        int i = 0;
        int len = template.length();
        int startLen = this.macroStart.length();
        int endLen = this.macroEnd.length();
        while (i < len) {
            String value;
            int n;
            int ndx = template.indexOf(this.macroStart, i);
            if (ndx == -1) {
                result.append(i == 0 ? template : template.substring(i));
                break;
            }
            boolean escape = false;
            int count = 0;
            for (int j = ndx - 1; j >= 0 && template.charAt(j) == this.escapeChar; --j) {
                boolean bl = escape = !escape;
                if (!escape) continue;
                ++count;
            }
            if (this.resolveEscapes) {
                result.append(template.substring(i, ndx - count));
            } else {
                result.append(template.substring(i, ndx));
            }
            if (escape) {
                result.append(this.macroStart);
                i = ndx + startLen;
                continue;
            }
            int ndx2 = template.indexOf(this.macroEnd, ndx += startLen);
            if (ndx2 == -1) {
                throw new IllegalArgumentException("Invalid template, unclosed macro at: " + (ndx - startLen));
            }
            int ndx1 = ndx;
            while (ndx1 < ndx2 && (n = StringUtil.indexOf(template, this.macroStart, ndx1, ndx2)) != -1) {
                ndx1 = n + startLen;
            }
            String name = template.substring(ndx1, ndx2);
            if (this.missingKeyReplacement != null || !this.replaceMissingKey) {
                try {
                    value = macroResolver.resolve(name);
                }
                catch (Exception ignore) {
                    value = null;
                }
                if (value == null) {
                    value = this.replaceMissingKey ? this.missingKeyReplacement : template.substring(ndx1 - startLen, ndx2 + 1);
                }
            } else {
                value = macroResolver.resolve(name);
                if (value == null) {
                    value = "";
                }
            }
            if (ndx == ndx1) {
                String stringValue = value.toString();
                if (this.parseValues && stringValue.contains(this.macroStart)) {
                    stringValue = this.parse(stringValue, macroResolver);
                }
                result.append(stringValue);
                i = ndx2 + endLen;
                continue;
            }
            template = template.substring(0, ndx1 - startLen) + value.toString() + template.substring(ndx2 + endLen);
            len = template.length();
            i = ndx - startLen;
        }
        return result.toString();
    }

    public static MacroResolver createMapMacroResolver(final Map map) {
        return new MacroResolver(){

            public String resolve(String macroName) {
                Object value = map.get(macroName);
                if (value == null) {
                    return null;
                }
                return value.toString();
            }
        };
    }

    public static interface MacroResolver {
        public String resolve(String var1);
    }
}

