/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.jodd.format;

import java.math.BigInteger;

public class PrintfFormat {
    protected int width;
    protected int precision;
    protected StringBuilder pre;
    protected StringBuilder post;
    protected boolean leadingZeroes;
    protected boolean showPlus;
    protected boolean alternate;
    protected boolean showSpace;
    protected boolean leftAlign;
    protected boolean groupDigits;
    protected char fmt;
    protected boolean countSignInLen;
    private static final BigInteger bgInt = new BigInteger("9223372036854775808");

    public PrintfFormat(String s) {
        this.init(s, 0);
    }

    protected PrintfFormat() {
    }

    protected PrintfFormat reinit(String s) {
        if (this.pre == null) {
            this.init(s, 0);
        } else {
            this.init(s, this.pre.length());
        }
        return this;
    }

    protected void init(String s, int i) {
        int parseState;
        char c;
        this.width = 0;
        this.precision = -1;
        this.pre = i == 0 ? new StringBuilder() : new StringBuilder(s.substring(0, i));
        this.post = new StringBuilder();
        this.leadingZeroes = false;
        this.showPlus = false;
        this.alternate = false;
        this.showSpace = false;
        this.leftAlign = false;
        this.countSignInLen = true;
        this.fmt = (char)32;
        int length = s.length();
        while (true) {
            if (i >= length) {
                throw new IllegalArgumentException("Format string requires '%'.");
            }
            c = s.charAt(i);
            if (c != '%') {
                this.pre.append(c);
                ++i;
                continue;
            }
            if (i >= length - 1) {
                throw new IllegalArgumentException("Format string can not end with '%'.");
            }
            if (s.charAt(i + 1) != '%') break;
            this.pre.append('%');
            i += 2;
        }
        ++i;
        block10: while (true) {
            if (i >= length) {
                parseState = 5;
                break;
            }
            c = s.charAt(i);
            switch (c) {
                case ' ': {
                    this.showSpace = true;
                    break;
                }
                case '-': {
                    this.leftAlign = true;
                    break;
                }
                case '+': {
                    this.showPlus = true;
                    break;
                }
                case '0': {
                    this.leadingZeroes = true;
                    break;
                }
                case '#': {
                    this.alternate = true;
                    break;
                }
                case '~': {
                    this.countSignInLen = false;
                    break;
                }
                case ',': {
                    this.groupDigits = true;
                    break;
                }
                default: {
                    parseState = 2;
                    break block10;
                }
            }
            ++i;
        }
        while (parseState == 2) {
            if (i >= length) {
                parseState = 5;
                break;
            }
            c = s.charAt(i);
            if (c >= '0' && c <= '9') {
                this.width = this.width * 10 + s.charAt(i) - 48;
                ++i;
                continue;
            }
            if (s.charAt(i) == '.') {
                parseState = 3;
                this.precision = 0;
                ++i;
                break;
            }
            parseState = 4;
            break;
        }
        while (parseState == 3) {
            if (i >= length) {
                parseState = 5;
                break;
            }
            c = s.charAt(i);
            if (c >= '0' && c <= '9') {
                this.precision = this.precision * 10 + s.charAt(i) - 48;
                ++i;
                continue;
            }
            parseState = 4;
            break;
        }
        if (parseState == 4 && i < length) {
            this.fmt = s.charAt(i);
            ++i;
        }
        if (i < length) {
            this.post.append(s.substring(i, length));
        }
    }

    protected String expFormat(double d) {
        StringBuilder f = new StringBuilder();
        int e = 0;
        double factor = 1.0;
        if (d != 0.0) {
            double dd;
            for (dd = d; dd > 10.0; dd /= 10.0) {
                ++e;
                factor /= 10.0;
            }
            while (dd < 1.0) {
                --e;
                factor *= 10.0;
                dd *= 10.0;
            }
        }
        if ((this.fmt == 'g' || this.fmt == 'G') && e >= -4 && e < this.precision) {
            return this.fixedFormat(d);
        }
        f.append(this.fixedFormat(d *= factor));
        if (this.fmt == 'e' || this.fmt == 'g') {
            f.append('e');
        } else {
            f.append('E');
        }
        StringBuilder p = new StringBuilder("000");
        if (e >= 0) {
            f.append('+');
            p.append(e);
        } else {
            f.append('-');
            p.append(-e);
        }
        char[] data = new char[3];
        p.getChars(p.length() - 3, p.length(), data, 0);
        return f.append(data).toString();
    }

    protected String fixedFormat(double d) {
        boolean removeTrailing;
        boolean bl = removeTrailing = (this.fmt == 'G' || this.fmt == 'g') && !this.alternate;
        if (d > 9.223372036854776E18) {
            return this.expFormat(d);
        }
        if (this.precision == 0) {
            return Long.toString(Math.round(d));
        }
        long whole = (long)d;
        double fr = d - (double)whole;
        if (fr >= 1.0 || fr < 0.0) {
            return this.expFormat(d);
        }
        double factor = 1.0;
        StringBuilder leadingZeroesStr = new StringBuilder();
        for (int i = 1; i <= this.precision && factor <= 9.223372036854776E18; factor *= 10.0, ++i) {
            leadingZeroesStr.append('0');
        }
        long l = Math.round(factor * fr);
        if ((double)l >= factor) {
            l = 0L;
            ++whole;
        }
        String z = leadingZeroesStr.toString() + l;
        z = '.' + z.substring(z.length() - this.precision, z.length());
        if (removeTrailing) {
            int t;
            for (t = z.length() - 1; t >= 0 && z.charAt(t) == '0'; --t) {
            }
            if (t >= 0 && z.charAt(t) == '.') {
                --t;
            }
            z = z.substring(0, t + 1);
        }
        return whole + z;
    }

    protected String pad(String value) {
        String spaces = PrintfFormat.repeat(' ', this.width - value.length());
        if (this.leftAlign) {
            return this.pre + value + spaces + this.post;
        }
        return this.pre + spaces + value + this.post;
    }

    protected static String repeat(char c, int n) {
        if (n <= 0) {
            return "";
        }
        char[] buffer = new char[n];
        for (int i = 0; i < n; ++i) {
            buffer[i] = c;
        }
        return new String(buffer);
    }

    private String getAltPrefixFor(char fmt, String currentPrefix) {
        switch (fmt) {
            case 'x': {
                return "0x";
            }
            case 'X': {
                return "0X";
            }
            case 'b': {
                return "0b";
            }
            case 'B': {
                return "0B";
            }
        }
        return currentPrefix;
    }

    protected String sign(int s, String r) {
        String p = "";
        if (s < 0) {
            p = "-";
        } else if (s > 0) {
            if (this.showPlus) {
                p = "+";
            } else if (this.showSpace) {
                p = " ";
            }
        } else if (this.alternate) {
            p = this.fmt == 'o' && r.length() > 0 && r.charAt(0) != '0' ? "0" : this.getAltPrefixFor(this.fmt, p);
        }
        int w = 0;
        if (this.leadingZeroes) {
            w = this.width;
        } else if ((this.fmt == 'u' || this.fmt == 'd' || this.fmt == 'i' || this.fmt == 'x' || this.fmt == 'X' || this.fmt == 'o') && this.precision > 0) {
            w = this.precision;
        }
        if (this.countSignInLen) {
            return p + PrintfFormat.repeat('0', w - p.length() - r.length()) + r;
        }
        return p + PrintfFormat.repeat('0', w - r.length()) + r;
    }

    protected String groupDigits(String value, int size, char separator) {
        int ndx;
        if (!this.groupDigits) {
            return value;
        }
        StringBuilder r = new StringBuilder(value.length() + 10);
        int len = value.length() - 1;
        int mod = len % size;
        for (ndx = 0; ndx < len; ++ndx) {
            r.append(value.charAt(ndx));
            if (mod == 0) {
                r.append(separator);
                mod = size;
            }
            --mod;
        }
        r.append(value.charAt(ndx));
        return r.toString();
    }

    public String form(char value) {
        switch (this.fmt) {
            case 'c': {
                return this.alternate ? "\\u" + Integer.toHexString(value & 0xFFFF) : this.pad(String.valueOf(value));
            }
            case 'C': {
                return this.alternate ? "\\u" + Integer.toHexString(value & 0xFFFF).toUpperCase() : this.pad(String.valueOf(value));
            }
            case 'L': 
            case 'X': 
            case 'b': 
            case 'd': 
            case 'i': 
            case 'l': 
            case 'o': 
            case 'u': 
            case 'x': {
                return this.form((short)value);
            }
        }
        throw this.newIllegalArgumentException("cCdiuoxXblL");
    }

    public String form(boolean value) {
        if (this.fmt == 'l') {
            return this.pad(value ? "true" : "false");
        }
        if (this.fmt == 'L') {
            return this.pad(value ? "TRUE" : "FALSE");
        }
        throw this.newIllegalArgumentException("lL");
    }

    public String form(double x) {
        String r;
        if (this.precision < 0) {
            this.precision = 6;
        }
        int s = 1;
        if (x < 0.0) {
            x = -x;
            s = -1;
        }
        if (this.fmt == 'f') {
            r = this.fixedFormat(x);
        } else if (this.fmt == 'e' || this.fmt == 'E' || this.fmt == 'g' || this.fmt == 'G') {
            r = this.expFormat(x);
        } else {
            throw this.newIllegalArgumentException("feEgG");
        }
        return this.pad(this.sign(s, r));
    }

    public String form(long x) {
        String r;
        int s = 0;
        switch (this.fmt) {
            case 'c': {
                return this.form((char)x);
            }
            case 'd': {
                if (x < 0L) {
                    r = Long.toString(x).substring(1);
                    s = -1;
                } else {
                    r = Long.toString(x);
                    s = 1;
                }
                r = this.groupDigits(r, 3, ',');
                break;
            }
            case 'i': {
                int xx = (int)x;
                if (xx < 0) {
                    r = Integer.toString(xx).substring(1);
                    s = -1;
                } else {
                    r = Integer.toString(xx);
                    s = 1;
                }
                r = this.groupDigits(r, 3, ',');
                break;
            }
            case 'u': {
                if (x < 0L) {
                    long xl = x & Long.MAX_VALUE;
                    r = Long.toString(xl);
                    BigInteger bi = new BigInteger(r);
                    r = bi.add(bgInt).toString();
                } else {
                    r = Long.toString(x);
                }
                r = this.groupDigits(r, 3, ',');
                s = 1;
                break;
            }
            case 'o': {
                r = Long.toOctalString(x);
                break;
            }
            case 'x': {
                r = Long.toHexString(x);
                r = this.groupDigits(r, 4, ' ');
                break;
            }
            case 'X': {
                r = Long.toHexString(x).toUpperCase();
                r = this.groupDigits(r, 4, ' ');
                break;
            }
            case 'B': 
            case 'b': {
                r = Long.toBinaryString(x);
                r = this.groupDigits(r, 8, ' ');
                break;
            }
            case 'l': {
                r = x == 0L ? "false" : "true";
                break;
            }
            case 'L': {
                r = x == 0L ? "FALSE" : "TRUE";
                break;
            }
            default: {
                throw new IllegalArgumentException("cdiuoxXbBlL");
            }
        }
        return this.pad(this.sign(s, r));
    }

    public String form(int x) {
        String r;
        int s = 0;
        switch (this.fmt) {
            case 'c': {
                return this.form((char)x);
            }
            case 'd': 
            case 'i': {
                if (x < 0) {
                    r = Integer.toString(x).substring(1);
                    s = -1;
                } else {
                    r = Integer.toString(x);
                    s = 1;
                }
                r = this.groupDigits(r, 3, ',');
                break;
            }
            case 'u': {
                long xl = (long)x & 0xFFFFFFFFL;
                r = Long.toString(xl);
                r = this.groupDigits(r, 3, ',');
                s = 1;
                break;
            }
            case 'o': {
                r = Integer.toOctalString(x);
                break;
            }
            case 'x': {
                r = Integer.toHexString(x);
                r = this.groupDigits(r, 4, ' ');
                break;
            }
            case 'X': {
                r = Integer.toHexString(x).toUpperCase();
                r = this.groupDigits(r, 4, ' ');
                break;
            }
            case 'B': 
            case 'b': {
                r = Integer.toBinaryString(x);
                r = this.groupDigits(r, 8, ' ');
                break;
            }
            case 'l': {
                r = x == 0 ? "false" : "true";
                break;
            }
            case 'L': {
                r = x == 0 ? "FALSE" : "TRUE";
                break;
            }
            default: {
                throw this.newIllegalArgumentException("cdiuoxXbBlL");
            }
        }
        return this.pad(this.sign(s, r));
    }

    public String form(byte b) {
        return this.formInt(b, 255);
    }

    public String form(short s) {
        return this.formInt(s, 65535);
    }

    private String formInt(int value, int unsignedMask) {
        String r;
        int s = 0;
        switch (this.fmt) {
            case 'c': {
                return this.form((char)value);
            }
            case 'd': 
            case 'i': {
                if (value < 0) {
                    r = Integer.toString(value).substring(1);
                    s = -1;
                } else {
                    r = Integer.toString(value);
                    s = 1;
                }
                r = this.groupDigits(r, 3, ',');
                break;
            }
            case 'u': {
                int xl = value & unsignedMask;
                r = Integer.toString(xl);
                r = this.groupDigits(r, 3, ',');
                s = 1;
                break;
            }
            case 'o': {
                r = Integer.toOctalString(value & unsignedMask);
                break;
            }
            case 'x': {
                r = Integer.toHexString(value & unsignedMask);
                r = this.groupDigits(r, 4, ' ');
                break;
            }
            case 'X': {
                r = Integer.toHexString(value & unsignedMask).toUpperCase();
                r = this.groupDigits(r, 4, ' ');
                break;
            }
            case 'B': 
            case 'b': {
                r = Integer.toBinaryString(value & unsignedMask);
                r = this.groupDigits(r, 8, ' ');
                break;
            }
            case 'l': {
                r = value == 0 ? "false" : "true";
                break;
            }
            case 'L': {
                r = value == 0 ? "FALSE" : "TRUE";
                break;
            }
            default: {
                throw this.newIllegalArgumentException("cdiuoxXblL");
            }
        }
        return this.pad(this.sign(s, r));
    }

    public String form(Object object) {
        switch (this.fmt) {
            case 's': {
                String s;
                String string = s = object == null ? "null" : object.toString();
                if (this.precision >= 0 && this.precision < s.length()) {
                    s = s.substring(0, this.precision);
                }
                return this.pad(s);
            }
            case 'p': {
                return Integer.toString(System.identityHashCode(object));
            }
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            if (object instanceof Integer) {
                return this.form(number.intValue());
            }
            if (object instanceof Long) {
                return this.form(number.longValue());
            }
            if (object instanceof Double) {
                return this.form(number.doubleValue());
            }
            if (object instanceof Float) {
                return this.form(number.floatValue());
            }
            if (object instanceof Byte) {
                return this.form(number.byteValue());
            }
            if (object instanceof Short) {
                return this.form(number.shortValue());
            }
            return this.form(number.intValue());
        }
        if (object instanceof Character) {
            return this.form(((Character)object).charValue());
        }
        throw this.newIllegalArgumentException("sp");
    }

    protected IllegalArgumentException newIllegalArgumentException(String allowedFormats) {
        return new IllegalArgumentException("Invalid format: '" + this.fmt + "' is not one of '" + allowedFormats + "'");
    }
}

