/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.jodd.datetime;

import com.facebook.presto.hive.$internal.jodd.datetime.JDateTime;
import com.facebook.presto.hive.$internal.jodd.datetime.TimeUtil;
import java.util.TimeZone;

public class TimeZoneUtil {
    public static int getRawOffsetDifference(TimeZone from, TimeZone to) {
        int offsetBefore = from.getRawOffset();
        int offsetAfter = to.getRawOffset();
        return offsetAfter - offsetBefore;
    }

    public static int getOffsetDifference(long now, TimeZone from, TimeZone to) {
        int offsetBefore = from.getOffset(now);
        int offsetAfter = to.getOffset(now);
        return offsetAfter - offsetBefore;
    }

    public static int getOffset(JDateTime jdt, TimeZone tz) {
        return tz.getOffset(jdt.getEra(), jdt.getYear(), jdt.getMonth() - 1, jdt.getDay(), TimeUtil.toCalendarDayOfWeek(jdt.getDayOfWeek()), jdt.getMillisOfDay());
    }

    public static int getOffsetDifference(JDateTime jdt, TimeZone from, TimeZone to) {
        int offsetBefore = TimeZoneUtil.getOffset(jdt, from);
        int offsetAfter = TimeZoneUtil.getOffset(jdt, to);
        return offsetAfter - offsetBefore;
    }
}

