/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.jodd.cache;

import com.facebook.presto.hive.$internal.jodd.cache.Cache;
import com.facebook.presto.hive.$internal.jodd.cache.CacheValuesIterator;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCacheMap<K, V>
implements Cache<K, V> {
    protected Map<K, CacheObject<K, V>> cacheMap;
    private final ReentrantReadWriteLock cacheLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.cacheLock.readLock();
    private final Lock writeLock = this.cacheLock.writeLock();
    protected int cacheSize;
    protected long timeout;
    protected boolean existCustomTimeout;
    protected int hitCount;
    protected int missCount;

    @Override
    public int getCacheSize() {
        return this.cacheSize;
    }

    @Override
    public long getCacheTimeout() {
        return this.timeout;
    }

    protected boolean isPruneExpiredActive() {
        return this.timeout != 0L || this.existCustomTimeout;
    }

    @Override
    public void put(K key, V object) {
        this.put(key, object, this.timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K key, V object, long timeout) {
        this.writeLock.lock();
        try {
            CacheObject<K, V> co = new CacheObject<K, V>(key, object, timeout);
            if (timeout != 0L) {
                this.existCustomTimeout = true;
            }
            if (this.isFull()) {
                this.pruneCache();
            }
            this.cacheMap.put(key, co);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public int getHitCount() {
        return this.hitCount;
    }

    public int getMissCount() {
        return this.missCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) {
        this.readLock.lock();
        try {
            CacheObject<K, V> co = this.cacheMap.get(key);
            if (co == null) {
                ++this.missCount;
                V v = null;
                return v;
            }
            if (co.isExpired()) {
                this.cacheMap.remove(key);
                ++this.missCount;
                V v = null;
                return v;
            }
            ++this.hitCount;
            V v = co.getObject();
            return v;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Iterator<V> iterator() {
        return new CacheValuesIterator(this);
    }

    protected abstract int pruneCache();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int prune() {
        this.writeLock.lock();
        try {
            int n = this.pruneCache();
            return n;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean isFull() {
        if (this.cacheSize == 0) {
            return false;
        }
        return this.cacheMap.size() >= this.cacheSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(K key) {
        this.writeLock.lock();
        try {
            this.cacheMap.remove(key);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.writeLock.lock();
        try {
            this.cacheMap.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public int size() {
        return this.cacheMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CacheObject<K2, V2> {
        final K2 key;
        final V2 cachedObject;
        long lastAccess;
        long accessCount;
        long ttl;

        CacheObject(K2 key, V2 object, long ttl) {
            this.key = key;
            this.cachedObject = object;
            this.ttl = ttl;
            this.lastAccess = System.currentTimeMillis();
        }

        boolean isExpired() {
            if (this.ttl == 0L) {
                return false;
            }
            return this.lastAccess + this.ttl < System.currentTimeMillis();
        }

        V2 getObject() {
            this.lastAccess = System.currentTimeMillis();
            ++this.accessCount;
            return this.cachedObject;
        }
    }
}

