/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.APIResponse;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class BatchRequest {
    List<Pair> requests = new ArrayList<Pair>();
    APIContext context = null;

    public BatchRequest(APIContext context) {
        this.context = context;
    }

    public BatchRequest addRequest(APIRequest request) {
        String name = "Request" + this.requests.size();
        this.addRequest(name, request);
        return this;
    }

    public BatchRequest addRequest(String name, APIRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("Cannot add null into batch request!");
        }
        this.requests.add(new Pair(name, request));
        return this;
    }

    public BatchRequest addRequest(String name, boolean omitResponseOnSuccess, APIRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("Cannot add null into batch request!");
        }
        this.requests.add(new Pair(name, omitResponseOnSuccess, request));
        return this;
    }

    public List<APIResponse> execute() throws APIException {
        try {
            ArrayList<APIResponse> responses = new ArrayList<APIResponse>();
            String batchResponse = this.executeInternal();
            this.context.log(batchResponse);
            JsonArray jsonArray = new JsonParser().parse(batchResponse).getAsJsonArray();
            if (jsonArray.size() != this.requests.size()) {
                throw new APIException.MalformedResponseException("Batch request size is " + this.requests.size() + ", but response size is " + jsonArray.size());
            }
            for (int i = 0; i < jsonArray.size(); ++i) {
                if (jsonArray.get(i).isJsonNull()) {
                    responses.add(null);
                    continue;
                }
                JsonObject response = jsonArray.get(i).getAsJsonObject();
                if (response == null || response.get("body") == null || response.get("body").isJsonNull()) {
                    responses.add(null);
                    continue;
                }
                if (response.get("code").getAsInt() == 200) {
                    String body = response.get("body").getAsString();
                    APIRequest request = this.requests.get((int)i).request;
                    responses.add(request.parseResponse(body, null));
                    continue;
                }
                responses.add(new APIException.FailedRequestException(response.toString()));
            }
            return responses;
        }
        catch (IOException e) {
            throw new APIException.FailedRequestException(e);
        }
    }

    public String executeInternal() throws APIException, IOException {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        HashMap<String, File> files = new HashMap<String, File>();
        JsonArray batch = new JsonArray();
        params.put("access_token", this.context.getAccessToken());
        if (this.context.hasAppSecret()) {
            params.put("appsecret_proof", this.context.getAppSecretProof());
        }
        params.put("include_headers", "false");
        for (Pair requestEntry : this.requests) {
            JsonObject batchElement = new JsonObject();
            BatchModeRequestInfo info = requestEntry.request.getBatchModeRequestInfo();
            batchElement.addProperty("method", info.method);
            batchElement.addProperty("relative_url", info.relativeUrl);
            batchElement.addProperty("name", requestEntry.name);
            batchElement.addProperty("omit_response_on_success", Boolean.valueOf(requestEntry.omitResponseOnSuccess));
            if (info.body != null) {
                batchElement.addProperty("body", info.body);
            }
            if (info.files != null) {
                JsonObject attachedFiles = new JsonObject();
                for (Map.Entry<String, File> entry : info.files.entrySet()) {
                    File file = entry.getValue();
                    attachedFiles.addProperty("File" + files.size(), entry.getKey());
                    files.put("File" + files.size(), file);
                }
                batchElement.add("attached_files", (JsonElement)attachedFiles);
            }
            batch.add((JsonElement)batchElement);
        }
        params.put("batch", batch.toString());
        params.putAll(files);
        return APIRequest.getExecutor().sendPost(this.context.getEndpointBase() + "/", params, this.context).getBody();
    }

    private static class Pair {
        String name;
        boolean omitResponseOnSuccess;
        APIRequest request;

        Pair(String name, APIRequest request) {
            this.name = name;
            this.request = request;
        }

        Pair(String name, boolean omitResponseOnSuccess, APIRequest request) {
            this.name = name;
            this.omitResponseOnSuccess = omitResponseOnSuccess;
            this.request = request;
        }
    }

    public static class BatchModeRequestInfo {
        public String method;
        public String body;
        public String relativeUrl;
        public boolean omit_response_on_success;
        public Map<String, File> files;
    }
}

