/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class SimpleRasterizer {
    public static final int EVEN_ODD = 0;
    public static final int WINDING = 1;
    private static EdgeComparator edgeCompare_ = new EdgeComparator();
    private ArrayList<Edge> recycledEdges_;
    private ArrayList<Edge> activeEdgesTable_;
    private ArrayList<ArrayList<Edge>> ySortedEdges_;
    public ScanCallback callback_;
    private int width_ = -1;
    private int height_ = -1;
    private int minY_;
    private int maxY_;
    private int numEdges_;
    private boolean evenOdd_;

    public void setup(int width, int height, ScanCallback callback) {
        this.width_ = width;
        this.height_ = height;
        this.ySortedEdges_ = null;
        this.activeEdgesTable_ = null;
        this.numEdges_ = 0;
        this.callback_ = callback;
        this.startAddingEdges();
    }

    public int getWidth() {
        return this.width_;
    }

    public int getHeight() {
        return this.height_;
    }

    public void addTriangle(double x1, double y1, double x2, double y2, double x3, double y3) {
        this.addEdge(x1, y1, x2, y2);
        this.addEdge(x2, y2, x3, y3);
        this.addEdge(x1, y1, x3, y3);
    }

    public void addRing(double[] xy) {
        for (int i = 2; i < xy.length; i += 2) {
            this.addEdge(xy[i - 2], xy[i - 1], xy[i], xy[i + 1]);
        }
    }

    public void startAddingEdges() {
        if (this.numEdges_ > 0) {
            this.ySortedEdges_ = null;
            this.activeEdgesTable_ = null;
        }
        this.minY_ = this.height_;
        this.maxY_ = -1;
        this.numEdges_ = 0;
    }

    public void renderEdges(int fillMode) {
        this.evenOdd_ = fillMode == 0;
        for (int line = this.minY_; line <= this.maxY_; ++line) {
            this.advanceAET_();
            this.addNewEdgesToAET_(line);
            this.emitScans_();
        }
        this.numEdges_ = 0;
        if (this.activeEdgesTable_ != null) {
            this.activeEdgesTable_.clear();
        }
        this.startAddingEdges();
    }

    public void addEdge(double x1, double y1, double x2, double y2) {
        if (y1 == y2) {
            return;
        }
        int dir = 1;
        if (y1 > y2) {
            double temp = x1;
            x1 = x2;
            x2 = temp;
            temp = y1;
            y1 = y2;
            y2 = temp;
            dir = -1;
        }
        if (y2 < 0.0 || y1 >= (double)this.height_) {
            return;
        }
        if (x1 < 0.0 && x2 < 0.0) {
            x1 = -1.0;
            x2 = -1.0;
        } else if (x1 >= (double)this.width_ && x2 >= (double)this.width_) {
            x1 = this.width_;
            x2 = this.width_;
        }
        double dxdy = (x2 - x1) / (y2 - y1);
        if (y2 > (double)this.height_) {
            y2 = this.height_;
            x2 = dxdy * (y2 - y1) + x1;
        }
        if (y1 < 0.0) {
            x1 = dxdy * (0.0 - y1) + x1;
            y1 = 0.0;
        }
        int bigX = Math.max(this.width_ + 1, 0x7FFFFF);
        if (x1 < -8388607.0) {
            y1 = (0.0 - x1) / dxdy + y1;
            x1 = 0.0;
        } else if (x1 > (double)bigX) {
            y1 = ((double)this.width_ - x1) / dxdy + y1;
            x1 = this.width_;
        }
        if (x2 < -8388607.0) {
            y2 = (0.0 - x1) / dxdy + y1;
            x2 = 0.0;
        } else if (x2 > (double)bigX) {
            y2 = ((double)this.width_ - x1) / dxdy + y1;
            x2 = this.width_;
        }
        int ystart = (int)y1;
        int yend = (int)y2;
        if (ystart == yend) {
            return;
        }
        Edge e = this.recycledEdges_ != null && this.recycledEdges_.size() > 0 ? this.recycledEdges_.remove(this.recycledEdges_.size() - 1) : new Edge();
        e.x = (long)(x1 * 4.294967296E9);
        e.y = ystart;
        e.ymax = yend;
        e.dxdy = (long)(dxdy * 4.294967296E9);
        e.dir = dir;
        if (this.ySortedEdges_ == null) {
            this.ySortedEdges_ = new ArrayList();
            this.ySortedEdges_.ensureCapacity(this.height_);
            for (int i = 0; i < this.height_; ++i) {
                this.ySortedEdges_.add(null);
            }
        }
        if (this.ySortedEdges_.get(e.y) == null) {
            this.ySortedEdges_.set(e.y, new ArrayList());
        }
        this.ySortedEdges_.get(e.y).add(e);
        if (e.y < this.minY_) {
            this.minY_ = e.y;
        }
        if (e.ymax > this.maxY_) {
            this.maxY_ = e.ymax;
        }
    }

    private void advanceAET_() {
        if (this.activeEdgesTable_ != null && this.activeEdgesTable_.size() > 0) {
            int n = this.activeEdgesTable_.size();
            for (int i = 0; i < n; ++i) {
                Edge e = this.activeEdgesTable_.get(i);
                ++e.y;
                if (e.y == e.ymax) {
                    if (this.recycledEdges_ == null) {
                        this.recycledEdges_ = new ArrayList();
                    }
                    this.recycledEdges_.add(e);
                    this.activeEdgesTable_.set(i, null);
                    continue;
                }
                e.x += e.dxdy;
            }
        }
    }

    private void addNewEdgesToAET_(int y) {
        ArrayList<Edge> edgesOnLine;
        if (y >= this.ySortedEdges_.size()) {
            return;
        }
        if (this.activeEdgesTable_ == null) {
            this.activeEdgesTable_ = new ArrayList();
        }
        if ((edgesOnLine = this.ySortedEdges_.get(y)) != null) {
            int n = edgesOnLine.size();
            for (int i = 0; i < n; ++i) {
                this.activeEdgesTable_.add(edgesOnLine.get(i));
            }
            edgesOnLine.clear();
        }
    }

    static int snap_(int x, int mi, int ma) {
        return x < mi ? mi : (x > ma ? ma : x);
    }

    private void emitScans_() {
        this.sortAET_();
        if (this.activeEdgesTable_ == null || this.activeEdgesTable_.size() == 0) {
            return;
        }
        int w = 0;
        Edge e0 = this.activeEdgesTable_.get(0);
        int x0 = (int)(e0.x >> 32);
        for (int i = 1; i < this.activeEdgesTable_.size(); ++i) {
            Edge e = this.activeEdgesTable_.get(i);
            w = this.evenOdd_ ? (w ^= 1) : (w += e.dir);
            if (e.x <= e0.x) continue;
            int x = (int)(e.x >> 32);
            if (w == 1) {
                int xx0 = SimpleRasterizer.snap_(x0, 0, this.width_);
                int xx = SimpleRasterizer.snap_(x, 0, this.width_);
                if (xx > xx0 && xx0 < this.width_) {
                    this.callback_.drawScan(e.y, xx0, xx - xx0);
                }
            }
            e0 = e;
            x0 = x;
        }
    }

    private void sortAET_() {
        if (!this.checkAETIsSorted_()) {
            Collections.sort(this.activeEdgesTable_, edgeCompare_);
            while (this.activeEdgesTable_.size() > 0 && this.activeEdgesTable_.get(this.activeEdgesTable_.size() - 1) == null) {
                this.activeEdgesTable_.remove(this.activeEdgesTable_.size() - 1);
            }
        }
    }

    private boolean checkAETIsSorted_() {
        if (this.activeEdgesTable_ == null || this.activeEdgesTable_.size() == 0) {
            return true;
        }
        Edge e0 = this.activeEdgesTable_.get(0);
        if (e0 == null) {
            return false;
        }
        for (int i = 1; i < this.activeEdgesTable_.size(); ++i) {
            Edge e = this.activeEdgesTable_.get(i);
            if (e == null || e.x < e0.x) {
                return false;
            }
            e0 = e;
        }
        return true;
    }

    static class EdgeComparator
    implements Comparator<Edge> {
        EdgeComparator() {
        }

        @Override
        public int compare(Edge o1, Edge o2) {
            if (o1 == null) {
                return o2 == null ? 0 : 1;
            }
            if (o2 == null) {
                return -1;
            }
            return o1.x < o2.x ? -1 : (o1.x > o2.x ? 1 : 0);
        }
    }

    class Edge {
        long x;
        long dxdy;
        int y;
        int ymax;
        int dir;

        Edge() {
        }
    }

    public static interface ScanCallback {
        public void drawScan(int var1, int var2, int var3);
    }
}

