/*
 * Decompiled with CFR 0.152.
 */
package com.dyuproject.protostuff;

import com.dyuproject.protostuff.ByteArrayInput;
import com.dyuproject.protostuff.CodedInput;
import com.dyuproject.protostuff.Input;
import com.dyuproject.protostuff.LimitedInputStream;
import com.dyuproject.protostuff.ProtobufException;
import com.dyuproject.protostuff.Schema;
import com.dyuproject.protostuff.UninitializedMessageException;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class IOUtil {
    private IOUtil() {
    }

    static <T> void mergeFrom(byte[] data, int offset, int length, T message, Schema<T> schema, boolean decodeNestedMessageAsGroup) {
        try {
            ByteArrayInput input = new ByteArrayInput(data, offset, length, decodeNestedMessageAsGroup);
            schema.mergeFrom((Input)input, message);
            input.checkLastTagWas(0);
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            throw new RuntimeException("Reading from a byte array threw an IOException (should never happen).", (Throwable)((Object)ProtobufException.truncatedMessage(ae)));
        }
        catch (IOException e) {
            throw new RuntimeException("Reading from a byte array threw an IOException (should never happen).", e);
        }
    }

    static <T> void mergeFrom(InputStream in, byte[] buf, T message, Schema<T> schema, boolean decodeNestedMessageAsGroup) throws IOException {
        CodedInput input = new CodedInput(in, buf, decodeNestedMessageAsGroup);
        schema.mergeFrom((Input)input, message);
        input.checkLastTagWas(0);
    }

    static <T> void mergeFrom(InputStream in, T message, Schema<T> schema, boolean decodeNestedMessageAsGroup) throws IOException {
        CodedInput input = new CodedInput(in, decodeNestedMessageAsGroup);
        schema.mergeFrom((Input)input, message);
        input.checkLastTagWas(0);
    }

    static <T> void mergeDelimitedFrom(InputStream in, byte[] buf, T message, Schema<T> schema, boolean decodeNestedMessageAsGroup) throws IOException {
        int len;
        int size = in.read();
        if (size == -1) {
            throw new EOFException("mergeDelimitedFrom");
        }
        int n = len = size < 128 ? size : CodedInput.readRawVarint32(in, size);
        if (len != 0) {
            if (len > buf.length) {
                throw new ProtobufException("size limit exceeded. " + len + " > " + buf.length);
            }
            IOUtil.fillBufferFrom(in, buf, 0, len);
            ByteArrayInput input = new ByteArrayInput(buf, 0, len, decodeNestedMessageAsGroup);
            try {
                schema.mergeFrom((Input)input, message);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw ProtobufException.truncatedMessage(e);
            }
            input.checkLastTagWas(0);
        }
    }

    static <T> void mergeDelimitedFrom(InputStream in, T message, Schema<T> schema, boolean decodeNestedMessageAsGroup) throws IOException {
        int len;
        int size = in.read();
        if (size == -1) {
            throw new EOFException("mergeDelimitedFrom");
        }
        int n = len = size < 128 ? size : CodedInput.readRawVarint32(in, size);
        if (len != 0) {
            if (len > 4096) {
                CodedInput input = new CodedInput(new LimitedInputStream(in, len), decodeNestedMessageAsGroup);
                schema.mergeFrom((Input)input, message);
                input.checkLastTagWas(0);
                return;
            }
            byte[] buf = new byte[len];
            IOUtil.fillBufferFrom(in, buf, 0, len);
            ByteArrayInput input = new ByteArrayInput(buf, 0, len, decodeNestedMessageAsGroup);
            try {
                schema.mergeFrom((Input)input, message);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw ProtobufException.truncatedMessage(e);
            }
            input.checkLastTagWas(0);
        }
    }

    static <T> void mergeDelimitedFrom(DataInput in, T message, Schema<T> schema, boolean decodeNestedMessageAsGroup) throws IOException {
        int len;
        int size = in.readByte();
        if (size == -1) {
            throw new EOFException("mergeDelimitedFrom");
        }
        int n = len = size < 128 ? size : CodedInput.readRawVarint32(in, (byte)size);
        if (len != 0) {
            if (len > 4096 && in instanceof InputStream) {
                CodedInput input = new CodedInput(new LimitedInputStream((InputStream)((Object)in), len), decodeNestedMessageAsGroup);
                schema.mergeFrom((Input)input, message);
                input.checkLastTagWas(0);
            } else {
                byte[] buf = new byte[len];
                in.readFully(buf, 0, len);
                ByteArrayInput input = new ByteArrayInput(buf, 0, len, decodeNestedMessageAsGroup);
                try {
                    schema.mergeFrom((Input)input, message);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw ProtobufException.truncatedMessage(e);
                }
                input.checkLastTagWas(0);
            }
        }
        if (!schema.isInitialized(message)) {
            throw new UninitializedMessageException(message, schema);
        }
    }

    static void fillBufferFrom(InputStream in, byte[] buf, int offset, int len) throws IOException {
        int read = 0;
        while (len > 0) {
            read = in.read(buf, offset, len);
            if (read == -1) {
                throw ProtobufException.truncatedMessage();
            }
            len -= read;
            offset += read;
        }
    }
}

