/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android;

import com.dynatrace.android.instrumentation.sensor.agent.InstrumentationFlavor;
import com.dynatrace.tools.android.InstrumentationFlavorParser;
import org.gradle.api.GradleException;
import org.gradle.api.Project;

public class DynatraceGradleProperties {
    private final InstrumentationFlavor instrumentationFlavor;
    private final boolean enableComposeVersionVerification;
    private final int eventThrottlingLimit;

    private DynatraceGradleProperties(PropertyFactory propertyFactory) {
        this.instrumentationFlavor = propertyFactory.instrumentationFlavor;
        this.enableComposeVersionVerification = propertyFactory.enableComposeVersionVerification;
        this.eventThrottlingLimit = propertyFactory.eventThrottlingLimit;
    }

    public InstrumentationFlavor getInstrumentationFlavor() {
        return this.instrumentationFlavor;
    }

    public boolean isComposeVersionVerificationEnabled() {
        return this.enableComposeVersionVerification;
    }

    public int eventThrottlingLimit() {
        return this.eventThrottlingLimit;
    }

    public String toString() {
        return "DynatraceGradleProperties{instrumentationFlavor=" + this.instrumentationFlavor + ", enableComposeVersionVerification=" + this.enableComposeVersionVerification + "}";
    }

    public static class PropertyFactory {
        private static final String INSTRUMENTATION_FLAVOR = "dynatrace.instrumentationFlavor";
        private static final String ENABLE_SESSION_REPLAY_COMPOSE_INSTRUMENTATION = "dynatrace.instrumentSessionReplayCompose";
        private static final String ENABLE_COMPOSE_VERSION_VERIFICATION = "dynatrace.enableComposeVersionVerification";
        private static final String ENABLE_USER_INTERACTION = "dynatrace.enableUserInteraction";
        private static final String EVENT_THROTTLING_LIMIT = "dynatrace.eventThrottlingLimit";
        private InstrumentationFlavor instrumentationFlavor = InstrumentationFlavor.PLAIN;
        private boolean enableComposeVersionVerification = true;
        private int eventThrottlingLimit = 500;

        public PropertyFactory withInstrumentationFlavor(InstrumentationFlavor instrumentationFlavor) {
            if (instrumentationFlavor == null) {
                instrumentationFlavor = InstrumentationFlavor.PLAIN;
            }
            this.instrumentationFlavor = instrumentationFlavor;
            return this;
        }

        public PropertyFactory withComposeVersionVerificationEnabled(boolean enableComposeVersionVerification) {
            this.enableComposeVersionVerification = enableComposeVersionVerification;
            return this;
        }

        public PropertyFactory withEventThrottlingLimit(int eventThrottlingLimit) {
            this.eventThrottlingLimit = eventThrottlingLimit;
            return this;
        }

        public PropertyFactory fromProject(Project project) {
            String eventThrottlingLimitProperty;
            try {
                this.withInstrumentationFlavor(new InstrumentationFlavorParser().parse((String)project.findProperty(INSTRUMENTATION_FLAVOR)));
            }
            catch (IllegalArgumentException e) {
                throw new GradleException("Can't parse value from property 'dynatrace.instrumentationFlavor'", (Throwable)e);
            }
            String composeVerification = (String)project.findProperty(ENABLE_COMPOSE_VERSION_VERIFICATION);
            if (composeVerification != null && !composeVerification.isEmpty()) {
                this.withComposeVersionVerificationEnabled(Boolean.parseBoolean(composeVerification));
            }
            if ((eventThrottlingLimitProperty = (String)project.findProperty(EVENT_THROTTLING_LIMIT)) != null && !eventThrottlingLimitProperty.isEmpty()) {
                try {
                    int specifiedLimit = Integer.parseInt(eventThrottlingLimitProperty);
                    if (specifiedLimit < 500 || specifiedLimit > 1000) {
                        throw new GradleException("Value of property 'dynatrace.eventThrottlingLimit' is beyond its valid range of 500..1000");
                    }
                    this.withEventThrottlingLimit(specifiedLimit);
                }
                catch (NumberFormatException e) {
                    throw new GradleException("The specified property 'dynatrace.eventThrottlingLimit' is not a number");
                }
            }
            return this;
        }

        public DynatraceGradleProperties build() {
            return new DynatraceGradleProperties(this);
        }
    }
}

