/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android;

import com.android.build.api.AndroidPluginVersion;
import com.android.build.api.variant.AndroidComponentsExtension;
import com.android.build.api.variant.Variant;
import com.android.build.api.variant.VariantBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgpVersionVerifier {
    private static final Logger logger = LoggerFactory.getLogger((String)"AgpVersionVerifier");
    private static final AndroidPluginVersion MIN_VERSION = new AndroidPluginVersion(7, 0);
    private static final AndroidPluginVersion MAX_VERSION = new AndroidPluginVersion(9, 0);

    private static boolean isVersionTooLow(AndroidPluginVersion curVersion) {
        return curVersion.compareTo(MIN_VERSION) < 0;
    }

    private static boolean isVersionTooHigh(AndroidPluginVersion curVersion) {
        return curVersion.compareTo(MAX_VERSION) >= 0;
    }

    public AndroidPluginVersion verifyAgpVersion(AndroidComponentsExtension<?, VariantBuilder, Variant> androidExtension) {
        AndroidPluginVersion androidPluginVersion = androidExtension.getPluginVersion();
        if (androidPluginVersion.getPreviewType() != null) {
            logger.info("[Dynatrace] Preview version of the Android Gradle plugin detected. For production builds a stable Android Gradle plugin version is recommended.");
        }
        if (AgpVersionVerifier.isVersionTooHigh(androidPluginVersion) || AgpVersionVerifier.isVersionTooLow(androidPluginVersion)) {
            throw new RuntimeException(androidPluginVersion + " is not supported. Make sure to use the latest version of the Dynatrace Android Gradle Plugin");
        }
        return androidPluginVersion;
    }
}

