/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.sensor.compose.sensor;

import com.dynatrace.android.instrumentation.ClassInfo;
import com.dynatrace.android.instrumentation.MethodInfo;
import com.dynatrace.android.instrumentation.MethodInstruction;
import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensorImpl;
import com.dynatrace.android.instrumentation.sensor.method.MethodTransformation;
import com.dynatrace.android.instrumentation.shared.TransformerUtils;
import com.dynatrace.android.instrumentation.util.Utils;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class NodeCoordinatorSensor
implements SensorGroup<MethodSensor> {
    private static final String NODE_COORDINATOR_SOURCE = "androidx.compose.ui.node.NodeCoordinator";
    private static final String HIT_METHOD_NAME_1 = "hit-1hIXUjU";
    private static final String HIT_METHOD_NAME_2 = "hit-5ShdDok";
    private static final String HIT_METHOD_DESCRIPTION_1_1 = "(Landroidx/compose/ui/Modifier$Node;Landroidx/compose/ui/node/NodeCoordinator$HitTestSource;JLandroidx/compose/ui/node/HitTestResult;IZ)V";
    private static final String HIT_METHOD_DESCRIPTION_1_2 = "(Landroidx/compose/ui/node/DelegatableNode;Landroidx/compose/ui/node/NodeCoordinator$HitTestSource;JLandroidx/compose/ui/node/HitTestResult;ZZ)V";
    private static final String HIT_METHOD_DESCRIPTION_1_3 = "(Landroidx/compose/ui/Modifier$Node;Landroidx/compose/ui/node/NodeCoordinator$HitTestSource;JLandroidx/compose/ui/node/HitTestResult;ZZ)V";
    private static final String HIT_METHOD_DESCRIPTION_2_1 = "(Landroidx/compose/ui/Modifier$Node;Landroidx/compose/ui/node/NodeCoordinator$HitTestSource;JLandroidx/compose/ui/node/HitTestResult;ZZIZ)V";
    private static final String HIT_METHOD_DESCRIPTION_2_2 = "(Landroidx/compose/ui/Modifier$Node;Landroidx/compose/ui/node/NodeCoordinator$HitTestSource;JLandroidx/compose/ui/node/HitTestResult;IZ)V";

    @Override
    public boolean matchClass(ClassInfo classInfo) {
        return NODE_COORDINATOR_SOURCE.equals(classInfo.getName());
    }

    @Override
    public List<MethodSensor> getSensors() {
        return List.of(this.generateHitSensor(HIT_METHOD_NAME_2, HIT_METHOD_DESCRIPTION_2_1), this.generateHitSensor(HIT_METHOD_NAME_2, "(Landroidx/compose/ui/Modifier$Node;Landroidx/compose/ui/node/NodeCoordinator$HitTestSource;JLandroidx/compose/ui/node/HitTestResult;IZ)V"), this.generateHitSensor(HIT_METHOD_NAME_1, "(Landroidx/compose/ui/Modifier$Node;Landroidx/compose/ui/node/NodeCoordinator$HitTestSource;JLandroidx/compose/ui/node/HitTestResult;IZ)V"), this.generateHitSensor(HIT_METHOD_NAME_1, HIT_METHOD_DESCRIPTION_1_2), this.generateHitSensor(HIT_METHOD_NAME_1, HIT_METHOD_DESCRIPTION_1_3));
    }

    private MethodSensor generateHitSensor(String methodName, String methodDescription) {
        MethodInfo methodInfo = new MethodInfo(methodName, methodDescription, 17, null, new ArrayList<String>());
        MethodTransformation hitTransformation = (methodNode, startParameterIndex) -> {
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)Utils.generateMethodInstructionNode(MethodInstruction.createPublicMethodInstruction(Utils.dotToSlash(NODE_COORDINATOR_SOURCE), "getLayoutNode", "()Landroidx/compose/ui/node/LayoutNode;")));
            list.add((AbstractInsnNode)new VarInsnNode(25, startParameterIndex + 4));
            list.add((AbstractInsnNode)Utils.generateMethodInstructionNode(MethodInstruction.createPublicMethodInstruction("androidx/compose/ui/node/HitTestResult", "hasHit", "()Z")));
            list.add(this.getPathToRootInstructions());
            list.add((AbstractInsnNode)new MethodInsnNode(184, Utils.dotToSlash("com.dynatrace.android.compose.userinteraction.UserInteractionsApi"), "onNodeCoordinatorHit", "(Landroidx/compose/ui/layout/LayoutInfo;ZLjava/util/List;)V", false));
            ArrayList<AbstractInsnNode> returnInstructions = new ArrayList<AbstractInsnNode>();
            for (AbstractInsnNode instruction : methodNode.instructions) {
                if (!TransformerUtils.isReturnInstruction(instruction)) continue;
                returnInstructions.add(instruction);
            }
            methodNode.instructions.insertBefore((AbstractInsnNode)returnInstructions.get(returnInstructions.size() - 1), list);
        };
        return new MethodSensorImpl(methodInfo, hitTransformation);
    }

    private InsnList getPathToRootInstructions() {
        InsnList instructions = new InsnList();
        instructions.add((AbstractInsnNode)new TypeInsnNode(187, "java/util/ArrayList"));
        instructions.add((AbstractInsnNode)new InsnNode(89));
        instructions.add((AbstractInsnNode)new MethodInsnNode(183, "java/util/ArrayList", "<init>", "()V", false));
        instructions.add((AbstractInsnNode)new VarInsnNode(58, 1));
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        instructions.add((AbstractInsnNode)Utils.generateMethodInstructionNode(MethodInstruction.createPublicMethodInstruction(Utils.dotToSlash(NODE_COORDINATOR_SOURCE), "getLayoutNode", "()Landroidx/compose/ui/node/LayoutNode;")));
        instructions.add((AbstractInsnNode)new VarInsnNode(58, 2));
        LabelNode loopStart = new LabelNode();
        LabelNode loopEnd = new LabelNode();
        instructions.add((AbstractInsnNode)loopStart);
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 2));
        instructions.add((AbstractInsnNode)new JumpInsnNode(198, loopEnd));
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 2));
        instructions.add((AbstractInsnNode)new MethodInsnNode(182, "androidx/compose/ui/node/LayoutNode", "getParent$ui_release", "()Landroidx/compose/ui/node/LayoutNode;", false));
        instructions.add((AbstractInsnNode)new VarInsnNode(58, 3));
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 3));
        instructions.add((AbstractInsnNode)new JumpInsnNode(198, loopEnd));
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 3));
        instructions.add((AbstractInsnNode)new InsnNode(89));
        instructions.add((AbstractInsnNode)new VarInsnNode(58, 4));
        instructions.add((AbstractInsnNode)new MethodInsnNode(182, "androidx/compose/ui/node/LayoutNode", "getChildren$ui_release", "()Ljava/util/List;", false));
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 2));
        instructions.add((AbstractInsnNode)new MethodInsnNode(185, "java/util/List", "indexOf", "(Ljava/lang/Object;)I", true));
        instructions.add((AbstractInsnNode)new VarInsnNode(54, 5));
        instructions.add((AbstractInsnNode)new TypeInsnNode(187, "java/util/ArrayList"));
        instructions.add((AbstractInsnNode)new InsnNode(89));
        instructions.add((AbstractInsnNode)new MethodInsnNode(183, "java/util/ArrayList", "<init>", "()V", false));
        instructions.add((AbstractInsnNode)new VarInsnNode(58, 6));
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 6));
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 2));
        instructions.add((AbstractInsnNode)new MethodInsnNode(182, "androidx/compose/ui/node/LayoutNode", "getSemanticsId", "()I", false));
        instructions.add((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Integer", "toString", "(I)Ljava/lang/String;", false));
        instructions.add((AbstractInsnNode)new MethodInsnNode(185, "java/util/List", "add", "(Ljava/lang/Object;)Z", true));
        instructions.add((AbstractInsnNode)new InsnNode(87));
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 6));
        instructions.add((AbstractInsnNode)new VarInsnNode(21, 5));
        instructions.add((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Integer", "toString", "(I)Ljava/lang/String;", false));
        instructions.add((AbstractInsnNode)new MethodInsnNode(185, "java/util/List", "add", "(Ljava/lang/Object;)Z", true));
        instructions.add((AbstractInsnNode)new InsnNode(87));
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 6));
        instructions.add((AbstractInsnNode)new MethodInsnNode(185, "java/util/List", "add", "(Ljava/lang/Object;)Z", true));
        instructions.add((AbstractInsnNode)new InsnNode(87));
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 4));
        instructions.add((AbstractInsnNode)new VarInsnNode(58, 2));
        instructions.add((AbstractInsnNode)new JumpInsnNode(167, loopStart));
        instructions.add((AbstractInsnNode)loopEnd);
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
        return instructions;
    }
}

