/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.sensor.compose.replay.transformation;

import com.dynatrace.android.instrumentation.ClassResolver;
import com.dynatrace.android.instrumentation.sensor.compose.replay.util.Utils;
import com.dynatrace.android.instrumentation.sensor.compose.version.ComposeUi;
import com.dynatrace.android.instrumentation.sensor.method.MethodTransformation;
import java.util.List;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ComposeReplayBasicTextFieldTransformation_1_9
implements MethodTransformation {
    private final String basicTextFieldCallback;
    private final String composePackage;
    private final List<String> parametersList;
    private final String callbackFunctionName;
    private final String returnValue;

    public ComposeReplayBasicTextFieldTransformation_1_9(ClassResolver classResolver, String callbackFunctionName, List<String> parametersList, String returnValue) {
        this.composePackage = ComposeUi.getVersionPackage(classResolver);
        this.parametersList = parametersList;
        this.returnValue = returnValue;
        this.basicTextFieldCallback = this.composePackage + "/callback/BasicTextFieldComposeCallbackGenerator";
        this.callbackFunctionName = callbackFunctionName;
    }

    @Override
    public void transformMethod(MethodNode methodNode, int startParameterIndex) {
        InsnList list = new InsnList();
        this.addCustomModifier(list, methodNode);
        StringBuilder functionParams = new StringBuilder();
        for (String parameter : this.parametersList) {
            list.add((AbstractInsnNode)new VarInsnNode(25, Utils.getIndexOfParam(methodNode, parameter)));
            functionParams.append(parameter);
        }
        list.add((AbstractInsnNode)new MethodInsnNode(184, this.basicTextFieldCallback, this.callbackFunctionName, "(" + functionParams + ")" + this.returnValue));
        list.add((AbstractInsnNode)new VarInsnNode(58, Utils.getIndexOfParam(methodNode, this.returnValue)));
        methodNode.instructions.insertBefore(methodNode.instructions.getFirst(), list);
    }

    private void addCustomModifier(InsnList list, MethodNode methodNode) {
        int modifierPosition = Utils.getIndexOfParam(methodNode, "Landroidx/compose/ui/Modifier;");
        if (modifierPosition != -1) {
            LabelNode wrapLabel = new LabelNode();
            LabelNode endLabel = new LabelNode();
            list.add((AbstractInsnNode)new VarInsnNode(25, modifierPosition));
            list.add((AbstractInsnNode)new JumpInsnNode(199, wrapLabel));
            list.add((AbstractInsnNode)new FieldInsnNode(178, "androidx/compose/ui/Modifier", "Companion", "Landroidx/compose/ui/Modifier$Companion;"));
            list.add((AbstractInsnNode)new TypeInsnNode(192, "androidx/compose/ui/Modifier"));
            list.add((AbstractInsnNode)new VarInsnNode(58, modifierPosition));
            list.add((AbstractInsnNode)wrapLabel);
            list.add((AbstractInsnNode)new VarInsnNode(25, modifierPosition));
            list.add((AbstractInsnNode)new TypeInsnNode(187, this.composePackage + "/model/DTInputTextModifier"));
            list.add((AbstractInsnNode)new InsnNode(89));
            list.add((AbstractInsnNode)new MethodInsnNode(183, this.composePackage + "/model/DTInputTextModifier", "<init>", "()V", false));
            list.add((AbstractInsnNode)new MethodInsnNode(185, "androidx/compose/ui/Modifier", "then", "(Landroidx/compose/ui/Modifier;)Landroidx/compose/ui/Modifier;", true));
            list.add((AbstractInsnNode)new VarInsnNode(58, modifierPosition));
            list.add((AbstractInsnNode)endLabel);
        } else {
            System.out.println("ComposeReplayBasicTextFieldTransformation_1_7 - Modifier position not found");
        }
    }
}

