/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.protocols.mobile.sessionreplay.tags;

import com.dynatrace.protocols.mobile.sessionreplay.BeaconDataType;
import com.dynatrace.protocols.mobile.sessionreplay.ReasonTag;
import com.dynatrace.protocols.mobile.sessionreplay.VisitStoreType;
import com.dynatrace.protocols.mobile.sessionreplay.exceptions.InvalidMobileReplayBeaconDataException;
import com.dynatrace.protocols.mobile.sessionreplay.exceptions.InvalidTypeException;
import com.dynatrace.protocols.mobile.sessionreplay.tags.TaggedBeacon;
import com.dynatrace.protocols.mobile.sessionreplay.tags.Tags;
import com.dynatrace.protocols.mobile.sessionreplay.utils.DimensionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TagBeaconDeserializer
implements TaggedBeacon {
    public static final int TAG_SIZE = 2;
    public static final int SIZE_SIZE = 4;
    private final byte[] beacon;
    private final Map<Tags, Integer> map = new HashMap<Tags, Integer>();

    private TagBeaconDeserializer(byte[] beacon) throws InvalidMobileReplayBeaconDataException {
        Tags tag;
        this.beacon = beacon;
        if (beacon.length == 0) {
            throw new InvalidMobileReplayBeaconDataException("The mobile replay beacon is empty");
        }
        int nextIndex = 0;
        while (nextIndex < beacon.length && (tag = Tags.fromIdentifier(DimensionUtils.getShort(beacon, nextIndex))) != null) {
            this.map.put(tag, nextIndex += 2);
            nextIndex += tag.getSize();
            switch (tag) {
                case VISITOR: 
                case VISIT: 
                case IMAGE: 
                case JSON: 
                case IMAGE_ID: 
                case BEACON_ID: 
                case FULL_SESSION_SELF_MONITORING: {
                    int size = DimensionUtils.getInt(beacon, nextIndex);
                    nextIndex += 4 + size;
                }
            }
        }
        try {
            this.verifyBeaconTags();
        }
        catch (InvalidTypeException e) {
            throw new InvalidMobileReplayBeaconDataException(e.getMessage());
        }
    }

    public static TagBeaconDeserializer parse(byte[] binary) throws InvalidMobileReplayBeaconDataException {
        return new TagBeaconDeserializer(binary);
    }

    @Override
    public Integer getProtocolVersion() {
        Integer index = this.map.get((Object)Tags.PROTOCOL);
        return index == null ? null : Integer.valueOf(DimensionUtils.getShort(this.beacon, index));
    }

    @Override
    public BeaconDataType getType() throws InvalidTypeException {
        Integer index = this.map.get((Object)Tags.TYPE);
        return index == null ? null : BeaconDataType.getType(this.beacon[index]);
    }

    @Override
    public VisitStoreType getVisitStore() {
        Integer index = this.map.get((Object)Tags.VISIT_STORE);
        return index == null ? null : VisitStoreType.VISIT_STORE_TWO;
    }

    @Override
    public Long getStartTime() {
        return this.getLongTag(Tags.START_TIME);
    }

    @Override
    public Long getEndTime() {
        return this.getLongTag(Tags.END_TIME);
    }

    @Override
    public String getVisitorId() {
        return this.getStringTag(Tags.VISITOR);
    }

    @Override
    public String getVisitId() {
        return this.getStringTag(Tags.VISIT);
    }

    @Override
    public Integer getSequenceNumber() {
        Integer index = this.map.get((Object)Tags.SEQUENCE_NUMBER);
        return index == null ? null : Integer.valueOf(DimensionUtils.getInt(this.beacon, index));
    }

    @Override
    public Integer getTotalSequence() {
        Integer index = this.map.get((Object)Tags.TOTAL);
        return index == null ? null : Integer.valueOf(DimensionUtils.getInt(this.beacon, index));
    }

    @Override
    public String getBeaconId() {
        Integer index = this.map.get((Object)Tags.BEACON_ID);
        if (index != null) {
            int size = DimensionUtils.getInt(this.beacon, index);
            return DimensionUtils.getUtf8String(this.beacon, index + 4, size);
        }
        return null;
    }

    @Override
    public short getDataVersion() {
        Integer index = this.map.get((Object)Tags.DATA_VERSION);
        return index == null ? (short)0 : DimensionUtils.getShort(this.beacon, index);
    }

    @Override
    public byte[] getRawData() {
        return this.beacon;
    }

    @Override
    public boolean isMobileReplayBeacon() {
        return !this.map.keySet().isEmpty();
    }

    @Override
    public byte[] getImageTag() throws InvalidTypeException {
        Integer index;
        if (this.getType() == BeaconDataType.IMAGE && (index = this.map.get((Object)Tags.IMAGE)) != null) {
            return Arrays.copyOfRange(this.beacon, index + 4, index + 4 + DimensionUtils.getInt(this.beacon, index));
        }
        return null;
    }

    @Override
    public String getImageId() throws InvalidTypeException {
        Integer index;
        if (this.getType() == BeaconDataType.IMAGE && (index = this.map.get((Object)Tags.IMAGE_ID)) != null) {
            int size = DimensionUtils.getInt(this.beacon, index);
            return DimensionUtils.getUtf8String(this.beacon, index + 4, size);
        }
        return null;
    }

    @Override
    public byte[] getJsonTag() throws InvalidTypeException {
        Integer index;
        if (this.getType() == BeaconDataType.JSON && (index = this.map.get((Object)Tags.JSON)) != null) {
            return Arrays.copyOfRange(this.beacon, index + 4, index + 4 + DimensionUtils.getInt(this.beacon, index));
        }
        return null;
    }

    @Override
    public ReasonTag geReasonTag() throws InvalidTypeException {
        if (this.getType() == BeaconDataType.REASON) {
            Integer index = this.map.get((Object)Tags.REASON);
            return index == null ? null : ReasonTag.getTag(this.beacon[index]);
        }
        return null;
    }

    @Override
    public String getFullSessionSelfMonitoring() throws InvalidTypeException {
        Integer index;
        if (this.getType() == BeaconDataType.SELF_MONITORING && (index = this.map.get((Object)Tags.FULL_SESSION_SELF_MONITORING)) != null) {
            int size = DimensionUtils.getInt(this.beacon, index);
            return DimensionUtils.getUtf8String(this.beacon, index + 4, size);
        }
        return null;
    }

    private void verifyBeaconTags() throws InvalidMobileReplayBeaconDataException, InvalidTypeException {
        if (this.map.isEmpty()) {
            throw new InvalidMobileReplayBeaconDataException("No beacon tags found: " + this.getFirstHexBytesFromBeacon(100));
        }
        ArrayList<String> missingTags = new ArrayList<String>();
        this.verifyTag(missingTags, Tags.PROTOCOL);
        this.verifyTag(missingTags, Tags.TYPE);
        BeaconDataType type = this.getType();
        if (type == BeaconDataType.IMAGE || type == BeaconDataType.JSON || type == BeaconDataType.REASON) {
            missingTags.addAll(this.verifyReplayBeaconTags(type));
        } else if (type == BeaconDataType.SELF_MONITORING) {
            missingTags.addAll(this.verifySelfMonitoringBeaconTags());
        }
        if (!missingTags.isEmpty()) {
            throw new InvalidMobileReplayBeaconDataException(this.getMissingTagsError(missingTags));
        }
    }

    private List<String> verifySelfMonitoringBeaconTags() {
        ArrayList<String> missingTags = new ArrayList<String>();
        this.verifyTag(missingTags, Tags.FULL_SESSION_SELF_MONITORING);
        return missingTags;
    }

    private List<String> verifyReplayBeaconTags(BeaconDataType type) {
        ArrayList<String> missingTags = new ArrayList<String>();
        this.verifyTag(missingTags, Tags.VISITOR);
        this.verifyTag(missingTags, Tags.VISIT);
        this.verifyTag(missingTags, Tags.VISIT_STORE);
        this.verifyTag(missingTags, Tags.START_TIME);
        this.verifyTag(missingTags, Tags.END_TIME);
        this.verifyTag(missingTags, Tags.BEACON_ID);
        if (BeaconDataType.IMAGE.equals((Object)type)) {
            this.verifyTag(missingTags, Tags.IMAGE);
        } else if (BeaconDataType.JSON.equals((Object)type)) {
            this.verifyTag(missingTags, Tags.JSON);
        } else if (BeaconDataType.REASON.equals((Object)type)) {
            this.verifyTag(missingTags, Tags.REASON);
        }
        return missingTags;
    }

    private void verifyTag(List<String> missingTags, Tags tag) {
        if (!this.map.containsKey((Object)tag) || this.map.get((Object)tag) == null) {
            missingTags.add(tag.name());
        }
    }

    private String getStringTag(Tags tag) {
        Integer index = this.map.get((Object)tag);
        return index == null ? null : DimensionUtils.getUtf8String(this.beacon, index + 4, DimensionUtils.getInt(this.beacon, index));
    }

    private Long getLongTag(Tags tag) {
        Integer index = this.map.get((Object)tag);
        return index == null ? null : Long.valueOf(DimensionUtils.getLong(this.beacon, index));
    }

    private String getFirstHexBytesFromBeacon(int numberOfBytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numberOfBytes && i < this.beacon.length; ++i) {
            sb.append(String.format("%02X ", this.beacon[i]));
        }
        return sb.toString();
    }

    private String getMissingTagsError(List<String> missingTags) {
        StringBuilder errorMessage = new StringBuilder("Invalid beacon, missing or invalid tag(s): ");
        for (String s : missingTags) {
            errorMessage.append(s).append(", ");
        }
        errorMessage.replace(errorMessage.length() - 2, errorMessage.length(), "");
        return errorMessage.toString();
    }
}

