/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.callback;

import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.util.Utility;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.RequestLine;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicHttpRequest;

class CbURIDesc {
    private static final String LOGTAG = Global.LOG_PREFIX + "CbURIDesc";
    String host;
    String desc;
    URI uri;

    CbURIDesc() {
    }

    private static String getPathPart(HttpRequest httpReq) {
        if (httpReq instanceof HttpUriRequest) {
            URI uri = ((HttpUriRequest)httpReq).getURI();
            if (uri == null) {
                return null;
            }
            if (uri.getRawPath() == null) {
                return uri.getHost() != null ? "/" : null;
            }
            if (!uri.getRawPath().startsWith("/")) {
                return uri.getRawPath().length() == 0 ? "/" : null;
            }
            String uriStr = uri.getRawPath();
            if (uri.getQuery() != null) {
                uriStr = uriStr + "?" + uri.getRawQuery();
            }
            if (uri.getFragment() != null) {
                uriStr = uriStr + "#" + uri.getRawFragment();
            }
            return uriStr;
        }
        if (httpReq instanceof HttpEntityEnclosingRequest || httpReq instanceof BasicHttpRequest) {
            RequestLine reqLine = httpReq.getRequestLine();
            if (reqLine == null) {
                return null;
            }
            String uriStr = reqLine.getUri();
            if (uriStr == null) {
                return null;
            }
            if (uriStr.startsWith("/")) {
                return uriStr;
            }
            int index = uriStr.indexOf("://");
            if (index < 0) {
                return null;
            }
            int indexSlash = uriStr.indexOf("/", index + 3);
            if (indexSlash < 0) {
                return null;
            }
            return uriStr.substring(indexSlash);
        }
        return null;
    }

    static CbURIDesc createURIDesc(HttpRequest httpReq, HttpHost host) {
        String path;
        String hostStr;
        CbURIDesc cbURIDesc;
        block6: {
            cbURIDesc = new CbURIDesc();
            hostStr = host == null ? null : host.toString();
            path = CbURIDesc.getPathPart(httpReq);
            if (hostStr != null && path != null) {
                try {
                    cbURIDesc.uri = new URI(hostStr + path);
                    cbURIDesc.host = host.getHostName();
                    cbURIDesc.desc = Utility.truncateWebRequest((String)cbURIDesc.uri.toString());
                    return cbURIDesc;
                }
                catch (URISyntaxException e) {
                    if (!Global.DEBUG) break block6;
                    Utility.zlogD((String)LOGTAG, (String)e.toString(), (Throwable)e);
                }
            }
        }
        if (hostStr == null) {
            cbURIDesc.host = "-";
            hostStr = "-";
        } else {
            cbURIDesc.host = host.getHostName();
        }
        if (path == null) {
            path = "-";
        }
        cbURIDesc.desc = Utility.truncateWebRequest((String)(hostStr + " " + path));
        return cbURIDesc;
    }
}

