/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.callback;

import com.dynatrace.android.callback.CbConstants;
import com.dynatrace.android.callback.ServerTimingAnalyzer;
import java.net.URL;
import java.util.List;
import java.util.Map;

abstract class WebReqStateParms {
    protected String desc;
    CbConstants.WrMethod trackingMethod;
    CbConstants.WrStates state;
    int respCode;
    String reason;
    long requestLength = -1L;
    long responseLength = -1L;
    boolean canFinalize = true;
    String serverTimingValue = null;
    Throwable exception = null;
    Map<String, List<String>> requestHeaders = null;
    Map<String, List<String>> responseHeaders = null;

    WebReqStateParms(CbConstants.WrMethod method, CbConstants.WrStates state, int respCode) {
        this.trackingMethod = method;
        this.state = state;
        this.respCode = respCode;
    }

    abstract boolean isSupportedByGrail();

    abstract String getRequestDesc();

    public abstract Map<String, List<String>> getResponseHeaders();

    public abstract Map<String, List<String>> getRequestHeaders();

    abstract String getRequestHost();

    abstract String getRequestMethod();

    abstract URL getUrl();

    abstract String getRequestClassName();

    abstract Object[] getWebContext();

    protected String getRequestClassName(Object req) {
        String klassName = "NA";
        if (req != null) {
            klassName = req.getClass().getSimpleName();
        }
        return klassName;
    }

    public String toString() {
        return String.format("%s of %s.%s to %s", new Object[]{this.state, this.getRequestClassName(), this.trackingMethod, this.getRequestDesc()});
    }

    public void evaluateServerTiming(List<String> headerValues) {
        ServerTimingAnalyzer analyzer = new ServerTimingAnalyzer();
        this.serverTimingValue = analyzer.analyze(headerValues);
    }
}

