/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.events.ragetap;

import com.dynatrace.android.agent.CustomSegment;
import com.dynatrace.android.agent.EventType;
import com.dynatrace.android.agent.data.Session;
import com.dynatrace.android.agent.events.ragetap.RageTapEventWriter;
import com.dynatrace.android.agent.util.Utility;

public class RageTapSegment
extends CustomSegment {
    private final String activityName;
    private final long firstTapDown;
    private final long lastTapUp;
    private final int numOfTaps;
    private final boolean forwardToGrail;

    private RageTapSegment(Builder builder) {
        super(builder.activityName, 16, builder.session, builder.serverId, builder.forwardToGrail);
        this.mEventStartTime = builder.firstTapDown;
        this.eventType = EventType.RAGE_TAP;
        this.lcSeqNum = builder.sequenceNumber;
        this.activityName = Utility.truncateString((String)builder.activityName, (int)250);
        this.firstTapDown = builder.firstTapDown;
        this.lastTapUp = builder.lastTapUp;
        this.numOfTaps = builder.numOfTaps;
        this.mFinalized = true;
        this.forwardToGrail = builder.forwardToGrail;
    }

    public String getActivityName() {
        return this.activityName;
    }

    public long getFirstTapDown() {
        return this.firstTapDown;
    }

    public long getLastTapUp() {
        return this.lastTapUp;
    }

    public int getNumOfTaps() {
        return this.numOfTaps;
    }

    public boolean getForwardToGrail() {
        return this.forwardToGrail;
    }

    @Override
    public StringBuilder createEventData() {
        return new RageTapEventWriter().toBeaconString(this);
    }

    public static class Builder {
        private String activityName;
        private long firstTapDown;
        private long lastTapUp;
        private int numOfTaps;
        private int serverId;
        private int sequenceNumber;
        private Session session;
        private boolean forwardToGrail;

        public Builder withActivityName(String activityName) {
            this.activityName = activityName;
            return this;
        }

        public Builder withFirstTapDown(long firstTapDown) {
            this.firstTapDown = firstTapDown;
            return this;
        }

        public Builder withLastTapUp(long lastTapUp) {
            this.lastTapUp = lastTapUp;
            return this;
        }

        public Builder withNumOfTaps(int numOfTaps) {
            this.numOfTaps = numOfTaps;
            return this;
        }

        public Builder withSession(Session session) {
            this.session = session;
            return this;
        }

        public Builder withServerId(int serverId) {
            this.serverId = serverId;
            return this;
        }

        public Builder withSequenceNumber(int sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        public Builder withForwardToGrail(boolean forwardToGrail) {
            this.forwardToGrail = forwardToGrail;
            return this;
        }

        public RageTapSegment build() {
            return new RageTapSegment(this);
        }
    }
}

