/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.events.eventsapi;

import com.dynatrace.agent.common.InstrumentationFlavor;
import com.dynatrace.agent.metrics.AppVersion;
import com.dynatrace.android.agent.AdkSettings;
import com.dynatrace.android.agent.Version;
import com.dynatrace.android.agent.conf.Configuration;
import com.dynatrace.android.agent.data.Session;
import com.dynatrace.android.agent.events.eventsapi.EventMetrics;
import com.dynatrace.android.agent.events.eventsapi.format.Formatter;
import com.dynatrace.android.agent.events.eventsapi.format.IdentityFormatter;
import com.dynatrace.android.agent.events.eventsapi.format.ToStringFormatter;
import com.dynatrace.android.agent.metrics.AndroidMetrics;

public class EventMetricsAggregator {
    public static final String TECHNOLOGY_TYPE = "android";
    public static final String OS_NAME = "Android";
    private final Formatter<Session, String> sessionIdFormatter;
    private final Formatter<Long, String> instanceIdFormatter;
    private final Formatter<Long, String> versionCodeFormatter;
    private final Formatter<Integer, String> deviceOrientationFormatter;
    private final Formatter<InstrumentationFlavor, String> instrumentationFlavorFormatter;
    private final Formatter<Integer, Integer> batteryLevelFormatter;

    private EventMetricsAggregator(Builder builder) {
        this.sessionIdFormatter = builder.sessionIdFormatter;
        this.instanceIdFormatter = builder.instanceIdFormatter;
        this.versionCodeFormatter = builder.versionCodeFormatter;
        this.deviceOrientationFormatter = builder.deviceOrientationFormatter;
        this.instrumentationFlavorFormatter = builder.instrumentationFlavorFormatter;
        this.batteryLevelFormatter = builder.batteryLevelFormatter;
    }

    public EventMetrics aggregateEventMetrics(Session session, Configuration configuration, AndroidMetrics androidMetrics) {
        EventMetrics.Builder builder = new EventMetrics.Builder().withAgentVersion(Version.getVersion()).withAgentTechnologyType(TECHNOLOGY_TYPE).withOsName(OS_NAME).withOsVersion(androidMetrics.osVersion).withDeviceManufacturer(androidMetrics.manufacturer).withDeviceModelIdentifier(androidMetrics.modelId).withDeviceRooted(androidMetrics.deviceRooted).withAppBundle(AdkSettings.applIdentifier).withDeviceBatteryLevel(this.batteryLevelFormatter.format(androidMetrics.batteryLevel)).withWindowOrientation(this.deviceOrientationFormatter.format(androidMetrics.deviceOrientation)).withSessionId(this.sessionIdFormatter.format(session)).withInstanceId(this.instanceIdFormatter.format(session.visitorId)).withApplicationId(configuration.applicationId).withAgentFlavor(this.instrumentationFlavorFormatter.format(configuration.instrumentationFlavor)).withSchemaVersion("1.3");
        AppVersion appVersion = androidMetrics.getAppVersion();
        if (appVersion != null) {
            builder.withAppVersion(this.versionCodeFormatter.format(appVersion.getVersionCode()));
            builder.withAppShortVersion(appVersion.getVersionName());
        }
        return builder.build();
    }

    public static class Builder {
        private Formatter<Session, String> sessionIdFormatter = new ToStringFormatter<Session>();
        private Formatter<Long, String> instanceIdFormatter = new ToStringFormatter<Long>();
        private Formatter<Long, String> versionCodeFormatter = new ToStringFormatter<Long>();
        private Formatter<Integer, String> deviceOrientationFormatter = new ToStringFormatter<Integer>();
        private Formatter<InstrumentationFlavor, String> instrumentationFlavorFormatter = new ToStringFormatter<InstrumentationFlavor>();
        private Formatter<Integer, Integer> batteryLevelFormatter = new IdentityFormatter<Integer>();

        public Builder withSessionIdFormatter(Formatter<Session, String> sessionIdFormatter) {
            this.sessionIdFormatter = sessionIdFormatter;
            return this;
        }

        public Builder withInstanceIdFormatter(Formatter<Long, String> instanceIdFormatter) {
            this.instanceIdFormatter = instanceIdFormatter;
            return this;
        }

        public Builder withVersionCodeFormatter(Formatter<Long, String> versionCodeFormatter) {
            this.versionCodeFormatter = versionCodeFormatter;
            return this;
        }

        public Builder withDeviceOrientationFormatter(Formatter<Integer, String> deviceOrientationFormatter) {
            this.deviceOrientationFormatter = deviceOrientationFormatter;
            return this;
        }

        public Builder withInstrumentationFlavorFormatter(Formatter<InstrumentationFlavor, String> instrumentationFlavorFormatter) {
            this.instrumentationFlavorFormatter = instrumentationFlavorFormatter;
            return this;
        }

        public Builder withBatteryLevelFormatter(Formatter<Integer, Integer> batteryLevelFormatter) {
            this.batteryLevelFormatter = batteryLevelFormatter;
            return this;
        }

        public EventMetricsAggregator build() {
            return new EventMetricsAggregator(this);
        }
    }
}

