/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.events.eventsapi;

import com.dynatrace.android.agent.CustomSegment;
import com.dynatrace.android.agent.EventType;
import com.dynatrace.android.agent.data.Session;
import com.dynatrace.android.agent.events.eventsapi.EventWriter;

public class BizEventSegment
extends CustomSegment {
    private final String eventName;
    private final String urlEncodedJsonPayload;
    private final boolean forwardToGrail;

    private BizEventSegment(Builder builder) {
        super(builder.eventName, 17, builder.session, builder.serverId, builder.forwardToGrail);
        this.eventType = EventType.EVENT_BIZ;
        this.mEventStartTime = builder.session.getRunningTime();
        this.eventName = builder.eventName;
        this.urlEncodedJsonPayload = builder.urlEncodedJsonPayload;
        this.mFinalized = true;
        this.forwardToGrail = builder.forwardToGrail;
    }

    public String getEventName() {
        return this.eventName;
    }

    public String getUrlEncodedJsonPayload() {
        return this.urlEncodedJsonPayload;
    }

    public boolean getForwardToGrail() {
        return this.forwardToGrail;
    }

    @Override
    public StringBuilder createEventData() {
        return new EventWriter().toBeaconString(this);
    }

    public static class Builder {
        private String eventName;
        private String urlEncodedJsonPayload;
        private Session session;
        private int serverId;
        private boolean forwardToGrail;

        public Builder withEventName(String eventName) {
            this.eventName = eventName;
            return this;
        }

        public Builder withUrlEncodedJsonPayload(String urlEncodedJsonPayload) {
            this.urlEncodedJsonPayload = urlEncodedJsonPayload;
            return this;
        }

        public Builder withSession(Session session) {
            this.session = session;
            return this;
        }

        public Builder withServerId(int serverId) {
            this.serverId = serverId;
            return this;
        }

        public Builder withForwardToGrail(boolean forwardToGrail) {
            this.forwardToGrail = forwardToGrail;
            return this;
        }

        public BizEventSegment build() {
            return new BizEventSegment(this);
        }
    }
}

