/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.agent.events.error;

import com.dynatrace.agent.events.EventFieldsProvider;
import com.dynatrace.agent.events.enrichment.JsonObjectExtensionsKt;
import com.dynatrace.agent.events.error.ExceptionEventContent;
import com.dynatrace.android.agent.util.Utility;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import org.json.JSONException;
import org.json.JSONObject;

public class ErrorEvent {
    private static final int MAX_SIZE_OF_STACK_TRACE_IN_BYTES = 224000;
    private static final int MAX_SIZE_OF_EXCEPTION_MESSAGE_IN_BYTES = 24000;

    public static JSONObject crashEvent(Throwable throwable) {
        try {
            JSONObject jsonObject = ErrorEvent.generateBaseErrorEvent(throwable);
            jsonObject.put("characteristics.has_crash", true);
            jsonObject.put("error.is_fatal", true);
            Utility.devLog("dtxEventGeneration", "crash event: " + jsonObject);
            return jsonObject;
        }
        catch (JSONException e) {
            Utility.devLog("dtxEventGeneration", "crash event can't be generated");
            return null;
        }
    }

    public static JSONObject errorExceptionEvent(Throwable throwable, String name, boolean isLegacyApiReported) {
        try {
            JSONObject jsonObject = ErrorEvent.generateBaseErrorEvent(throwable);
            jsonObject.put("error.name", (Object)name);
            jsonObject.put("error.has_custom_name", true);
            jsonObject.put("characteristics.has_exception", true);
            if (isLegacyApiReported) {
                jsonObject.put("dt.support.is_legacy_api_reported", true);
            }
            Utility.devLog("dtxEventGeneration", "error event: " + jsonObject);
            return jsonObject;
        }
        catch (JSONException e) {
            Utility.devLog("dtxEventGeneration", "error event can't be generated");
            return null;
        }
    }

    public static ExceptionEventContent exceptionEvent(Throwable throwable, EventFieldsProvider fieldsProvider) {
        try {
            return ErrorEvent.unsafeExceptionEvent(throwable, fieldsProvider);
        }
        catch (JSONException e) {
            Utility.devLog("dtxEventGeneration", "exception event can't be generated");
            return null;
        }
    }

    private static ExceptionEventContent unsafeExceptionEvent(Throwable throwable, EventFieldsProvider fieldsProvider) throws JSONException {
        JSONObject customerJson;
        JSONObject agentJson = new JSONObject();
        try {
            customerJson = fieldsProvider != null ? ErrorEvent.validateFieldsProvider(fieldsProvider) : new JSONObject();
        }
        catch (Exception e) {
            Utility.devLog("dtxEventGeneration", "exception event with problems in EventFieldsProvider");
            agentJson.put("dt.support.api.has_enrich_exception", true);
            customerJson = new JSONObject();
        }
        ExceptionInfo exceptionInfo = ErrorEvent.parseThrowable(throwable, 224000, 24000);
        agentJson.put("characteristics.has_error", true);
        if (exceptionInfo.getMessage() != null) {
            agentJson.put("exception.message", (Object)exceptionInfo.getMessage());
        }
        if (exceptionInfo.getClassName() != null) {
            agentJson.put("exception.type", (Object)exceptionInfo.getClassName());
        }
        if (exceptionInfo.getStacktrace() != null) {
            agentJson.put("exception.stack_trace", (Object)exceptionInfo.getStacktrace());
        }
        agentJson.put("characteristics.has_exception", true);
        Utility.devLog("dtxEventGeneration", "exception event: " + agentJson);
        return new ExceptionEventContent(agentJson, customerJson);
    }

    private static JSONObject validateFieldsProvider(EventFieldsProvider fieldsProvider) throws Exception {
        JSONObject jsonObject = fieldsProvider.get();
        if (jsonObject == null) {
            return new JSONObject();
        }
        JSONObject copiedObject = JsonObjectExtensionsKt.deepCopy(jsonObject);
        return copiedObject;
    }

    public static JSONObject generateErrorEvent(String name, int errorCode, boolean isLegacyApiCall) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("error.name", (Object)name);
            jsonObject.put("error.has_custom_name", true);
            jsonObject.put("characteristics.has_error", true);
            jsonObject.put("error.code", errorCode);
            if (isLegacyApiCall) {
                jsonObject.put("dt.support.is_legacy_api_reported", true);
            }
            Utility.devLog("dtxEventGeneration", "error code event: " + jsonObject);
            return jsonObject;
        }
        catch (JSONException e) {
            Utility.devLog("dtxEventGeneration", "error code event can't be generated");
            return null;
        }
    }

    private static JSONObject generateBaseErrorEvent(Throwable throwable) throws JSONException {
        ExceptionInfo exceptionInfo = ErrorEvent.parseThrowable(throwable, 224000, 24000);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("characteristics.has_error", true);
        if (exceptionInfo.getMessage() != null) {
            jsonObject.put("exception.message", (Object)exceptionInfo.getMessage());
        }
        if (exceptionInfo.getClassName() != null) {
            jsonObject.put("exception.type", (Object)exceptionInfo.getClassName());
        }
        if (exceptionInfo.getStacktrace() != null) {
            jsonObject.put("exception.stack_trace", (Object)exceptionInfo.getStacktrace());
        }
        return jsonObject;
    }

    public static ExceptionInfo parseThrowable(Throwable throwable, int maxStackTraceSizeInBytes, int maxMessageSizeInBytes) {
        StringWriter stacktraceWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stacktraceWriter));
        String stackTrace = stacktraceWriter.toString();
        String sanitizedMessage = null;
        if (throwable.getMessage() != null) {
            sanitizedMessage = ErrorEvent.sanitizeThrowableMessage(throwable.getMessage(), maxMessageSizeInBytes);
        }
        String sanitizedStackTrace = null;
        if (throwable.getStackTrace().length > 0) {
            sanitizedStackTrace = ErrorEvent.sanitizeStackTrace(stackTrace, maxStackTraceSizeInBytes);
        }
        return new ExceptionInfo(throwable.getClass().getName(), sanitizedMessage, sanitizedStackTrace);
    }

    public static ExceptionInfo parseThrowable(Throwable throwable) {
        StringWriter stacktraceWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stacktraceWriter));
        String stackTrace = stacktraceWriter.toString();
        return new ExceptionInfo(throwable.getClass().getName(), throwable.getMessage(), stackTrace);
    }

    private static String sanitizeThrowableMessage(String message, int maxSizeInBytes) {
        byte[] messageBytes = message.getBytes();
        if (messageBytes.length <= maxSizeInBytes) {
            return message;
        }
        return new String(messageBytes, 0, maxSizeInBytes) + "...";
    }

    private static String sanitizeStackTrace(String stackTrace, int maxSizeInBytes) {
        byte[] byteArray = stackTrace.getBytes();
        if (byteArray.length > maxSizeInBytes) {
            return ErrorEvent.truncateAtLineBoundary(stackTrace, maxSizeInBytes);
        }
        return stackTrace;
    }

    private static String truncateAtLineBoundary(String str, int maxSizeInBytes) {
        int currentSize = 0;
        StringBuilder result = new StringBuilder();
        for (String line : str.split("\n")) {
            int lineSize = line.getBytes(StandardCharsets.UTF_8).length + 1;
            if (currentSize + lineSize > maxSizeInBytes) {
                result.append("...");
                return result.toString();
            }
            result.append(line).append("\n");
            currentSize += lineSize;
        }
        result.append("...");
        return result.toString();
    }

    public static class ExceptionInfo {
        private String className;
        private String message;
        private String stacktrace;

        public ExceptionInfo(String className, String message, String stacktrace) {
            this.className = className;
            this.message = message;
            this.stacktrace = stacktrace;
        }

        public String getClassName() {
            return this.className;
        }

        public String getMessage() {
            return this.message;
        }

        public String getStacktrace() {
            return this.stacktrace;
        }
    }
}

