/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.agent.communication.di;

import com.dynatrace.agent.common.connectivity.NetworkConnectivityChecker;
import com.dynatrace.agent.common.time.TimeProvider;
import com.dynatrace.agent.communication.CommunicationManager;
import com.dynatrace.agent.communication.CommunicationManagerImpl;
import com.dynatrace.agent.communication.ResponseProcessorImpl;
import com.dynatrace.agent.communication.api.ServerDataListener;
import com.dynatrace.agent.communication.mapper.DbRecordsToRequestBodyMapperImpl;
import com.dynatrace.agent.communication.network.DynatraceOkHttpClientFactory;
import com.dynatrace.agent.communication.network.datasource.NetworkDataSourceImpl;
import com.dynatrace.agent.communication.network.request.ConfigRequestFactory;
import com.dynatrace.agent.communication.network.request.DataRequestFactory;
import com.dynatrace.agent.communication.network.response.ConfigurationsParser;
import com.dynatrace.agent.communication.network.response.ServerConfigurationManagerV4;
import com.dynatrace.agent.communication.preprocessing.DispatchableDataProvider;
import com.dynatrace.agent.storage.db.EndPointInfo;
import com.dynatrace.agent.storage.db.EventDatabaseDataSource;
import com.dynatrace.android.agent.conf.ServerConfigurationManager;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import okhttp3.Call;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001BI\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0006\u0010\u0014\u001a\u00020\u0015R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/dynatrace/agent/communication/di/CommunicationModule;", "", "httpFactory", "Lokhttp3/Call$Factory;", "timeProvider", "Lcom/dynatrace/agent/common/time/TimeProvider;", "version", "", "dataBaseDataSource", "Lcom/dynatrace/agent/storage/db/EventDatabaseDataSource;", "activeEndpoint", "Lcom/dynatrace/agent/storage/db/EndPointInfo;", "serverDataListener", "Lcom/dynatrace/agent/communication/api/ServerDataListener;", "externalScope", "Lkotlinx/coroutines/CoroutineScope;", "connectivityChecker", "Lcom/dynatrace/agent/common/connectivity/NetworkConnectivityChecker;", "<init>", "(Lokhttp3/Call$Factory;Lcom/dynatrace/agent/common/time/TimeProvider;Ljava/lang/String;Lcom/dynatrace/agent/storage/db/EventDatabaseDataSource;Lcom/dynatrace/agent/storage/db/EndPointInfo;Lcom/dynatrace/agent/communication/api/ServerDataListener;Lkotlinx/coroutines/CoroutineScope;Lcom/dynatrace/agent/common/connectivity/NetworkConnectivityChecker;)V", "provideCommunicationManager", "Lcom/dynatrace/agent/communication/CommunicationManager;", "com.dynatrace.agent_release"})
public final class CommunicationModule {
    @Nullable
    private final Call.Factory httpFactory;
    @NotNull
    private final TimeProvider timeProvider;
    @NotNull
    private final String version;
    @NotNull
    private final EventDatabaseDataSource dataBaseDataSource;
    @NotNull
    private final EndPointInfo activeEndpoint;
    @NotNull
    private final ServerDataListener serverDataListener;
    @NotNull
    private final CoroutineScope externalScope;
    @NotNull
    private final NetworkConnectivityChecker connectivityChecker;

    public CommunicationModule(@Nullable Call.Factory httpFactory, @NotNull TimeProvider timeProvider, @NotNull String version, @NotNull EventDatabaseDataSource dataBaseDataSource, @NotNull EndPointInfo activeEndpoint, @NotNull ServerDataListener serverDataListener, @NotNull CoroutineScope externalScope, @NotNull NetworkConnectivityChecker connectivityChecker) {
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)dataBaseDataSource, (String)"dataBaseDataSource");
        Intrinsics.checkNotNullParameter((Object)activeEndpoint, (String)"activeEndpoint");
        Intrinsics.checkNotNullParameter((Object)serverDataListener, (String)"serverDataListener");
        Intrinsics.checkNotNullParameter((Object)externalScope, (String)"externalScope");
        Intrinsics.checkNotNullParameter((Object)connectivityChecker, (String)"connectivityChecker");
        this.httpFactory = httpFactory;
        this.timeProvider = timeProvider;
        this.version = version;
        this.dataBaseDataSource = dataBaseDataSource;
        this.activeEndpoint = activeEndpoint;
        this.serverDataListener = serverDataListener;
        this.externalScope = externalScope;
        this.connectivityChecker = connectivityChecker;
    }

    @NotNull
    public final CommunicationManager provideCommunicationManager() {
        Call.Factory factory = this.httpFactory;
        if (factory == null) {
            factory = (Call.Factory)DynatraceOkHttpClientFactory.INSTANCE.createOkHttpClientBuilder().build();
        }
        NetworkDataSourceImpl networkDataSource2 = new NetworkDataSourceImpl(factory, new ConfigRequestFactory(this.version), new DataRequestFactory(this.version, (Function0<Long>)((Function0)new Function0<Long>((Object)this.timeProvider){

            public final Long invoke() {
                return ((TimeProvider)this.receiver).millisSinceEpoch();
            }
        }), true), new ConfigurationsParser(new ServerConfigurationManager(this.activeEndpoint.getApplicationId()), new ServerConfigurationManagerV4()), this.connectivityChecker);
        ResponseProcessorImpl responseProcessor = new ResponseProcessorImpl(this.dataBaseDataSource, this.timeProvider);
        DispatchableDataProvider dispatchableDataProvider = new DispatchableDataProvider(this.activeEndpoint, this.dataBaseDataSource, DbRecordsToRequestBodyMapperImpl.Companion.getEnvelopSize$com_dynatrace_agent_release(1), this.timeProvider);
        return new CommunicationManagerImpl(networkDataSource2, dispatchableDataProvider, responseProcessor, this.serverDataListener, this.externalScope, this.connectivityChecker);
    }
}

