/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.agent.api.internal;

import com.dynatrace.agent.api.internal.TraceparentHeader;
import com.dynatrace.agent.events.error.ErrorEvent;
import com.dynatrace.android.agent.util.Utility;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u0000 22\u00020\u0001:\u000223B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\bJ\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u001b\u001a\u00020\u00002\b\u0010\f\u001a\u0004\u0018\u00010\u0003J\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\nJ\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\nJ\u0018\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u00032\b\u0010!\u001a\u0004\u0018\u00010\u0003J\u0016\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\nJ\u0016\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\bJ\u0016\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"J\u0016\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u0015J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0003J\b\u0010$\u001a\u0004\u0018\u00010%J\u001e\u0010&\u001a\u00020'*\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010+\u001a\u0004\u0018\u00010(*\u00020(2\u0006\u0010 \u001a\u00020\u00032\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u0002J\u001c\u0010,\u001a\u00020'*\u00020(2\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u0015H\u0002J\u001e\u0010-\u001a\u00020'*\u00020(2\u0006\u0010 \u001a\u00020\u00032\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u0002J\b\u0010.\u001a\u00020\u0015H\u0002J\b\u0010/\u001a\u00020'H\u0002J\b\u00100\u001a\u00020'H\u0002J\f\u00101\u001a\u00020\u0015*\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0012\u0010\u000e\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/dynatrace/agent/api/internal/HttpRequestEventBuilderInternal;", "", "url", "", "requestMethod", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "duration", "", "statusCode", "", "Ljava/lang/Integer;", "reasonPhrase", "bytesReceived", "bytesSent", "throwable", "", "traceparentHeader", "rawEventProperties", "", "hasDroppedTraceparent", "", "hasDroppedCustomProperties", "hasNfnValues", "withDuration", "durationMilliseconds", "withStatusCode", "withReasonPhrase", "withThrowable", "withBytesSent", "withBytesReceived", "addEventProperty", "key", "value", "", "withTraceparentHeader", "build", "Lcom/dynatrace/agent/api/internal/HttpRequestEventBuilderInternal$HttpRequestEvent;", "putTraceparentInformation", "", "Lorg/json/JSONObject;", "traceparent", "Lcom/dynatrace/agent/api/internal/TraceparentHeader;", "putIfValueNotNull", "putIfTrue", "putSafeEventProperty", "hasValidMandatoryAttributes", "sanitizeTransmittedBytes", "sanitizeStatusCodeAndReason", "isInvalidUrl", "Companion", "HttpRequestEvent", "com.dynatrace.agent_release"})
@SourceDebugExtension(value={"SMAP\nHttpRequestEventBuilderInternal.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpRequestEventBuilderInternal.kt\ncom/dynatrace/agent/api/internal/HttpRequestEventBuilderInternal\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,467:1\n216#2,2:468\n1#3:470\n*S KotlinDebug\n*F\n+ 1 HttpRequestEventBuilderInternal.kt\ncom/dynatrace/agent/api/internal/HttpRequestEventBuilderInternal\n*L\n234#1:468,2\n*E\n"})
public final class HttpRequestEventBuilderInternal {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final String url;
    @NotNull
    private String requestMethod;
    private long duration;
    @Nullable
    private Integer statusCode;
    @Nullable
    private String reasonPhrase;
    @Nullable
    private Integer bytesReceived;
    @Nullable
    private Integer bytesSent;
    @Nullable
    private Throwable throwable;
    @Nullable
    private String traceparentHeader;
    @NotNull
    private final Map<String, Object> rawEventProperties;
    private boolean hasDroppedTraceparent;
    private boolean hasDroppedCustomProperties;
    private boolean hasNfnValues;
    @NotNull
    private static final Set<String> ALLOWED_REQUEST_METHODS;
    @NotNull
    private static final Regex STRICT_HTTP_URL_REGEX;
    private static final int MAX_REASON_PHRASE_LENGTH = 5000;
    @NotNull
    private static final String TC_HINT_SET = "api_set";
    @NotNull
    private static final String TC_HINT_INVALID = "invalid_header";
    @NotNull
    private static final String TC_HINT_UNUSED = "api_unused";

    public HttpRequestEventBuilderInternal(@NotNull String url, @NotNull String requestMethod) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)requestMethod, (String)"requestMethod");
        this.url = url;
        String string = ((Object)StringsKt.trim((CharSequence)requestMethod)).toString().toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        this.requestMethod = string;
        this.rawEventProperties = new LinkedHashMap();
    }

    @NotNull
    public final HttpRequestEventBuilderInternal withDuration(long durationMilliseconds) {
        HttpRequestEventBuilderInternal httpRequestEventBuilderInternal;
        HttpRequestEventBuilderInternal $this$withDuration_u24lambda_u240 = httpRequestEventBuilderInternal = this;
        boolean bl = false;
        $this$withDuration_u24lambda_u240.duration = durationMilliseconds;
        return httpRequestEventBuilderInternal;
    }

    @NotNull
    public final HttpRequestEventBuilderInternal withStatusCode(int statusCode) {
        HttpRequestEventBuilderInternal httpRequestEventBuilderInternal;
        HttpRequestEventBuilderInternal $this$withStatusCode_u24lambda_u241 = httpRequestEventBuilderInternal = this;
        boolean bl = false;
        $this$withStatusCode_u24lambda_u241.statusCode = statusCode;
        return httpRequestEventBuilderInternal;
    }

    @NotNull
    public final HttpRequestEventBuilderInternal withReasonPhrase(@Nullable String reasonPhrase) {
        HttpRequestEventBuilderInternal httpRequestEventBuilderInternal;
        HttpRequestEventBuilderInternal $this$withReasonPhrase_u24lambda_u242 = httpRequestEventBuilderInternal = this;
        boolean bl = false;
        $this$withReasonPhrase_u24lambda_u242.reasonPhrase = reasonPhrase;
        return httpRequestEventBuilderInternal;
    }

    @NotNull
    public final HttpRequestEventBuilderInternal withThrowable(@NotNull Throwable throwable) {
        HttpRequestEventBuilderInternal httpRequestEventBuilderInternal;
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        HttpRequestEventBuilderInternal $this$withThrowable_u24lambda_u243 = httpRequestEventBuilderInternal = this;
        boolean bl = false;
        $this$withThrowable_u24lambda_u243.throwable = throwable;
        return httpRequestEventBuilderInternal;
    }

    @NotNull
    public final HttpRequestEventBuilderInternal withBytesSent(int bytesSent) {
        HttpRequestEventBuilderInternal httpRequestEventBuilderInternal;
        HttpRequestEventBuilderInternal $this$withBytesSent_u24lambda_u244 = httpRequestEventBuilderInternal = this;
        boolean bl = false;
        $this$withBytesSent_u24lambda_u244.bytesSent = bytesSent;
        return httpRequestEventBuilderInternal;
    }

    @NotNull
    public final HttpRequestEventBuilderInternal withBytesReceived(int bytesReceived) {
        HttpRequestEventBuilderInternal httpRequestEventBuilderInternal;
        HttpRequestEventBuilderInternal $this$withBytesReceived_u24lambda_u245 = httpRequestEventBuilderInternal = this;
        boolean bl = false;
        $this$withBytesReceived_u24lambda_u245.bytesReceived = bytesReceived;
        return httpRequestEventBuilderInternal;
    }

    @NotNull
    public final HttpRequestEventBuilderInternal addEventProperty(@NotNull String key, @Nullable String value) {
        HttpRequestEventBuilderInternal httpRequestEventBuilderInternal;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        HttpRequestEventBuilderInternal $this$addEventProperty_u24lambda_u246 = httpRequestEventBuilderInternal = this;
        boolean bl = false;
        $this$addEventProperty_u24lambda_u246.rawEventProperties.put(key, value);
        return httpRequestEventBuilderInternal;
    }

    @NotNull
    public final HttpRequestEventBuilderInternal addEventProperty(@NotNull String key, int value) {
        HttpRequestEventBuilderInternal httpRequestEventBuilderInternal;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        HttpRequestEventBuilderInternal $this$addEventProperty_u24lambda_u247 = httpRequestEventBuilderInternal = this;
        boolean bl = false;
        Integer n = value;
        $this$addEventProperty_u24lambda_u247.rawEventProperties.put(key, n);
        return httpRequestEventBuilderInternal;
    }

    @NotNull
    public final HttpRequestEventBuilderInternal addEventProperty(@NotNull String key, long value) {
        HttpRequestEventBuilderInternal httpRequestEventBuilderInternal;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        HttpRequestEventBuilderInternal $this$addEventProperty_u24lambda_u248 = httpRequestEventBuilderInternal = this;
        boolean bl = false;
        Long l = value;
        $this$addEventProperty_u24lambda_u248.rawEventProperties.put(key, l);
        return httpRequestEventBuilderInternal;
    }

    @NotNull
    public final HttpRequestEventBuilderInternal addEventProperty(@NotNull String key, double value) {
        HttpRequestEventBuilderInternal httpRequestEventBuilderInternal;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        HttpRequestEventBuilderInternal $this$addEventProperty_u24lambda_u249 = httpRequestEventBuilderInternal = this;
        boolean bl = false;
        Double d = value;
        $this$addEventProperty_u24lambda_u249.rawEventProperties.put(key, d);
        return httpRequestEventBuilderInternal;
    }

    @NotNull
    public final HttpRequestEventBuilderInternal addEventProperty(@NotNull String key, boolean value) {
        HttpRequestEventBuilderInternal httpRequestEventBuilderInternal;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        HttpRequestEventBuilderInternal $this$addEventProperty_u24lambda_u2410 = httpRequestEventBuilderInternal = this;
        boolean bl = false;
        Boolean bl2 = value;
        $this$addEventProperty_u24lambda_u2410.rawEventProperties.put(key, bl2);
        return httpRequestEventBuilderInternal;
    }

    @NotNull
    public final HttpRequestEventBuilderInternal withTraceparentHeader(@NotNull String traceparentHeader) {
        HttpRequestEventBuilderInternal httpRequestEventBuilderInternal;
        Intrinsics.checkNotNullParameter((Object)traceparentHeader, (String)"traceparentHeader");
        HttpRequestEventBuilderInternal $this$withTraceparentHeader_u24lambda_u2411 = httpRequestEventBuilderInternal = this;
        boolean bl = false;
        $this$withTraceparentHeader_u24lambda_u2411.traceparentHeader = traceparentHeader;
        return httpRequestEventBuilderInternal;
    }

    @Nullable
    public final HttpRequestEvent build() {
        JSONObject jSONObject;
        TraceparentHeader traceparentHeader;
        Object rawTraceparent;
        if (!this.hasValidMandatoryAttributes()) {
            Utility.devLog("dtxEventGeneration", "HttpRequestEventBuilder dropped invalid event");
            return null;
        }
        this.sanitizeStatusCodeAndReason();
        this.sanitizeTransmittedBytes();
        String string = this.traceparentHeader;
        if (string != null) {
            TraceparentHeader traceparentHeader2;
            rawTraceparent = string;
            boolean bl = false;
            TraceparentHeader parsedTraceparent = traceparentHeader2 = TraceparentHeader.Companion.parse((String)rawTraceparent);
            boolean bl2 = false;
            if (parsedTraceparent == null) {
                this.hasDroppedTraceparent = true;
            }
            traceparentHeader = traceparentHeader2;
        } else {
            traceparentHeader = null;
        }
        TraceparentHeader traceparent = traceparentHeader;
        IntRange intRange = new IntRange(400, 599);
        rawTraceparent = this.statusCode;
        boolean hasFailedRequest = rawTraceparent != null && intRange.contains(((Integer)rawTraceparent).intValue()) || this.throwable != null;
        Object $this$build_u24lambda_u2415 = rawTraceparent = new JSONObject();
        boolean bl = false;
        Map<String, Object> $this$forEach$iv = this.rawEventProperties;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, Object>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> element$iv;
            Map.Entry<String, Object> entry = element$iv = iterator.next();
            boolean bl3 = false;
            String key = entry.getKey();
            Object rawValue = entry.getValue();
            this.putSafeEventProperty((JSONObject)$this$build_u24lambda_u2415, key, rawValue);
        }
        Object eventPropertiesJson = rawTraceparent;
        JSONObject $this$build_u24lambda_u2416 = jSONObject = new JSONObject();
        boolean bl4 = false;
        $this$build_u24lambda_u2416.put("url.full", (Object)this.url);
        $this$build_u24lambda_u2416.put("network.protocol.name", (Object)"http");
        $this$build_u24lambda_u2416.put("http.request.method", (Object)this.requestMethod);
        $this$build_u24lambda_u2416.put("duration", this.duration);
        this.putIfValueNotNull($this$build_u24lambda_u2416, "http.response.status_code", this.statusCode);
        this.putIfValueNotNull($this$build_u24lambda_u2416, "http.response.reason_phrase", this.reasonPhrase);
        this.putIfValueNotNull($this$build_u24lambda_u2416, "request.bytes_sent", this.bytesSent);
        this.putIfValueNotNull($this$build_u24lambda_u2416, "request.bytes_received", this.bytesReceived);
        $this$build_u24lambda_u2416.put("characteristics.has_request", true);
        $this$build_u24lambda_u2416.put("characteristics.is_api_reported", true);
        this.putIfTrue($this$build_u24lambda_u2416, "characteristics.has_failed_request", hasFailedRequest);
        this.putIfTrue($this$build_u24lambda_u2416, "characteristics.has_error", hasFailedRequest);
        if (this.throwable != null) {
            $this$build_u24lambda_u2416.put("characteristics.has_exception", true);
            ErrorEvent.ExceptionInfo exceptionInfo = ErrorEvent.parseThrowable(this.throwable);
            this.putIfValueNotNull($this$build_u24lambda_u2416, "exception.stack_trace", exceptionInfo.getStacktrace());
            this.putIfValueNotNull($this$build_u24lambda_u2416, "exception.type", exceptionInfo.getClassName());
            this.putIfValueNotNull($this$build_u24lambda_u2416, "exception.message", exceptionInfo.getMessage());
        }
        this.putTraceparentInformation($this$build_u24lambda_u2416, traceparent, this.hasDroppedTraceparent);
        this.putIfTrue($this$build_u24lambda_u2416, "dt.support.api.has_dropped_custom_properties", this.hasDroppedCustomProperties || this.hasDroppedTraceparent);
        this.putIfTrue($this$build_u24lambda_u2416, "dt.support.has_nfn_values", this.hasNfnValues);
        JSONObject requestJson = jSONObject;
        return new HttpRequestEvent(requestJson, (JSONObject)eventPropertiesJson);
    }

    private final void putTraceparentInformation(JSONObject $this$putTraceparentInformation, TraceparentHeader traceparent, boolean hasDroppedTraceparent) {
        JSONObject jSONObject;
        if (traceparent != null) {
            $this$putTraceparentInformation.put("trace.id", (Object)traceparent.getTraceId());
            $this$putTraceparentInformation.put("span.id", (Object)traceparent.getParentId());
            jSONObject = $this$putTraceparentInformation.put("request.trace_context_hint", (Object)TC_HINT_SET);
        } else {
            jSONObject = hasDroppedTraceparent ? $this$putTraceparentInformation.put("request.trace_context_hint", (Object)TC_HINT_INVALID) : $this$putTraceparentInformation.put("request.trace_context_hint", (Object)TC_HINT_UNUSED);
        }
    }

    private final JSONObject putIfValueNotNull(JSONObject $this$putIfValueNotNull, String key, Object value) {
        JSONObject jSONObject;
        Object object = value;
        if (object != null) {
            Object it = object;
            boolean bl = false;
            jSONObject = $this$putIfValueNotNull.put(key, value);
        } else {
            jSONObject = null;
        }
        return jSONObject;
    }

    private final void putIfTrue(JSONObject $this$putIfTrue, String key, boolean value) {
        if (value) {
            $this$putIfTrue.put(key, value);
        }
    }

    private final void putSafeEventProperty(JSONObject $this$putSafeEventProperty, String key, Object value) {
        if (!StringsKt.startsWith$default((String)key, (String)"event_properties.", (boolean)false, (int)2, null)) {
            Utility.devLog("dtxEventGeneration", "HttpRequestEventBuilder: dropped event property '" + key + "' as it did not start with prefix 'event_properties.'");
            this.hasDroppedCustomProperties = true;
            return;
        }
        try {
            JSONObject jSONObject;
            Object object = value;
            if (object == null) {
                jSONObject = $this$putSafeEventProperty.put(key, JSONObject.NULL);
            } else if (object instanceof Double) {
                if (Double.isNaN(((Number)value).doubleValue()) || Double.isInfinite(((Number)value).doubleValue())) {
                    $this$putSafeEventProperty.put(key, JSONObject.NULL);
                    this.hasNfnValues = true;
                    jSONObject = Unit.INSTANCE;
                } else {
                    jSONObject = $this$putSafeEventProperty.put(key, ((Number)value).doubleValue());
                }
            } else {
                jSONObject = $this$putSafeEventProperty.put(key, value);
            }
        }
        catch (JSONException jSONException) {
            Utility.devLog("dtxEventGeneration", "HttpRequestEventBuilder: dropped event property '" + key + "' as it could not be parsed into JSON");
            this.hasDroppedCustomProperties = true;
        }
    }

    private final boolean hasValidMandatoryAttributes() {
        boolean isValid = true;
        if (this.isInvalidUrl(this.url)) {
            Utility.devLog("dtxEventGeneration", "HttpRequestEventBuilder: dropped event since given URL is malformed: '" + this.url + '\'');
            isValid = false;
        }
        if (!ALLOWED_REQUEST_METHODS.contains(this.requestMethod)) {
            Utility.devLog("dtxEventGeneration", "HttpRequestEventBuilder: dropped event since given Request Method is invalid: '" + this.requestMethod + '\'');
            isValid = false;
        }
        if (this.duration < 0L) {
            Utility.devLog("dtxEventGeneration", "HttpRequestEventBuilder: dropped event since given Duration is negative");
            isValid = false;
        }
        return isValid;
    }

    private final void sanitizeTransmittedBytes() {
        block3: {
            int it;
            Integer n = this.bytesSent;
            if (n != null) {
                it = ((Number)n).intValue();
                boolean bl = false;
                if (it < 0) {
                    Utility.devLog("dtxEventGeneration", "HttpRequestEventBuilder: dropping invalid value for Bytes Sent: '" + this.bytesSent + '\'');
                    this.bytesSent = null;
                    this.hasDroppedCustomProperties = true;
                }
            }
            Integer n2 = this.bytesReceived;
            if (n2 == null) break block3;
            it = ((Number)n2).intValue();
            boolean bl = false;
            if (it < 0) {
                Utility.devLog("dtxEventGeneration", "HttpRequestEventBuilder: dropping invalid value for Bytes Received: '" + this.bytesReceived + '\'');
                this.bytesReceived = null;
                this.hasDroppedCustomProperties = true;
            }
        }
    }

    private final void sanitizeStatusCodeAndReason() {
        block4: {
            if (this.statusCode == null && this.throwable == null) {
                this.statusCode = 0;
            }
            Integer n = this.statusCode;
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl = false;
                if (it < 0) {
                    Utility.devLog("dtxEventGeneration", "HttpRequestEventBuilder: overriding invalid Status Code with 0");
                    this.statusCode = 0;
                    this.hasDroppedCustomProperties = true;
                }
            }
            String string = this.reasonPhrase;
            if (string == null) break block4;
            String it = string;
            boolean bl = false;
            if (it.length() > 5000) {
                Utility.devLog("dtxEventGeneration", "HttpRequestEventBuilder: trimming too long Reason Phrase to a length of 5000");
                this.reasonPhrase = StringsKt.take((String)it, (int)5000);
            }
        }
    }

    private final boolean isInvalidUrl(String $this$isInvalidUrl) {
        CharSequence charSequence = $this$isInvalidUrl;
        if (!STRICT_HTTP_URL_REGEX.matches(charSequence)) {
            return true;
        }
        return HttpUrl.Companion.parse($this$isInvalidUrl) == null;
    }

    static {
        Object[] objectArray = new String[]{"GET", "HEAD", "POST", "PUT", "DELETE", "CONNECT", "OPTIONS", "TRACE", "PATCH"};
        ALLOWED_REQUEST_METHODS = SetsKt.setOf((Object[])objectArray);
        STRICT_HTTP_URL_REGEX = new Regex("^(https?)://[^\\s/$.?#].[^\\s]*$", RegexOption.IGNORE_CASE);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/dynatrace/agent/api/internal/HttpRequestEventBuilderInternal$Companion;", "", "<init>", "()V", "ALLOWED_REQUEST_METHODS", "", "", "STRICT_HTTP_URL_REGEX", "Lkotlin/text/Regex;", "MAX_REASON_PHRASE_LENGTH", "", "TC_HINT_SET", "TC_HINT_INVALID", "TC_HINT_UNUSED", "com.dynatrace.agent_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\n"}, d2={"Lcom/dynatrace/agent/api/internal/HttpRequestEventBuilderInternal$HttpRequestEvent;", "", "request", "Lorg/json/JSONObject;", "eventProperties", "<init>", "(Lorg/json/JSONObject;Lorg/json/JSONObject;)V", "getRequest", "()Lorg/json/JSONObject;", "getEventProperties", "com.dynatrace.agent_release"})
    public static final class HttpRequestEvent {
        @NotNull
        private final JSONObject request;
        @NotNull
        private final JSONObject eventProperties;

        public HttpRequestEvent(@NotNull JSONObject request, @NotNull JSONObject eventProperties) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)eventProperties, (String)"eventProperties");
            this.request = request;
            this.eventProperties = eventProperties;
        }

        @NotNull
        public final JSONObject getRequest() {
            return this.request;
        }

        @NotNull
        public final JSONObject getEventProperties() {
            return this.eventProperties;
        }
    }
}

